#############################################################################
##
#W  matexam.gi              Polycyc                                  BE & WN
##
##  Some examples of polycylic matrix groups -- MatExamples
##

#############################################################################
##
#F MatExamples(n)
##
MatExamples := function( n )
    local MG;

##
## Plesken/Nebe 1
##
if n = 1 then

MG := [];

MG[1] := [
[ 0, -1,  0, -1,  1, -1,  0,  0,  1,  0,  1,  1,  0,  1,  0, -1 ],
[ 0,  1,  1,  0, -1,  0,  0,  0, -1,  0, -1, -1,  0,  0,  0,  0 ],
[ 0,  0,  1, -1, -1,  0,  0, -1, -1,  0,  0,  0,  0,  1, -1,  0 ],
[ 0,  0, -1,  0,  0,  0,  0,  1,  0,  1,  0, -1,  0,  0,  0,  0 ],
[ 0,  1,  1,  2,  0,  1,  0,  0,  0, -1, -1, -1, -1, -1,  1,  0 ],
[ 0,  1,  0,  1,  0,  0,  0,  0,  0, -1,  0, -1,  0, -1,  1,  1 ],
[ 0,  0, -1,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  0, -1,  0 ],
[ 0,  0,  0, -1, -1,  0,  0, -1,  0,  0,  0,  1,  0,  1, -1,  0 ],
[ 0,  0,  1,  0,  0,  0,  0, -1,  0,  0,  0,  0,  0,  0,  0, -1 ],
[ 0,  1,  0,  0, -1,  0, -1,  0, -1,  0, -1, -1,  0,  0,  0,  0 ],
[ 0,  0,  0, -1,  0, -1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0 ],
[ 0,  0,  0, -1, -1,  0,  0,  0, -1,  0,  0,  0,  1,  1,  0,  0 ],
[ 0,  0,  1,  1,  0,  1,  0,  0,  0,  0,  0, -1,  0, -1,  0,  0 ],
[ 0,  1,  0,  1,  0,  0,  0,  0,  0,  0, -1, -1, -1, -1,  0,  0 ],
[ 0,  0,  0, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 ],
[ 1,  0,  1,  1,  0,  1,  0,  0, -1,  0, -1,  0,  0,  0,  0,  0 ] ];

MG[2] := [
[  0,  0,  0,  0,  0, -1, -1, -1, -1, -1,  1,  1,  0,  0, -1,  1 ],
[  0,  2, -2,  1, -1,  0, -2,  2,  0,  0, -1, -1, -1,  1,  0,  0 ],
[  0,  2, -1,  1, -1,  0, -1,  1, -1, -1, -1, -1,  0,  0,  0,  1 ],
[  0, -1, -1, -1,  0, -1,  0,  0,  0,  1,  1,  1,  1,  0, -1,  0 ],
[  0,  1,  0,  1,  1,  1,  0,  2,  1,  0, -2, -1, -2,  0,  2, -2 ],
[  1,  0,  0,  0,  0,  1,  0,  1,  0,  1, -1,  0,  0,  1,  0, -1 ],
[ -1, -1,  0,  0,  0,  0,  0, -1,  1,  0,  1,  0,  0, -1,  0,  0 ],
[ -1,  1,  0,  0, -1,  0,  0, -1,  0, -1,  0, -1,  0, -1,  0,  1 ],
[  0,  2, -1,  1, -1,  0, -1,  1, -1, -1, -1, -1,  0,  0,  1,  1 ],
[  1,  0, -1,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  1, -1,  0 ],
[  0,  0, -1,  0,  0, -1, -1,  0,  0,  0,  1,  0,  0,  0, -1,  1 ],
[  1,  1, -1,  0, -1,  0, -1,  1, -1,  0,  0,  0,  1,  1, -1,  1 ],
[  0,  1, -1,  0,  0,  0,  0,  1,  0,  0, -1,  0,  0,  0,  1, -1 ],
[ -1,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0, -1, -1,  0,  1, -1 ],
[  1, -1,  0, -1,  0,  0,  0,  0, -1,  1,  1,  1,  1,  1, -2,  0 ],
[  0,  1,  0,  1,  0,  1,  0,  1,  0, -1, -1, -1, -1,  0,  1,  0 ] ];


MG[3] :=  [
[ -2,  1, 0,  1, -1, -1, -2,  0, 1, -1,  1, -2, -1, -1, 0,  0 ],
[  0, -2, 0, -2,  0,  1,  3, -1, 1,  1,  1,  2,  1,  1, 0,  0 ],
[  0,  0, 0,  0, -1,  0,  0,  0, 0,  0,  0,  0,  1,  1, 0,  0 ],
[  0,  0, 0,  0,  0,  0,  0,  0, 0, -1,  0,  1,  0,  1, 0,  0 ],
[  1, -2, 0, -2,  2,  1,  3, -1, 0,  2,  0,  2,  0,  0, 0, -1 ],
[  1, -1, 0, -1,  1,  1,  2,  0, 0,  1,  0,  1,  0,  0, 0,  0 ],
[  0,  0, 0,  0,  0,  0,  0,  0, 0, -1,  0,  1,  0,  0, 0,  0 ],
[  0,  0, 0,  0, -1, -1, -1,  0, 0,  0,  0,  0,  1,  1, 0,  0 ],
[  0,  0, 0,  0,  0,  0,  0,  0, 0,  0, -1,  0,  0,  0, 0, -1 ],
[  0,  0, 0,  0,  0,  1,  2,  0, 1,  0,  0,  0,  0,  0, 1,  1 ],
[ -1,  0, 0,  0, -1,  0,  0,  0, 1, -1,  1,  0,  0,  1, 1,  1 ],
[  0,  0, 0,  0, -1,  0,  0,  0, 0,  0,  0,  0,  0,  1, 0,  1 ],
[  0, -1, 0, -1,  1,  0,  1, -1, 0,  0,  0,  1,  0,  0, 0, -1 ],
[  1, -1, 1, -1,  1,  1,  2, -1, 0,  1, -1,  1,  0,  0, 0, -1 ],
[  0,  1, 0,  0, -1,  0,  0,  0, 0,  0,  0, -1,  0,  0, 0,  1 ],
[  1,  0, 0,  0,  0,  1,  1,  0, 0,  1, -1,  0,  0,  0, 0,  0 ] ];

MG[4] := [
[ 0,  0,  0,  2,  0, 0, -1,  1, 0,  0,  0, -1, 0, -1,  0,  1 ],
[ 0, -1,  0, -1,  1, 0,  2, -1, 2,  0,  1,  1, 0,  0,  1,  0 ],
[ 0,  0,  0,  0,  0, 0,  0,  0, 1,  0,  0,  0, 0,  0,  0,  0 ],
[ 0,  0, -1,  0,  0, 0,  0,  1, 0,  0,  0,  0, 1,  0,  1,  0 ],
[ 0, -1,  1, -2,  1, 0,  2, -2, 0,  0,  1,  1, 0,  0,  0,  0 ],
[ 0,  0,  0, -1,  0, 0,  1, -1, 0,  0,  0,  1, 0,  0,  0,  0 ],
[ 0,  0, -1,  0,  0, 0,  0,  1, 0,  0,  0,  0, 0,  0,  0,  0 ],
[ 0,  0,  0,  0, -1, 0, -1,  0, 0,  0,  0,  0, 0,  1, -1,  0 ],
[ 0,  0,  1,  0,  0, 0,  0, -1, 0, -1,  0,  0, 0,  0,  0,  0 ],
[ 0,  0,  0,  0,  0, 1,  1,  0, 1,  0,  0,  0, 0,  0,  1,  0 ],
[ 0,  0, -1,  1,  0, 0,  0,  1, 1,  0,  0,  0, 0,  0,  1,  1 ],
[ 0,  0,  0,  0,  0, 0,  0,  0, 1,  0,  0,  0, 0,  0,  1,  0 ],
[ 0, -1,  1, -1,  1, 0,  1, -1, 0,  0,  0,  1, 0,  0,  0, -1 ],
[ 0,  0,  0, -1,  0, 0,  1, -1, 0,  0,  0,  0, 0,  0,  0,  0 ],
[ 1,  0,  0,  1,  0, 1,  0,  1, 0,  1, -1,  0, 0,  0,  0,  0 ],
[ 0,  0,  1, -1,  0, 0,  1, -1, 0,  0,  0,  0, 0,  0,  0,  0 ] ];

MG[5] :=  [
[  0,  1, -1,  1, -1, -1, -3,  1, -1, -1,  1, -1,  0,  1,  0,  2 ],
[  1, -2, -1, -2,  1, -1,  1,  0, -1,  2,  1,  3,  2,  0, -2, -1 ],
[  1, -2,  0, -2,  0,  0,  1, -1,  0,  2,  1,  2,  2,  1, -2, -1 ],
[  0,  2, -1,  2,  0,  0, -2,  2, -1, -1, -1, -1, -1,  0,  1,  1 ],
[  0, -3,  1, -3,  1, -1,  3, -2,  1,  3,  1,  2,  1,  0, -1, -2 ],
[  1,  0,  0, -1,  0,  0,  1,  0, -1,  1, -1,  1,  1,  0, -1, -1 ],
[ -2,  1,  0,  2,  0,  0, -1,  0,  1, -2,  0, -2, -2, -1,  2,  1 ],
[  0, -1,  1,  0,  0,  1,  1, -1,  1,  0,  0,  0,  0,  0,  0,  0 ],
[  1, -2,  0, -2,  0,  0,  1, -1,  0,  2,  1,  2,  1,  1, -2, -1 ],
[  1,  1, -1,  0,  0,  0,  0,  1, -1,  0, -1,  1,  1,  0,  0,  0 ],
[  0,  1, -1,  1,  0, -1, -2,  1, -1, -1,  0,  0,  0,  0,  0,  1 ],
[  2,  0, -1, -1,  0,  0,  0,  1, -2,  1,  0,  2,  2,  1, -2,  0 ],
[  1, -1,  0, -1,  0,  0,  1,  0,  0,  2,  0,  1,  1,  1, -1, -1 ],
[ -1, -1,  1,  0,  1,  0,  1, -1,  1,  0,  0,  0, -1, -1,  1, -1 ],
[  1,  2, -1,  1, -1,  0, -2,  2, -2, -1, -1,  0,  1,  1,  0,  1 ],
[  0, -2,  1, -2,  0,  0,  2, -2,  1,  2,  1,  1,  1,  0, -1, -1 ] ];

MG[6] :=  [
[  0,  2, -3,  1, -1, -1, -4,  3, -2, -1,  1, -1,  1,  0,  0,  2 ],
[ -1, -1,  3,  1,  1,  2,  2, -1,  3, -1,  0, -2, -2,  0,  3, -1 ],
[  0, -1,  1,  1,  2,  0,  0,  1,  1,  0,  0,  0, -2,  0,  1, -1 ],
[ -2,  1, -1,  1, -1,  0, -1, -1,  1, -2,  1, -2, -1, -2,  1,  2 ],
[  1, -2,  3, -2,  2,  2,  6, -2,  3,  2, -2,  1,  0,  0,  1, -4 ],
[  1, -1,  2,  0,  0,  2,  2, -1,  1,  1, -1,  0,  0,  1,  0, -1 ],
[ -2,  1, -1,  0, -1, -2, -1, -1,  0, -1,  1, -1,  0, -1,  1,  2 ],
[ -1, -1,  0,  0,  1, -2, -1,  0,  0,  0,  1,  1, -1,  0,  0,  0 ],
[  0, -2,  1, -1,  2,  0,  1,  0,  1,  1,  1,  1, -1,  0,  0, -2 ],
[  0,  1,  1,  2, -1,  2,  0,  0,  1, -1, -1, -2, -1,  0,  1,  1 ],
[ -2,  1,  0,  2, -1,  0, -2,  0,  1, -2,  1, -3, -1, -1,  2,  2 ],
[  0, -1,  1,  1,  0,  1, -1,  0,  1,  0,  1, -1, -1,  1,  0,  0 ],
[  0, -2,  1, -1,  2,  1,  3, -1,  2,  1,  0,  1, -1, -1,  0, -2 ],
[  0, -1,  1, -2,  0,  0,  3, -2,  1,  1,  0,  1,  1,  0,  0, -1 ],
[  1,  1, -1,  1, -2,  1, -2,  1, -1,  0,  0, -1,  1,  1, -1,  2 ],
[  1, -1,  1, -1,  1,  0,  2,  0,  1,  2, -1,  1,  0,  1,  0, -2 ] ];

MG[7] :=  [
[  0,  0,  1, -1, -1, -1, 0, -2,  0,  1, -1, -1,  0,  0, -1, -1 ],
[  0,  0,  0,  1,  1,  0, 0,  1,  0, -1,  0,  0,  0,  1,  2,  1 ],
[  0,  0,  1,  1,  1,  0, 0,  0,  0,  0, -1, -1, -1, -1,  1,  0 ],
[  0,  0,  0,  0,  1,  0, 0,  0,  0,  0,  0,  0, -1,  0,  0, -1 ],
[  0,  0, -2,  1,  0,  1, 0,  3,  0, -1,  2,  1,  2,  1,  1,  2 ],
[  0,  0, -1,  0,  0,  0, 0,  1,  0, -1,  1,  1,  1,  1,  1,  1 ],
[  1,  0,  0, -1,  0,  0, 0,  0, -1,  1, -1,  1,  0,  1, -1, -1 ],
[  0,  0,  1,  0,  0,  0, 0, -1,  0,  1, -1, -1, -1, -1,  0,  0 ],
[  1,  1,  0,  1,  0,  1, 0,  1, -1,  0, -1, -1,  0, -1,  0,  1 ],
[ -1,  0,  0,  1,  1,  0, 0,  0,  1, -2,  0,  0, -1,  0,  2,  0 ],
[ -1, -1,  1, -1,  1, -1, 1, -2,  1,  0,  0,  0, -1,  0,  1, -1 ],
[  0, -1,  1,  0,  1,  0, 1, -1,  1,  0,  0,  0, -1,  0,  1,  0 ],
[  1,  1, -1,  1,  0,  1, 0,  2, -1,  0,  0,  0,  1,  0,  0,  1 ],
[  0,  1, -1,  1,  0,  1, 0,  2,  0, -1,  0,  0,  0,  0,  1,  1 ],
[ -1,  0,  0,  0,  0, -1, 0, -1,  1, -1,  0,  0, -1,  0,  1,  0 ],
[  0,  0,  0,  1,  0,  1, 0,  1,  0, -1,  0,  0,  0,  0,  1,  1 ] ];

MG[8] :=  [
[ -1,  0,  0, -1,  0, -1, -1, -1, 0, 0,  1,  0,  0, 0, -1, -2 ],
[  0,  0,  0,  0,  0,  0,  1, -1, 1, 0,  0, -1, -1, 0,  1,  1 ],
[  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0, -1,  0, 0,  0,  0 ],
[  0,  1, -1,  0, -1,  0, -1,  0, 0, 0, -1,  0,  0, 0,  0,  0 ],
[  0,  0,  0,  0,  0,  0,  2,  0, 1, 0,  0,  0, -1, 0,  1,  2 ],
[  0,  0,  0,  0,  0,  0,  1,  0, 0, 0,  0,  0,  0, 0,  1,  1 ],
[  0,  0,  0,  0,  0,  0, -1,  0, 0, 0,  0,  0,  0, 0,  0,  0 ],
[  0, -1,  1,  0,  1,  0,  0,  0, 0, 0,  0,  0,  0, 0,  0, -1 ],
[  0,  0,  0,  0,  0, -1,  0,  0, 0, 0,  0,  0,  0, 1,  0,  0 ],
[  1,  0,  0,  0,  0,  1,  1,  0, 0, 1, -1,  0,  0, 0,  0,  0 ],
[  0,  0,  0, -1,  0,  0,  0, -1, 0, 0,  0,  0,  0, 0,  0, -1 ],
[  0,  0, -1,  0,  0,  0,  0,  0, 0, 0,  0,  0,  0, 0,  0,  0 ],
[  0,  0,  0,  0, -1,  0,  0,  0, 0, 0,  0,  0,  0, 1,  0,  1 ],
[  0,  0,  0,  0,  0,  0,  1,  0, 1, 0,  0,  0,  0, 0,  1,  1 ],
[  0,  0,  0,  0,  0,  1,  0,  0, 0, 0,  0,  0,  0, 0,  0, -1 ],
[  0,  0,  0,  0,  0,  0,  1,  0, 0, 0,  0,  0,  0, 0,  0,  1 ] ];

MG[9] :=  [
[ -1,  0, 0,  1, 0,  0,  0,  0,  1, -1,  1,  0, 0, -1,  1,  1 ],
[  1,  0, 0,  0, 0,  0, -1,  1, -2,  1, -1,  0, 1,  0, -1, -1 ],
[  0,  0, 0,  0, 0,  0,  0,  1, -1,  0,  0,  0, 1,  0,  0,  0 ],
[  0,  0, 0,  0, 1, -1,  0,  0,  1,  0,  0,  0, 0,  0,  1, -1 ],
[  2, -1, 1, -1, 0,  1,  0,  0, -2,  2, -2,  1, 0,  1, -2, -1 ],
[  1,  0, 0,  0, 0,  0,  0,  0, -1,  1, -1,  0, 0,  0, -1,  0 ],
[ -1,  0, 0, -1, 0, -1,  0, -1,  1,  0,  1,  0, 0,  0,  0, -1 ],
[ -1,  0, 0,  0, 0,  0,  0,  0,  0, -1,  1,  0, 0,  0,  0,  0 ],
[  1, -1, 0,  0, 0,  1,  0,  1, -1,  1,  0,  1, 1,  1, -1,  0 ],
[  1,  1, 0,  1, 0,  0, -1,  1, -1,  0, -1, -1, 0,  0,  0,  0 ],
[ -1,  1, 0,  1, 0, -1, -1,  0,  0, -1,  0, -1, 0, -1,  1,  0 ],
[  0,  0, 0,  1, 1,  0,  0,  1,  0,  0,  0, -1, 0, -1,  1,  0 ],
[  1, -1, 0, -1, 0,  0,  0,  0, -1,  1,  0,  1, 1,  1, -1,  0 ],
[  1,  0, 0, -1, 0,  0,  0,  0, -1,  1, -1,  1, 0,  1, -1, -1 ],
[  0,  1, 0,  1, 0,  0,  0,  0,  0, -1,  0, -1, 0, -1,  1,  1 ],
[  1,  0, 0,  0, 0,  1,  0,  1, -1,  1, -1,  0, 0,  0, -1,  0 ] ];

return Group(MG, MG[1]^0 );

elif n = 2 then

MG := [];

MG[1] := [
[  2, -1, -1,  3 ],
[ -1,  0,  1, -4 ],
[  0,  1,  2, -2 ],
[ -1,  1,  2, -4 ]];

MG[2] := [
[  1, 1,  1, -2 ],
[  1, 1, -1,  1 ],
[ -2, 1,  0, -3 ],
[ -1, 1,  0, -2 ]];

MG[3] := [
[  1, 0, -1,   0 ],
[ -2, 5,  5, -11 ],
[ -1, 0,  2,   0 ],
[ -1, 1,  2,  -2 ]];

MG[4] := [
[  0, 3, 2,  -7 ],
[ -1, 6, 4, -13 ],
[ -1, 2, 1,  -5 ],
[ -1, 3, 2,  -7 ]];

MG[5] := [
[ 0,  4,  5, -12 ],
[ 2, -4,  1,   5 ],
[ 1, -4, -1,   8 ],
[ 1, -3,  0,   5 ]];

MG[6] := [
[  1, 0, -1,   0 ],
[ -2, 5,  5, -11 ],
[ -1, 0,  2,   0 ],
[ -1, 1,  2,  -2 ]];

return Group( MG, MG[1]^0 );

elif n = 3 then

MG := [];

MG[1] := [
[  5, 3, 3,  -5 ],
[  7, 4, 5,  -8 ],
[  2, 1, 2,  -2 ],
[ 10, 6, 7, -11 ]];

MG[2] := [
[ -2, -4, -3,  5 ],
[  4,  7,  5, -8 ],
[ -3, -3, -3,  4 ],
[  1,  2,  1, -2 ]];

MG[3] := [
[  1, -1,  0, 1 ],
[ -4, -2, -2, 5 ],
[ -4, -2, -3, 3 ],
[ -3, -2, -2, 4 ]];

MG[4] := [
[   8,   8,  3, -10 ],
[ -13, -14, -5,  17 ],
[ -13, -14, -5,  18 ],
[  -8,  -9, -3,  11 ]];

MG[5] := [
[ 0, -1, -1,  2 ],
[ 2,  2,  1, -1 ],
[ 2,  3,  1, -5 ],
[ 3,  3,  1, -3 ]];

MG[6] := [
[  2,  1,  0,  0 ],
[  3,  2,  0,  0 ],
[ -7, -8, -3, 11 ],
[ -1, -3, -2,  7 ]];

return Group( MG, MG[1]^0 );

elif n = 4 then

MG :=
[ [ [ -492568055, -715902540, -559233360, 913773168 ],
    [ 853152732, 1239979321, 968620464, -1582701120 ],
    [ 796991748, 1158354480, 904858501, -1478515764 ],
    [ 543797628, 790360020, 617396520, -1008810083 ] ],
  [ [ -348686135, -530151780, -271469520, 913773168 ],
    [ -603941868, -918249479, -470198736, 1582701120 ],
    [ -215499732, -327651600, -167777219, 564742596 ],
    [ -793008492, -1205711460, -617396520, 2078172517 ] ],
  [ [ -151935722, -225045135, -150030090, 330066198 ],
    [ 45009027, 58106404, 90018054, 0 ],
    [ 105021063, 150030090, 133121449, -165033099 ],
    [ -45009027, -75015045, 0, 193133485 ] ],
  [ [ 13, 0, -21, 0 ],
    [ 147, 181, 105, -231 ],
    [ -21, 0, 34, 0 ],
    [ 84, 105, 63, -134 ] ],
  [ [ 670415977, 715902540, 271469520, -913773168 ],
    [ 1161194148, 1239979321, 470198736, -1582701120 ],
    [ -1084755588, -1158354480, -439246739, 1478515764 ],
    [ 607257732, 648459180, 245895000, -827688875 ] ],
  [ [ 814297897, 530151780, 559233360, -913773168 ],
    [ -1410405012, -918249479, -968620464, 1582701120 ],
    [ 503263572, 327651600, 345625141, -564742596 ],
    [ -358046868, -233107740, -245895000, 401786125 ] ],
  [ [ 141577573978831, 92174617804950, 97230886083807, -158872797828558 ],
    [ -245219551343241, -159651121205951, -168408834761919, 275175757779087 ],
    [ 87499752763389, 56967046703190, 60091992355948, -98188788945456 ],
    [ -62251695137616, -40529202794985, -42752445237981, 69856409444878 ] ]
];

return Group( MG, MG[1]^0 );

fi;

return fail;

end;

