/*
 *  Copyright (C) 2006 Takeharu KATO
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#include "common.h"


GThread *ui_thread;
GThread *tcp_thread;

gpointer    
ipmsg_ui_thread(gpointer data){
  GtkWidget *initialContainer;
  GTimer *wait_timer=NULL;
  gulong elapsed;

#if defined(G2IPMSG_SYSTRAY) &&  GTK_CHECK_VERSION(2,10,0)
  if (hostinfo_refer_enable_systray()) {

    /* Note: See:start_message_watcher in recvmsg.c
     * Strictly speaking, status icon is not Gtk Widget,
     * start_message_watcher can distinguish them,
     * so assgin the icon to initialContainer 
     */
    initialContainer = create_ipmsg_status_icon();
    g_assert(initialContainer);

    wait_timer=g_timer_new();  
    g_assert(wait_timer);
    for(elapsed=0;elapsed<STATUS_ICON_WAIT_MICRO_SEC;g_timer_elapsed(wait_timer,&elapsed)) {
      ipmsg_update_ui(); /* 組込み待ちループ */
      if (gtk_status_icon_is_embedded(GTK_STATUS_ICON(initialContainer))) {
	dbg_out("Embedded\n");
	break;
      }
    }
    g_timer_destroy(wait_timer);
  }
  if  ( (!hostinfo_refer_enable_systray()) ||
	(!gtk_status_icon_is_embedded(GTK_STATUS_ICON(initialContainer))) ) {
    g_object_unref(initialContainer);
#endif
    do{
      GtkWidget *startBtn;

      initialContainer = create_initialWindow ();
      startBtn=lookup_widget(initialContainer,"startBtn");
      gtk_widget_set_events (startBtn,GDK_BUTTON_PRESS_MASK);
      gtk_widget_show (initialContainer);
    }while(0);
#if defined(G2IPMSG_SYSTRAY) &&  GTK_CHECK_VERSION(2,10,0)
  }
#endif
  start_message_watcher(initialContainer);

  init_ipmsg();

  gtk_main ();

  cleanup_ipmsg();

  return (gpointer)0;
}

static int
g2ipmsg_main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
		      GNOME_PROGRAM_STANDARD_PROPERTIES,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);
  if (create_lock_file()) {
    exit(1); /* Can not lock */
  }

  hostinfo_init_hostinfo();
  ui_thread=g_thread_create(ipmsg_ui_thread,
				    NULL,
				    TRUE,
				    NULL);
  tcp_thread=g_thread_create(ipmsg_tcp_server_thread,
			     (gpointer)hostinfo_get_ipmsg_system_addr_family(),
			     FALSE,
			     NULL);
  g_thread_join (ui_thread);

  release_lock_file();

  return 0;
}

int 
main(int argc, char *argv[]){
  return g2ipmsg_main(argc,argv);
}

