/****************************************************************************
** Dooble - The Secure Internet Web Browser
**
** Copyright (c) 2008, 2009 Alexis Megas, 
** Gunther van Dooble, and the Dooble Team. 
** All rights reserved.
**
**
** License: GPL2 only: 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; version 2 of the License only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
** or see here: http://www.gnu.org/licenses/gpl.html
**
**
** For the WebKit library, please see: http://webkit.org.
**
** THE CODE IS PROVIDED BY THE AUTHORS ''AS IS'' AND ANY
** EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
** ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
** IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS APPLICATION, EVEN IF ADVISED
** OF THE POSSIBILITY OF SUCH DAMAGE.
**
** Please report all praise, requests, bugs, and problems to the project
** team and administrators: http://sf.net/projects/dooble.
**
** You can find us listed at our project page. New team members are welcome.
** The name of the authors should not be used to endorse or promote products
** derived from Dooble without specific prior written permission.
** If you use this code for other projects, please let us know.
**
** Web sites:
**   http://dooble.net/projects/dooble
**   http://dooble.sf.net
**   http://www.getadooble.com
****************************************************************************/


#include <QSettings>

#include "downloadwindow.h"
#include "downloadwindowitem.h"

downloadwindow::downloadwindow(void):QMainWindow()
{
  ui.setupUi(this);
  ui.clearListPushButton->setEnabled(false);
  connect(ui.closePushButton, SIGNAL(clicked(void)), this,
	  SLOT(slotClose(void)));
  connect(ui.clearListPushButton, SIGNAL(clicked(void)), this,
	  SLOT(slotClearList(void)));
  connect(ui.enterUrlPushButton, SIGNAL(clicked(void)), this,
	  SLOT(slotEnterUrl(void)));
  connect(ui.cancelPushButton, SIGNAL(clicked(void)), this,
	  SLOT(slotCancelDownloadUrl(void)));
  connect(ui.downloadPushButton, SIGNAL(clicked(void)), this,
	  SLOT(slotDownloadUrl(void)));
  slotSetIcons();
}

downloadwindow::~downloadwindow()
{
  close();
}

void downloadwindow::addItem(const QString &srcFileName,
			     const QString &dstFileName)
{
  ui.stackedWidget->setCurrentIndex(0);

  downloadwindowitem *item = new downloadwindowitem();

  connect(item, SIGNAL(downloadFinishedSignal(void)), this,
	  SLOT(slotEnableClearListButton(void)));
  item->download(srcFileName, dstFileName);
  static_cast<QVBoxLayout *> (ui.frame->layout())->insertWidget(0, item);
}

void downloadwindow::addItem(const QUrl &url, const QString &fileName)
{
  ui.stackedWidget->setCurrentIndex(0);

  downloadwindowitem *item = new downloadwindowitem();

  connect(item, SIGNAL(downloadFinishedSignal(void)), this,
	  SLOT(slotEnableClearListButton(void)));
  item->download(url, fileName);
  static_cast<QVBoxLayout *> (ui.frame->layout())->insertWidget(0, item);
}

void downloadwindow::slotClose(void)
{
  close();
}

void downloadwindow::closeEvent(QCloseEvent *event)
{
  if(isVisible())
    {
      QSettings settings;

      settings.setValue("downloadWindow/geometry", geometry());
    }

  event->accept();
}

void downloadwindow::show(void)
{
  if(!isVisible())
    {
      /*
      ** Don't annoy the user.
      */

      QSettings settings;

      if(settings.contains("downloadWindow/geometry"))
	setGeometry(settings.value("downloadWindow/geometry").toRect());

      QMainWindow::show();
    }
#ifdef Q_WS_MAC
  else
    QMainWindow::show();
#endif

  raise();

  if(ui.stackedWidget->currentIndex() == 1)
    ui.urlLineEdit->setFocus();
}

void downloadwindow::slotClearList(void)
{
  QList<downloadwindowitem *> items = findChildren<downloadwindowitem *> ();

  downloadwindowitem *item = 0;

  foreach(item, items)
    {
      if(!item->isDownloading())
	{
	  static_cast<QVBoxLayout *> (ui.frame->layout())->removeWidget(item);
	  item->deleteLater();
	}
    }

  ui.clearListPushButton->setEnabled(false);
}

void downloadwindow::slotEnterUrl(void)
{
  ui.stackedWidget->setCurrentIndex(1);
  ui.urlLineEdit->setFocus();
}

void downloadwindow::slotCancelDownloadUrl(void)
{
  ui.stackedWidget->setCurrentIndex(0);
}

void downloadwindow::slotDownloadUrl(void)
{
  emit saveUrlSignal(ui.urlLineEdit->text().trimmed());
}

void downloadwindow::slotEnableClearListButton(void)
{
  ui.clearListPushButton->setEnabled(true);
}

void downloadwindow::slotSetIcons(void)
{
  QSettings settings;
  QSettings cfgSettings
    (settings.value("iconSet").toString(), QSettings::IniFormat);

  setWindowIcon
    (QIcon(cfgSettings.value("downloadWindow/windowIcon").toString()));
}
