/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __BEAT2VALUE
#define __BEAT2VALUE

#include "multi_curve.h"
#include "solver.h"
#include <string>

struct beat2value {
	
	std::string name; // name for use in console prints

  beat2value (const std::string& name, const std::string& fname);
  ~beat2value ();

  void operator() (float* soln, int n); // solve n values
  void modulate (float* out, float* in, int n, float depth); // modulate n outs with n mods at depth (used by fm/am)

  std::string crvname;
  multi_curve crv; // transfer function is a bezier curve
  solver sol;
  void curve_edited ();

  std::string style; // style of continuation at end of curve (loop or pong)
  xhandler *xmin, *xmax;

  float bpm; // current bpm
  float now; // beat position 
  float delta; // used by the solver
  
  float set_bpm (float n);
  float get_bpm ();

};

void tween (float* buf1, float* buf2, int n, float amount); // interpolate buf2 -> buf1 by amount; store in buf1
void multiply (float* out, float* mul, int n); // multiply n muls with n outs; store in out

#endif
