#!/usr/bin/perl
use warnings;
use strict;
use integer;

my $p1 = qr/.*?(?:(?<!\\right)[\)\]\}]|[^\)\]\}\s])/s;
my $p2 = qr/\s*(?:d|\\Delta\s*)(?!\s)/s;
my $p3 = qr/\S\w*/s;
my $nonprosechar = qr/[^\w\s\.,;:!`'~\?\{\}-]/s;
my $pp = '%-10s %4d';
my $old = '';
my $printme = 0;
my $printedold = 0;

MAINLOOP: while (<>) {
    s/(?<!\\)%.*$//;
    $printedold = $printme;
    my $a = "$old$_";
    $printme = 0;
    INLOOP: while ($a =~ /(${p1})(${p2})(${p3})/sg) {
        my ($c, $d, $e) = ($1, $2, $3);
        next INLOOP if $c =~ /\\,$/s || $e =~ /^\w\w/s;
        if ($e =~ /^${nonprosechar}/s) {
            $printme = 1;
            next INLOOP;
        }
        {
            my $aa = $a;
            $aa =~ s/\\(?:ref|emph|footnote)\{(?:[^\\\{\}\$\[\]]*\})??//sg;
            next INLOOP unless $aa =~ /${nonprosechar}/s || $aa =~ /(?:-+(?!-).*){2}/s;
        }
        $printme = 1;
    }
    if ($printme) {
        printf "${pp}-%s", $ARGV, $.-1, $old unless $printedold;
        printf "${pp}:%s", $ARGV, $.  , $_;
    }
    $old = $_;
}

