﻿' Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com 

Imports System
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config

Namespace Db4odoc.Storage
    Class StorageExample
        Private Const Db4oFileName As [String] = "reference.db4o"

        Public Shared Sub Main(ByVal args As String())
            StorePilot()
            DeletePilot()
        End Sub

        Public Shared Sub StorePilot()
            Dim db As IObjectContainer = Db4oEmbedded.OpenFile(GetLoggingStorage(), Db4oFileName)
            Dim p As New Pilot("Michael Schumacher", 100)
            db.Store(p)
            db.Close()
        End Sub

        Public Shared Sub DeletePilot()
            Dim db As IObjectContainer = Db4oEmbedded.OpenFile(GetLoggingStorage(), Db4oFileName)
            Dim pilots As IObjectSet = db.QueryByExample(New Pilot(Nothing, 0))
            Dim pilot As Pilot = DirectCast(pilots(0), Pilot)
            System.Console.WriteLine(pilot)
            System.Console.WriteLine()

            db.Delete(pilot)
            db.Close()
        End Sub

        Public Shared Function GetLoggingStorage() As IEmbeddedConfiguration
            Dim config As IEmbeddedConfiguration = Db4oEmbedded.NewConfiguration()
            config.File.Storage = New LoggingStorage()
            Return config
        End Function

    End Class
End Namespace
