/* Copyright (C) 2004 - 2009 Versant Inc. http://www.db4o.com */

package com.db4odoc.debugging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;

import com.db4o.Db4oEmbedded;
import com.db4o.ObjectContainer;
import com.db4o.config.EmbeddedConfiguration;
import com.db4o.query.Query;

public class DebugExample {
	private final static String DB4O_FILE_NAME="reference.db4o";

	public static void main(String[] args) {
		setCars();
		try {
			setCarsWithFileOutput();
		} catch (Exception ex) {
			//
		}
	}
	// end main

	private static void setCars()
	{
		 // Set the debug message level to the maximum
		EmbeddedConfiguration configuration = Db4oEmbedded.newConfiguration();
		configuration.common().messageLevel(3);
		
		 // Do some db4o operations
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container=Db4oEmbedded.openFile(configuration, DB4O_FILE_NAME);
		try {
			Car car1 = new Car("BMW");
			container.store(car1);
			Car car2 = new Car("Ferrari");
			container.store(car2);
			container.deactivate(car1,2);
			Query query = container.query();
			query.constrain(Car.class);
			List<Car> results = query.execute();
			listResult(results);
		} finally {
			container.close();
		}
	}
	// end setCars
	
	private static void setCarsWithFileOutput() throws FileNotFoundException
	{
		// Create StreamWriter for a file
		FileOutputStream fos = new FileOutputStream("Debug.txt");
		PrintStream debugWriter = new PrintStream(fos);
        
        // Redirect debug output to the specified writer
		EmbeddedConfiguration configuration = Db4oEmbedded.newConfiguration();
		configuration.common().outStream(debugWriter);
        
        // Set the debug message level to the maximum
		configuration.common().messageLevel(3);
		
		 // Do some db4o operations
		 new File(DB4O_FILE_NAME).delete();
		 ObjectContainer container=Db4oEmbedded.openFile(configuration, DB4O_FILE_NAME);
		try {
			Car car1 = new Car("BMW");
			container.store(car1);
			Car car2 = new Car("Ferrari");
			container.store(car2);
			container.deactivate(car1,2);
			Query query = container.query();
			query.constrain(Car.class);
			List<Car> results = query.execute();
			listResult(results);
		} finally {
			container.close();
			debugWriter.close();
		}
	}
	// end setCarsWithFileOutput
	
	private static<T> void listResult(List<T> result) {
        System.out.println(result.size());
        for (T t: result){
            System.out.println(t);
        }
    }
    // end listResult
}
