info = {
    "name": "he",
    "date_order": "DMY",
    "january": [
        "ינואר",
        "ינו׳",
        "לינואר",
        "בינואר",
        "ינו"
    ],
    "february": [
        "פברואר",
        "פבר׳",
        "בפברואר",
        "לפברואר",
        "פבר"
    ],
    "march": [
        "מרץ",
        "במרץ",
        "למרץ",
        "מרס",
        "במרס",
        "למרס",
        "מארס",
        "במארס",
        "למארס"
    ],
    "april": [
        "אפריל",
        "אפר׳",
        "באפריל",
        "לאפריל",
        "אפר"
    ],
    "may": [
        "מאי",
        "במאי",
        "למאי"
    ],
    "june": [
        "יוני",
        "ביוני",
        "ליוני",
        "יונ"
    ],
    "july": [
        "יולי",
        "ביולי",
        "ליולי",
        "יול"
    ],
    "august": [
        "אוגוסט",
        "אוג׳",
        "באוגוסט",
        "לאוגוסט",
        "אוג"
    ],
    "september": [
        "ספטמבר",
        "ספט׳",
        "בספטמבר",
        "לספטמבר",
        "ספט"
    ],
    "october": [
        "אוקטובר",
        "אוק׳",
        "באוקטובר",
        "לאוקטובר",
        "אוק"
    ],
    "november": [
        "נובמבר",
        "נוב׳",
        "בנובמבר",
        "לנובמבר",
        "נוב"
    ],
    "december": [
        "דצמבר",
        "דצמ׳",
        "בדצמבר",
        "לדצמבר",
        "דצמ"
    ],
    "monday": [
        "יום ב׳",
        "יום שני",
        "שני",
        "יום ב"
    ],
    "tuesday": [
        "יום ג׳",
        "יום שלישי",
        "שלישי",
        "יום ג"
    ],
    "wednesday": [
        "יום ד׳",
        "יום רביעי",
        "רביעי",
        "יום ד"
    ],
    "thursday": [
        "יום ה׳",
        "יום חמישי",
        "חמישי",
        "יום ה"
    ],
    "friday": [
        "יום ו׳",
        "יום שישי",
        "שישי",
        "יום ו"
    ],
    "saturday": [
        "יום שבת",
        "שבת"
    ],
    "sunday": [
        "יום א׳",
        "יום ראשון",
        "ראשון",
        "יום א"
    ],
    "am": [
        "לפנה״צ"
    ],
    "pm": [
        "אחה״צ"
    ],
    "year": [
        "שנה",
        "שנ׳",
        "שנים",
        "בשנה"
    ],
    "month": [
        "חודש",
        "חו׳",
        "חודשים",
        "בחודש"
    ],
    "week": [
        "שבוע",
        "שב׳",
        "שבועות"
    ],
    "day": [
        "יום",
        "ימים",
        "ביום"
    ],
    "hour": [
        "שעה",
        "שע׳",
        "שעות"
    ],
    "minute": [
        "דקה",
        "דק׳",
        "דקות"
    ],
    "second": [
        "שנייה",
        "שנ׳",
        "שניה",
        "שניות"
    ],
    "relative-type": {
        "0 day ago": [
            "היום"
        ],
        "0 hour ago": [
            "בשעה זו"
        ],
        "0 minute ago": [
            "בדקה זו"
        ],
        "0 month ago": [
            "החודש"
        ],
        "0 second ago": [
            "עכשיו"
        ],
        "0 week ago": [
            "השבוע"
        ],
        "0 year ago": [
            "השנה"
        ],
        "1 day ago": [
            "אתמול"
        ],
        "1 month ago": [
            "החודש שעבר"
        ],
        "1 week ago": [
            "השבוע שעבר"
        ],
        "1 year ago": [
            "השנה שעברה"
        ],
        "in 1 day": [
            "מחר"
        ],
        "in 1 month": [
            "החודש הבא"
        ],
        "in 1 week": [
            "השבוע הבא"
        ],
        "in 1 year": [
            "השנה הבאה"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "לפני (\\d+[.,]?\\d*) ימים",
            "לפני (\\d+[.,]?\\d*) ימ׳",
            "לפני יום (\\d+[.,]?\\d*)"
        ],
        "\\1 hour ago": [
            "לפני (\\d+[.,]?\\d*) שעות",
            "לפני (\\d+[.,]?\\d*) שע׳"
        ],
        "\\1 minute ago": [
            "לפני (\\d+[.,]?\\d*) דקות",
            "לפני (\\d+[.,]?\\d*) דק׳"
        ],
        "\\1 month ago": [
            "לפני (\\d+[.,]?\\d*) חודשים",
            "לפני (\\d+[.,]?\\d*) חו׳"
        ],
        "\\1 second ago": [
            "לפני (\\d+[.,]?\\d*) שניות",
            "לפני (\\d+[.,]?\\d*) שנ׳"
        ],
        "\\1 week ago": [
            "לפני (\\d+[.,]?\\d*) שבועות",
            "לפני (\\d+[.,]?\\d*) שב׳"
        ],
        "\\1 year ago": [
            "לפני (\\d+[.,]?\\d*) שנים"
        ],
        "in \\1 day": [
            "בעוד (\\d+[.,]?\\d*) ימים",
            "בעוד (\\d+[.,]?\\d*) ימ׳",
            "בעוד יום (\\d+[.,]?\\d*)"
        ],
        "in \\1 hour": [
            "בעוד (\\d+[.,]?\\d*) שעות",
            "בעוד (\\d+[.,]?\\d*) שע׳"
        ],
        "in \\1 minute": [
            "בעוד (\\d+[.,]?\\d*) דקות",
            "בעוד (\\d+[.,]?\\d*) דק׳"
        ],
        "in \\1 month": [
            "בעוד (\\d+[.,]?\\d*) חודשים",
            "בעוד (\\d+[.,]?\\d*) חו׳"
        ],
        "in \\1 second": [
            "בעוד (\\d+[.,]?\\d*) שניות",
            "בעוד (\\d+[.,]?\\d*) שנ׳"
        ],
        "in \\1 week": [
            "בעוד (\\d+[.,]?\\d*) שבועות",
            "בעוד (\\d+[.,]?\\d*) שב׳"
        ],
        "in \\1 year": [
            "בעוד (\\d+[.,]?\\d*) שנים"
        ]
    },
    "locale_specific": {},
    "sentence_splitter_group": 1,
    "skip": [
        "ב-",
        "בסביבות",
        "בערך",
        "בקירוב",
        "בשעה",
        "ה-",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "ago": [
        "לפני"
    ],
    "in": [
        "בעוד",
        "עוד"
    ],
    "simplifications": [
        {
            "ויום": "1 יום"
        },
        {
            "ושבוע": "1 שבוע"
        },
        {
            "וחודש": "1 חודש"
        },
        {
            "ושנה": "1 שנה"
        },
        {
            "ו(\\w+)": "\\1"
        },
        {
            "שנתיי?ם": "2 שנים"
        },
        {
            "חודשיים": "2 חודשים"
        },
        {
            "שבועיי?ם": "2 שבועות"
        },
        {
            "יומיי?ם": "2 ימים"
        },
        {
            "שעתיי?ם": "2 שעות"
        },
        {
            "שלשום": "2 ימים"
        },
        {
            "מחר": "בעוד 1 יום"
        },
        {
            "אחר חצות": "am"
        },
        {
            "חצות": "12 am"
        },
        {
            "לפנות בוקר": "am"
        },
        {
            "בבוקר": "am"
        },
        {
            "בצהריי?ם": "pm"
        },
        {
            "אחרי ה?צהריי?ם": "pm"
        },
        {
            "אחה\"צ": "pm"
        },
        {
            "לפנות ערב": "pm"
        },
        {
            "בערב": "pm"
        }
    ]
}
