# -*- coding: utf-8 -*-
info = {
    "name": "sk",
    "date_order": "DMY",
    "january": [
        "január",
        "jan",
        "januára"
    ],
    "february": [
        "február",
        "feb",
        "februára"
    ],
    "march": [
        "marec",
        "mar",
        "marca"
    ],
    "april": [
        "apríl",
        "apr",
        "apríla"
    ],
    "may": [
        "máj",
        "mája"
    ],
    "june": [
        "jún",
        "júna"
    ],
    "july": [
        "júl",
        "júla"
    ],
    "august": [
        "august",
        "aug",
        "augusta"
    ],
    "september": [
        "september",
        "sep",
        "septembra"
    ],
    "october": [
        "október",
        "okt",
        "októbra"
    ],
    "november": [
        "november",
        "nov",
        "novembra"
    ],
    "december": [
        "december",
        "dec",
        "decembra"
    ],
    "monday": [
        "pondelok",
        "po"
    ],
    "tuesday": [
        "utorok",
        "ut"
    ],
    "wednesday": [
        "streda",
        "st"
    ],
    "thursday": [
        "štvrtok",
        "št"
    ],
    "friday": [
        "piatok",
        "pi"
    ],
    "saturday": [
        "sobota",
        "so"
    ],
    "sunday": [
        "nedeľa",
        "ne"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "rok",
        "r"
    ],
    "month": [
        "mesiac",
        "mes"
    ],
    "week": [
        "týždeň",
        "týž"
    ],
    "day": [
        "deň",
        "d"
    ],
    "hour": [
        "hodina",
        "h"
    ],
    "minute": [
        "minúta",
        "min"
    ],
    "second": [
        "sekunda",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "minulý rok"
        ],
        "0 year ago": [
            "tento rok"
        ],
        "in 1 year": [
            "budúci rok"
        ],
        "1 month ago": [
            "minulý mesiac"
        ],
        "0 month ago": [
            "tento mesiac"
        ],
        "in 1 month": [
            "budúci mesiac"
        ],
        "1 week ago": [
            "minulý týždeň"
        ],
        "0 week ago": [
            "tento týždeň"
        ],
        "in 1 week": [
            "budúci týždeň"
        ],
        "1 day ago": [
            "včera"
        ],
        "0 day ago": [
            "dnes"
        ],
        "in 1 day": [
            "zajtra"
        ],
        "0 hour ago": [
            "v tejto hodine"
        ],
        "0 minute ago": [
            "v tejto minúte"
        ],
        "0 second ago": [
            "teraz"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "o (\\d+) rok",
            "o (\\d+) rokov",
            "o (\\d+) r"
        ],
        "\\1 year ago": [
            "pred (\\d+) rokom",
            "pred (\\d+) rokmi",
            "pred (\\d+) r"
        ],
        "in \\1 month": [
            "o (\\d+) mesiac",
            "o (\\d+) mesiacov",
            "o (\\d+) mes"
        ],
        "\\1 month ago": [
            "pred (\\d+) mesiacom",
            "pred (\\d+) mesiacmi",
            "pred (\\d+) mes"
        ],
        "in \\1 week": [
            "o (\\d+) týždeň",
            "o (\\d+) týždňov",
            "o (\\d+) týž"
        ],
        "\\1 week ago": [
            "pred (\\d+) týždňom",
            "pred (\\d+) týždňami",
            "pred (\\d+) týž"
        ],
        "in \\1 day": [
            "o (\\d+) deň",
            "o (\\d+) dní",
            "o (\\d+) d"
        ],
        "\\1 day ago": [
            "pred (\\d+) dňom",
            "pred (\\d+) dňami",
            "pred (\\d+) d"
        ],
        "in \\1 hour": [
            "o (\\d+) hodinu",
            "o (\\d+) hodín",
            "o (\\d+) h"
        ],
        "\\1 hour ago": [
            "pred (\\d+) hodinou",
            "pred (\\d+) hodinami",
            "pred (\\d+) h"
        ],
        "in \\1 minute": [
            "o (\\d+) minútu",
            "o (\\d+) minút",
            "o (\\d+) min"
        ],
        "\\1 minute ago": [
            "pred (\\d+) minútou",
            "pred (\\d+) minútami",
            "pred (\\d+) min"
        ],
        "in \\1 second": [
            "o (\\d+) sekundu",
            "o (\\d+) sekúnd",
            "o (\\d+) s"
        ],
        "\\1 second ago": [
            "pred (\\d+) sekundou",
            "pred (\\d+) sekundami",
            "pred (\\d+) s"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}