#!/bin/sh

# called by uscan with '--upstream-version' <version> <file>

VERSION=$2
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
TAR=../${SOURCE}_${VERSION}.orig.tar.gz

tar xf $3 --exclude '*.gif' --exclude '*.pdf' --exclude '*.html' 
make -C cvxopt-$2/doc clean
chmod ugo-x cvxopt-$2/examples/doc/*/*.py cvxopt-$2/examples/book/*/*.py

tar czf $TAR cvxopt-$2
rm -rf cvxopt-$2

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0
