'\"
'\" Generated from file '/home/aku/Projects/Packages/Critcl/dev-master/embedded/man/files/critcl_installer\&.n' by tcllib/doctools with format 'nroff'
'\" Copyright (c) Jean-Claude Wippler
'\" Copyright (c) Steve Landers
'\" Copyright (c) 2011-2013 Andreas Kupries
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "critcl_install_guide" n 3\&.1\&.8 doc "C Runtime In Tcl (CriTcl)"
.BS
.SH NAME
critcl_install_guide \- Critcl - The Installer's Guide
.SH DESCRIPTION
Welcome to the \fIC Runtime In Tcl\fR, \fICriTcl\fR for short, a
system to build C extension packages for Tcl on the fly, from C code
embedded within Tcl scripts, for all who wish to make their code go
faster\&.
.PP
The audience of this document is anyone wishing to build the
packages, for either themselves, or others\&.
.PP
For a developer intending to extend or modify the packages we
additionally provide
.IP [1]
\fICritcl - License\fR\&.
.IP [2]
\fICritcl - The Developer's Guide\fR\&.
.PP
.PP
Please read \fICritcl - How To Get The Sources\fR first, if that was
not done already\&. Here we assume that the sources are already
available in a directory of your choice\&.
.PP
.SH REQUISITES
Before Critcl can be build and used a number of requisites must be installed\&. These are:
.IP [1]
The scripting language Tcl\&.
For details see \fBTcl\fR\&.
.IP [2]
Various packages from the Tcllib bundle for \fBTcl\fR\&.
For details see \fBTcllib\fR\&.
.PP
This list assumes that the machine where Critcl is to be installed is
essentially clean\&. Of course, if parts of the dependencies listed
below are already installed the associated steps can be skipped\&. It is
still recommended to read their sections though, to validate that the
dependencies they talk about are indeed installed\&.
.SS TCL
As we are building a Tcl package that should be pretty much obvious
that a working Tcl installation is needed, and I will not belabor the
point\&.
.PP
Out of the many use whatever you are comfortable with, as long
as it provides Tcl 8\&.5, or higher, and Tk 8\&.5 or higher\&.
.PP
This may a Tcl installation provided by your operating system
distribution, from a distribution-independent vendor, or built by
yurself\&.
.PP
Myself, I used \fIActiveState's\fR [http://www\&.activestate\&.com]
ActiveTcl 8\&.5 distribution during development of the binding, as I am
most familiar with it\&.
.PP
\fI(Disclosure: I, Andreas Kupries, work for ActiveState, maintaining ActiveTcl and TclDevKit for them)\&.\fR
.PP
This distribution can be found at
\fIhttp://www\&.activestate\&.com/activetcl\fR\&. Retrieve the archive of
ActiveTcl 8\&.5 for your platform and install it as directed by
ActiveState\&.
.PP
Assuming that ActiveTcl got installed I usually run the command
.CS


    teacup update

.CE
to install all packages ActiveState provides, and the kitchensink, as
the distribution itself usually contains only the ost important set of
packages\&. This ensures that the dependencies for Critcl are all
present, and more\&.
.PP
If that is not to your liking you have to read the sections for
Critcl to determine the exact set of packages required, and install
only these using
.CS


    teacup install $packagename

.CE
.PP
Both \fBteacup\fR commands above assume that ActiveState's
TEApot repository at \fIhttp://teapot\&.activestate\&.com\fR is in the
list of repositories accessible to \fBteacup\fR\&. This is automatically
ensured for the ActiveTcl distribution\&. Others may have to run
.CS


    teacup archive add http://teapot\&.activestate\&.com

.CE
to make this happen\&.
.PP
For those wishing to build Tcl/Tk on their own, their sources
can be found at
.TP
Tcl
\fIhttp://core\&.tcl\&.tk/tcl/\fR
.TP
Tk
\fIhttp://core\&.tcl\&.tk/tk/\fR
.PP
.SS TCLLIB
To use Critcl a few packages found in the Tcllib bundle are
required\&. These packages are:
.IP [1]
\fBcmdline\fR
.IP [2]
\fBmd5\fR\&.
.sp
And to accelerate this package, it is recommend to get and
install one of
.RS
.IP [1]
\fBtcllibc\fR
.IP [2]
\fBmd5c\fR
.IP [3]
\fBTrf\fR
.RE
.IP
The system will work without them, but can become quite slow,
especially when handling large code blocks\&.
.IP [3]
\fBsnit\fR
.PP
.PP
Assuming that ActiveTcl is installed, or some other Tcl
installation with \fBteacup\fR available, most (not md5c) of these
packages can be installed via
.CS


    teacup install $packagename

.CE
.PP
The \fBteacup\fR command above assumes that ActiveState's
TEApot repository at \fIhttp://teapot\&.activestate\&.com\fR is in the
list of repositories accessible to \fBteacup\fR\&. This is automatically
ensured for the ActiveTcl distribution\&. Others may have to run
.CS


    teacup archive add http://teapot\&.activestate\&.com

.CE
to make this happen\&.
.PP
Now, for those wishing to install the packages from source,
the CVS repository for the two bundles can be found at
\fIhttps://sourceforge\&.net/projects/tcllib\fR\&.
.PP
Releases of Tcllib can be found in the associated Files
section, or CVS can be used to check out the sub-project tcllib\&.
.PP
Tcllib comes with its own installation instructions\&. These will
not be repeated here\&. If there are problems with its directions please
file a bug against the Tcllib project at the above url, and not
Critcl\&.
.SH "BUILD & INSTALLATION"
To install Critcl simply run
.CS


    /path/to/tclsh /path/to/critcl/build\&.tcl install

.CE
where "\fI/path/to/tclsh\fR" is the tclsh of your Tcl installation, and
"\fI/path/to/critcl\fR" the location of the Critcl sources on your system\&.
.PP
This builds all packages and then places them in a directory where the
\fBtclsh\fR will find them\&.
.PP
It further creates a "\fIcritcl\fR" application script and places it
into the directory \fBtclsh\fR resides in, making it a sibling of that
executable\&. The critcl application is written to use that executable
as well, and not search for it in the \fBPATH\fR\&.
.PP
On Windows you can invoke the file "\fIbuild\&.tcl\fR" with a
double-click\&.  This will pop up a small graphical interface for
entering the destination and performing the installation\&. This
handling of a double-click is restricted to Windows only however\&.
.PP
On unix the same GUI is acessible by invoking "\fIbuild\&.tcl\fR" without
any arguments\&.
.PP
To get help about the methods of "\fIbuild\&.tcl\fR", and their complete
syntax, invoke  "\fIbuild\&.tcl\fR" with argument \fBhelp\fR, i\&.e\&., like
.CS


    /path/to/tclsh /path/to/critcl/build\&.tcl help

.CE
.SH "FIRST USE, TESTING THE INSTALLATION"
With critcl installed it is now the time to try at least one of the
examples distributed with it\&. This will also test if the installation
was successful\&.
.PP
Below I show the steps to generate and then use the low- and
high-level stack example packages\&. I am intentionally bypassing the
"\fIbuild\&.tcl\fR" file the example is coming with, to show the use of
\fBcritcl\fR itself\&.
.PP
.CS



    > cd examples/stack
    > /path/to/critcl -keep -cache B -pkg cstack\&.tcl
    > /path/to/critcl -keep -cache B -pkg stackc\&.tcl
    > tclsh
    % lappend auto_path [pwd]/lib
    % package require stackc
    % join [info loaded] \\n
    % stackc S
    % S push FOO
    % S size
    % S destroy
    % exit
    >

.CE
.PP
Some explanations:
.IP \(bu
The example shows only the commands entered on the shell (and
tclsh) command line\&. Their responses are left out\&.
.IP \(bu
Use of option \fB-keep\fR causes critcl to leave the
generated \&.c files behind, for edification\&. Normally this
happens only in case of trouble\&.
.IP \(bu
Use of option \fB-cache\fR redirects the location of the
directory to hold generated and build files to a local
directory with a known name, for an easy look after\&.
.IP \(bu
Both \fBcstack\fR and \fBstackc\fR have to use the
\fIsame\fR \fB-cache\fR so that \fBstackc\fR will
find the stub table headers exported by \fBcstack\fR\&.
.PP
.SH AUTHORS
Jean Claude Wippler, Steve Landers, Andreas Kupries
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report them at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR\&.
Ideas for enhancements you may have for either package, application,
and/or the documentation are also very welcome and should be reported
at \fIhttps://github\&.com/andreas-kupries/critcl/issues\fR as well\&.
.SH KEYWORDS
C code, Embedded C Code, code generator, compile & run, compiler, dynamic code generation, dynamic compilation, generate package, linker, on demand compilation, on-the-fly compilation
.SH CATEGORY
Glueing/Embedded C code
.SH COPYRIGHT
.nf
Copyright (c) Jean-Claude Wippler
Copyright (c) Steve Landers
Copyright (c) 2011-2013 Andreas Kupries

.fi