/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQSequenceType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xqj.SaxonXQItemType;

public class SaxonXQSequenceType
implements XQSequenceType {
    SequenceType sequenceType;
    Configuration config;

    SaxonXQSequenceType(SequenceType sequenceType, Configuration configuration) {
        this.sequenceType = sequenceType;
        this.config = configuration;
    }

    public int getItemOccurrence() {
        int n = this.sequenceType.getCardinality();
        switch (n) {
            case 16384: {
                return 2;
            }
            case 24576: {
                return 1;
            }
            case 49152: {
                return 4;
            }
            case 57344: {
                return 3;
            }
        }
        return 3;
    }

    public XQItemType getItemType() {
        return new SaxonXQItemType(this.sequenceType.getPrimaryType(), this.config);
    }

    public String getString() {
        String string = this.sequenceType.getPrimaryType().toString(this.config.getNamePool());
        switch (this.sequenceType.getCardinality()) {
            case 16384: {
                return string;
            }
            case 24576: {
                return string + "?";
            }
            case 49152: {
                return string + "+";
            }
            case 57344: {
                return string + "*";
            }
        }
        return string;
    }

    public String toString() {
        return this.getString();
    }
}

