/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.ByteArrayOutputStream;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class Base64BinaryValue
extends AtomicValue {
    private byte[] binaryValue;

    public Base64BinaryValue(CharSequence charSequence) throws XPathException {
        Base64Decoder base64Decoder = new Base64Decoder();
        try {
            base64Decoder.translate(charSequence);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DynamicError dynamicError = new DynamicError(illegalArgumentException.getMessage());
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.binaryValue = base64Decoder.getByteArray();
    }

    public Base64BinaryValue(byte[] byArray) {
        this.binaryValue = byArray;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 528: 
            case 643: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 642: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 527: {
                return new HexBinaryValue(this.binaryValue);
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert base64Binary to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public String getStringValue() {
        Base64Encoder base64Encoder = new Base64Encoder();
        base64Encoder.translate(this.binaryValue);
        return new String(base64Encoder.getCharArray());
    }

    public int getLengthInOctets() {
        return this.binaryValue.length;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BASE64_BINARY_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(Base64BinaryValue.class)) {
            return this;
        }
        if (clazz == String.class || clazz == CharSequence.class) {
            return this.getStringValue();
        }
        if (clazz == Object.class) {
            return this.getStringValue();
        }
        Object object = super.convertToJava(clazz, xPathContext);
        if (object == null) {
            throw new DynamicError("Conversion of base64Binary to " + clazz.getName() + " is not supported");
        }
        return object;
    }

    public boolean equals(Object object) {
        Base64BinaryValue base64BinaryValue;
        if (object instanceof Base64BinaryValue) {
            base64BinaryValue = (Base64BinaryValue)object;
        } else if (object instanceof AtomicValue) {
            try {
                base64BinaryValue = (Base64BinaryValue)((AtomicValue)object).convert(528, null);
            }
            catch (XPathException xPathException) {
                return false;
            }
        } else {
            return false;
        }
        if (this.binaryValue.length != base64BinaryValue.binaryValue.length) {
            return false;
        }
        for (int i = 0; i < this.binaryValue.length; ++i) {
            if (this.binaryValue[i] == base64BinaryValue.binaryValue[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Base64BinaryValue.byteArrayHashCode(this.binaryValue);
    }

    protected static int byteArrayHashCode(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < Math.min(byArray.length, 64); ++i) {
            l = l << 1 ^ (long)byArray[i];
        }
        return (int)(l >> 32 ^ l) & 0xFFFFFFFF;
    }

    private static final class Base64Decoder {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private byte[] token = new byte[4];
        private byte[] bytes = new byte[3];
        private int token_length = 0;
        private static final byte NUL = 127;
        private static final byte EOF = 126;
        private static final byte SP = 125;
        private static final byte[] map = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 125, 125, 127, 127, 125, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 125, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

        private Base64Decoder() {
        }

        private void decode_token() {
            int n = this.token[0] << 18 | this.token[1] << 12 | this.token[2] << 6 | this.token[3];
            this.bytes[0] = (byte)(0xFF & n >> 16);
            this.bytes[1] = (byte)(0xFF & n >> 8);
            this.bytes[2] = (byte)(0xFF & n);
            this.out.write(this.bytes, 0, 3);
        }

        private void decode_final_token() {
            byte by = this.token[0];
            byte by2 = this.token[1];
            byte by3 = this.token[2];
            byte by4 = this.token[3];
            int n = 0;
            if (by == 126) {
                by = 0;
                ++n;
            }
            if (by2 == 126) {
                by2 = 0;
                ++n;
            }
            if (by3 == 126) {
                by3 = 0;
                ++n;
            }
            if (by4 == 126) {
                by4 = 0;
                ++n;
            }
            if (n > 2) {
                throw new IllegalArgumentException("The number of '=' signs at the end of a base64 value must not exceed 2");
            }
            if (n == 2 && (by2 & 0xF) != 0) {
                throw new IllegalArgumentException("In base64, if the value ends with '==' then the last character must be one of [AQgw]");
            }
            if (n == 1 && (by3 & 3) != 0) {
                throw new IllegalArgumentException("In base64, if the value ends with '=' then the last character must be one of [AEIMQUYcgkosw048]");
            }
            int n2 = by << 18 | by2 << 12 | by3 << 6 | by4;
            this.out.write((byte)(n2 >> 16));
            if (n <= 1) {
                this.out.write((byte)(n2 >> 8 & 0xFF));
                if (n == 0) {
                    this.out.write((byte)(n2 & 0xFF));
                }
            }
        }

        public final void translate(CharSequence charSequence) throws IllegalArgumentException {
            if (this.token == null) {
                return;
            }
            int n = charSequence.length();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("non-ASCII character in Base64 value (at offset " + i + ')');
                }
                byte by = map[c];
                if (by == 127) {
                    throw new IllegalArgumentException("invalid character '" + c + "' in Base64 value (at offset " + i + ')');
                }
                if (n2 > 0 && by != 126 && by != 125) {
                    throw new IllegalArgumentException("In Base64, an '=' character can appear only at the end");
                }
                if (by == 126) {
                    if (n2 > 0) {
                        if (++n2 > 2) {
                            throw new IllegalArgumentException("Base64 value can contain at most two '=' characters");
                        }
                        this.token_length = (this.token_length + 1) % 4;
                        continue;
                    }
                    n2 = 1;
                    int n3 = this.token_length;
                    this.eof();
                    this.token_length = (n3 + 1) % 4;
                    continue;
                }
                if (by == 125) continue;
                this.token[this.token_length++] = by;
                if (this.token_length != 4) continue;
                if (n2 == 0) {
                    this.decode_token();
                }
                this.token_length = 0;
            }
            if (this.token_length != 0) {
                throw new IllegalArgumentException("Base64 input must be a multiple of four characters");
            }
        }

        private void eof() {
            if (this.token != null && this.token_length != 0) {
                while (this.token_length < 4) {
                    this.token[this.token_length++] = 126;
                }
                this.decode_final_token();
            }
            this.token_length = 0;
            this.token = new byte[4];
            this.bytes = new byte[3];
        }

        public byte[] getByteArray() {
            this.eof();
            return this.out.toByteArray();
        }
    }

    private static final class Base64Encoder {
        private FastStringBuffer out = new FastStringBuffer(256);
        private int buf = 0;
        private int buf_bytes = 0;
        private char[] line = new char[74];
        private int line_length = 0;
        private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        private Base64Encoder() {
        }

        private void encode_token() {
            int n = this.line_length;
            this.line[n] = map[0x3F & this.buf >> 18];
            this.line[n + 1] = map[0x3F & this.buf >> 12];
            this.line[n + 2] = map[0x3F & this.buf >> 6];
            this.line[n + 3] = map[0x3F & this.buf];
            this.line_length += 4;
            this.buf = 0;
            this.buf_bytes = 0;
        }

        private void encode_partial_token() {
            int n = this.line_length;
            this.line[n] = map[0x3F & this.buf >> 18];
            this.line[n + 1] = map[0x3F & this.buf >> 12];
            this.line[n + 2] = this.buf_bytes == 1 ? 61 : map[0x3F & this.buf >> 6];
            this.line[n + 3] = this.buf_bytes <= 2 ? 61 : map[0x3F & this.buf];
            this.line_length += 4;
            this.buf = 0;
            this.buf_bytes = 0;
        }

        private void flush_line() {
            this.out.append(this.line, 0, this.line_length);
            this.line_length = 0;
        }

        public final void translate(byte[] byArray) {
            int n;
            int n2 = byArray.length;
            for (n = 0; n < n2; ++n) {
                this.buf = this.buf_bytes == 0 ? this.buf & 0xFFFF | byArray[n] << 16 : (this.buf_bytes == 1 ? this.buf & 0xFF00FF | byArray[n] << 8 & 0xFFFF : this.buf & 0xFFFF00 | byArray[n] & 0xFF);
                if (++this.buf_bytes == 3) {
                    this.encode_token();
                    if (this.line_length >= 72) {
                        this.flush_line();
                    }
                }
                if (n != n2 - 1) continue;
                if (this.buf_bytes > 0 && this.buf_bytes < 3) {
                    this.encode_partial_token();
                }
                if (this.line_length <= 0) continue;
                this.flush_line();
            }
            for (n = 0; n < this.line.length; ++n) {
                this.line[n] = '\u0000';
            }
        }

        public char[] getCharArray() {
            if (this.buf_bytes != 0) {
                this.encode_partial_token();
            }
            this.flush_line();
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i] = '\u0000';
            }
            char[] cArray = new char[this.out.length()];
            if (this.out.length() > 0) {
                this.out.getChars(0, this.out.length(), cArray, 0);
            }
            return cArray;
        }
    }
}

