#  Copyright (c) 2022, Apple Inc. All rights reserved.
#
#  Use of this source code is governed by a BSD-3-clause license that can be
#  found in the LICENSE.txt file or at https://opensource.org/licenses/BSD-3-Clause
from coremltools.converters.mil._deployment_compatibility import \
    AvailableTarget as target

_IOS15_TARGET = target.iOS15

from .activation import (clamped_relu, elu, gelu, leaky_relu,
                         linear_activation, prelu, relu, relu6, scaled_tanh,
                         sigmoid, sigmoid_hard, silu, softmax, softplus,
                         softplus_parametric, softsign, thresholded_relu)
from .classify import classify
from .control_flow import (cond, const, list_gather, list_length, list_read,
                           list_scatter, list_write, make_list, select,
                           while_loop)
from .conv import conv, conv_quantized, conv_transpose
from .elementwise_binary import (add, elementwise_binary, equal, floor_div,
                                 greater, greater_equal, less, less_equal,
                                 logical_and, logical_or, logical_xor, maximum,
                                 minimum, mod, mul, not_equal, pow, real_div,
                                 sub)
from .elementwise_unary import (abs, acos, asin, atan, atanh, cast, ceil, clip,
                                cos, cosh, erf, exp, exp2, floor, inverse, log,
                                logical_not, round, rsqrt, sign, sin, sinh,
                                sqrt, square, tan, tanh, threshold)
from .image_resizing import (affine, crop, crop_resize, resample,
                             resize_bilinear, resize_nearest_neighbor,
                             upsample_bilinear, upsample_nearest_neighbor)
from .linear import einsum, linear, matmul
from .normalization import (batch_norm, instance_norm, l2_norm, layer_norm,
                            local_response_norm)
from .pool import avg_pool, l2_pool, max_pool
from .random import (random_bernoulli, random_categorical, random_normal,
                     random_uniform)
from .recurrent import gru, lstm, rnn
from .reduction import (reduce_argmax, reduce_argmin, reduce_l1_norm,
                        reduce_l2_norm, reduce_log_sum, reduce_log_sum_exp,
                        reduce_max, reduce_mean, reduce_min, reduce_prod,
                        reduce_sum, reduce_sum_square)
from .scatter_gather import (gather, gather_along_axis, gather_nd, scatter,
                             scatter_along_axis, scatter_nd)
from .tensor_operation import (argsort, band_part, concat, cumsum, fill,
                               flatten2d, identity, non_maximum_suppression,
                               non_zero, one_hot, pad, range_1d, shape, split,
                               stack, tile, topk)
from .tensor_transformation import (depth_to_space, expand_dims, pixel_shuffle,
                                    reshape, reverse, reverse_sequence,
                                    slice_by_index, slice_by_size,
                                    sliding_windows, space_to_batch,
                                    space_to_depth, squeeze, transpose)
