#
# clhep_set_compiler_flags() 
#    sets the default compiler flags
#    calls clhep_autoconf_variables
#
# clhep_autoconf_variables() defines global variables
#
# clhep_package_config():
#    defines ${PACKAGE}_LIBS
#    processes ${PACKAGE}-config.in
#    processes ${PACKAGE}-deps.in
#
# clhep_package_config_no_lib():
#    processes ${PACKAGE}-config.in
#
# clhep_config():
#    processes clhep-config.in

macro( clhep_autoconf_variables )

  # these variables are used by <package>-config.in
  # typical values from autoconf:
  #   AM_CXXFLAGS = -O -ansi -pedantic -Wall -D_GNU_SOURCE
  #   CXXFLAGS = -g -O2
  #   CXX = g++
  #   CXXCPP = g++ -E
  #   CPPFLAGS = 
  #   CXXLD = $(CXX)
  #   AM_LDFLAGS = 
  #   LDFLAGS = 
  #   LIBS = 

  # automake/autoconf variables
  set( prefix      ${CMAKE_INSTALL_PREFIX} )
  set( exec_prefix "\${prefix}" )
  set( includedir  "\${prefix}/include" )
  set( configure_input "Generated by cmake" )

  ### autoconf variables typically do not have the path
  ##get_filename_component( CXX ${CMAKE_CXX_COMPILER} NAME )
  ##if( ${CXX} MATCHES "c\\+\\+" )
  ##   set( CXX g++ )
  ##endif()
  set( CXX ${CMAKE_BASE_NAME} )
  ##get_filename_component( AR ${CMAKE_AR} NAME )
  ##get_filename_component( RANLIB ${CMAKE_RANLIB} NAME )
  set( CXXCPP       "${CXX} -E" )
  if( ${CMAKE_BUILD_TYPE} MATCHES "Debug" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_DEBUG} )
  elseif( ${CMAKE_BUILD_TYPE} MATCHES "Release" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_RELEASE} )
  elseif( ${CMAKE_BUILD_TYPE} MATCHES "RelWithDebInfo" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_RELWITHDEBINFO} )
  elseif( ${CMAKE_BUILD_TYPE} MATCHES "MinSizeRel" )
     set( CXXFLAGS  ${CMAKE_CXX_FLAGS_MINSIZEREL} )
  endif()
  ##message( STATUS "build type ${CMAKE_BUILD_TYPE} has ${CXXFLAGS}")
  set( AM_CXXFLAGS  ${CMAKE_CXX_FLAGS} )
  set( LDFLAGS      ${CMAKE_MODULE_LINKER_FLAGS} )
  set( LIBS         "" )
  set( DIFF_Q       "diff -q -b" )

  ### useful if you need to check a variable
  ##message( STATUS "CMAKE_SYSTEM_NAME is ${CMAKE_SYSTEM_NAME}" )
  ##message( STATUS "CMAKE_BASE_NAME is ${CMAKE_BASE_NAME}" )
  ##message( STATUS "CMAKE_CXX_COMPILER_ID is ${CMAKE_CXX_COMPILER_ID}" )
  ##message( STATUS "CMAKE_COMPILER_IS_GNUCXX is ${CMAKE_COMPILER_IS_GNUCXX}" )
  ##message( STATUS "CMAKE_COMPILER_IS_MINGW is ${CMAKE_COMPILER_IS_MINGW}" )
  ##message( STATUS "CMAKE_COMPILER_IS_CYGWIN is ${CMAKE_COMPILER_IS_CYGWIN}" )
  ##message( STATUS "CMAKE_AR is ${CMAKE_AR}" )
  ##message( STATUS "CMAKE_RANLIB is ${CMAKE_RANLIB}" )
  ##message( STATUS "CMAKE_CXX_OUTPUT_EXTENSION is ${CMAKE_CXX_OUTPUT_EXTENSION}" )
  ##message( STATUS "CMAKE_SHARED_LIBRARY_CXX_FLAGS is ${CMAKE_SHARED_LIBRARY_CXX_FLAGS}" )
  ##message( STATUS "CMAKE_SHARED_MODULE_CXX_FLAGS is ${CMAKE_SHARED_MODULE_CXX_FLAGS}" )
  ##message( STATUS "CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS is ${CMAKE_SHARED_LIBRARY_LINK_CXX_FLAGS}" )
  ##message( STATUS "CMAKE_CXX_FLAGS is ${CMAKE_CXX_FLAGS}" )
  ##message( STATUS "CMAKE_CXX_FLAGS_DEBUG is ${CMAKE_CXX_FLAGS_DEBUG}" )
  ##message( STATUS "CMAKE_CXX_FLAGS_RELEASE is ${CMAKE_CXX_FLAGS_RELEASE}" )
  ##message( STATUS "CMAKE_CXX_FLAGS_RELWITHDEBINFO is ${CMAKE_CXX_FLAGS_RELWITHDEBINFO}" )
  ##message( STATUS "CMAKE_CXX_STANDARD_LIBRARIES is ${CMAKE_CXX_STANDARD_LIBRARIES}" )
  ##message( STATUS "CMAKE_CXX_LINK_FLAGS is ${CMAKE_CXX_LINK_FLAGS}" )

endmacro( clhep_autoconf_variables )

macro( clhep_set_compiler_flags )
  ##message(STATUS "incoming cmake build type is ${CMAKE_BUILD_TYPE}")
  if(NOT CMAKE_BUILD_TYPE)
    set(CMAKE_BUILD_TYPE RelWithDebInfo CACHE STRING "" FORCE)
  endif()
  message(STATUS "cmake build type is ${CMAKE_BUILD_TYPE}")
  if( CMAKE_COMPILER_IS_GNUCC )
    set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -O -ansi -pedantic -Wall -D_GNU_SOURCE")
  endif(CMAKE_COMPILER_IS_GNUCC)
  if(CMAKE_COMPILER_IS_GNUCXX)
    set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -O -ansi -pedantic -Wall -D_GNU_SOURCE")
  endif(CMAKE_COMPILER_IS_GNUCXX)
  if( ${CMAKE_SYSTEM_NAME} MATCHES "Windows" )
    ##message( STATUS "system is Windows" )
    ##message( STATUS "CMAKE_BASE_NAME is ${CMAKE_BASE_NAME}" )
    if( ${CMAKE_BASE_NAME} MATCHES "cl" )
      ##message( STATUS "compiler is MSVC" )
      ##message( STATUS "incoming basic compiler flags are ${CMAKE_CXX_FLAGS}")
      set(CMAKE_C_FLAGS "/EHsc /nologo /GR /MD /D USING_VISUAL")
      set(CMAKE_CXX_FLAGS "/EHsc /nologo /GR /MD /D USING_VISUAL")
    endif()
  endif()
  clhep_autoconf_variables()
  message( STATUS "compiling with ${CMAKE_BASE_NAME} ${CMAKE_CXX_FLAGS} ${CXXFLAGS}")
endmacro( clhep_set_compiler_flags )

macro( clhep_package_config_no_lib )
  set( ${PACKAGE}_CPPFLAGS "-I${includedir}" )
  set( ${PACKAGE}_LDFLAGS  " " )
  set( ${PACKAGE}_LIBS     " " )
  configure_file ( ${CLHEP_SOURCE_DIR}/${PACKAGE}/${PACKAGE}-config.in
                   ${CLHEP_BINARY_DIR}/${PACKAGE}/${PACKAGE}-config @ONLY )
  ## don't install <package>-config on Windows
  if( NOT ${CMAKE_SYSTEM_NAME} MATCHES "Windows" )
    install ( PROGRAMS ${CLHEP_BINARY_DIR}/${PACKAGE}/${PACKAGE}-config
              DESTINATION bin
	    )
  endif()
endmacro( clhep_package_config_no_lib )

macro( clhep_package_config )
  set( ${PACKAGE}_CPPFLAGS "-I${includedir}" )
  set( ${PACKAGE}_LDFLAGS  "-L\${exec_prefix}/lib" )
  set( ${PACKAGE}_LIBS     "-lCLHEP-${PACKAGE}-${VERSION}" )
  if( ${PACKAGE}_DEPS )
     foreach ( dep ${${PACKAGE}_DEPS} )
        message( STATUS "${PACKAGE} depends on ${dep}")
	set( ${PACKAGE}_LIBS     "${${PACKAGE}_LIBS} -lCLHEP-${dep}-${VERSION}" )
     endforeach()
  endif()
  configure_file ( ${CLHEP_SOURCE_DIR}/${PACKAGE}/${PACKAGE}-config.in
                   ${CLHEP_BINARY_DIR}/${PACKAGE}/${PACKAGE}-config @ONLY )
  configure_file ( ${CLHEP_SOURCE_DIR}/${PACKAGE}/${PACKAGE}-deps.in
                   ${CLHEP_BINARY_DIR}/${PACKAGE}/${PACKAGE}-deps @ONLY )
  ## don't install <package>-config on Windows
  if( NOT ${CMAKE_SYSTEM_NAME} MATCHES "Windows" )
    install ( PROGRAMS ${CLHEP_BINARY_DIR}/${PACKAGE}/${PACKAGE}-config
              DESTINATION bin
	    )
  endif()
endmacro( clhep_package_config )

macro( clhep_config )
  configure_file ( ${CLHEP_SOURCE_DIR}/clhep-config.in
                   ${CLHEP_BINARY_DIR}/clhep-config @ONLY )
  ## don't install clhep-config on Windows
  if( NOT ${CMAKE_SYSTEM_NAME} MATCHES "Windows" )
    install ( PROGRAMS ${CLHEP_BINARY_DIR}/clhep-config
              DESTINATION bin
	    )
  endif()
endmacro( clhep_config )
