/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: tFB.cpp,v 1.8 2001/10/17 17:53:33 lijewski Exp $
//
// A test program for FillBoundary().
//

#include <Utility.H>
#include <MultiFab.H>

#include <new>
#ifndef WIN32
using std::set_new_handler;
#endif

static
void
DumpFirstFab (const MultiFab& mf)
{
    BL_ASSERT(mf.length() > 1);

    if (ParallelDescriptor::IOProcessor())
    {
        BL_ASSERT(mf.DistributionMap()[0] == ParallelDescriptor::MyProc());

        cout << mf[0] << endl;
    }
}

static
void
DoIt (MultiFab& mf)
{
    BL_ASSERT(mf.nComp() >= 2);

    mf.setVal(0);
    //
    // Do loop just filling first component.
    //
    for (int i = 0; i < 10; i++)
    {
        for(MultiFabIterator mfi(mf); mfi.isValid(); ++mfi)
        {
            mfi().setVal(mfi.index()+1,0);
        }

        mf.FillBoundary(0,1);

        DumpFirstFab(mf);
    }
    //
    // Do loop just filling second component.
    //
    for (int i = 0; i < 10; i++)
    {
        for(MultiFabIterator mfi(mf); mfi.isValid(); ++mfi)
        {
            mfi().setVal(mfi.index()+10,1);
        }

        mf.FillBoundary(1,1);

        DumpFirstFab(mf);
    }
    //
    // Do loop filling all components.
    //
    for (int i = 0; i < 10; i++)
    {
        for(MultiFabIterator mfi(mf); mfi.isValid(); ++mfi)
        {
            mfi().setVal(mfi.index()+100);
        }

        mf.FillBoundary();

        DumpFirstFab(mf);
    }
}

int
main (int argc, char** argv)
{
#ifndef WIN32
    set_new_handler(BoxLib::OutOfMemory);
#endif
    BoxLib::Initialize(argc, argv);

    BoxList bl;

    Box bx1(IntVect::TheZeroVector(),IntVect::TheUnitVector());
    Box bx2 = bx1;
    bx2.shift(0,2);

    bl.append(bx1); bl.append(bx2);

    BoxArray ba(bl);
    
    MultiFab junk(ba,2,1), junky(ba,2,1);

    DoIt(junk); DoIt(junky); DoIt(junk); DoIt(junky);

    BoxLib::Finalize();

    return 0;
}
