// Generated by Cap'n Proto compiler, DO NOT EDIT
// source: lexer.capnp

#ifndef CAPNP_INCLUDED_a73956d2621fc3ee_
#define CAPNP_INCLUDED_a73956d2621fc3ee_

#include <capnp/generated-header-support.h>

#if CAPNP_VERSION != 4000
#error "Version mismatch between generated code and library headers.  You must use the same version of the Cap'n Proto compiler and library."
#endif


namespace capnp {
namespace compiler {

struct Token {
  Token() = delete;

  class Reader;
  class Builder;
  class Pipeline;
  enum Which: uint16_t {
    IDENTIFIER,
    STRING_LITERAL,
    INTEGER_LITERAL,
    FLOAT_LITERAL,
    OPERATOR,
    PARENTHESIZED_LIST,
    BRACKETED_LIST,
  };
};

struct Statement {
  Statement() = delete;

  class Reader;
  class Builder;
  class Pipeline;
  enum Which: uint16_t {
    LINE,
    BLOCK,
  };
};

struct LexedTokens {
  LexedTokens() = delete;

  class Reader;
  class Builder;
  class Pipeline;
};

struct LexedStatements {
  LexedStatements() = delete;

  class Reader;
  class Builder;
  class Pipeline;
};

}  // namespace
}  // namespace

// =======================================================================================

namespace capnp {
namespace schemas {

extern const ::capnp::_::RawSchema s_91cc55cd57de5419;
extern const ::capnp::_::RawSchema s_c6725e678d60fa37;
extern const ::capnp::_::RawSchema s_9e69a92512b19d18;
extern const ::capnp::_::RawSchema s_a11f97b9d6c73dd4;

}  // namespace schemas
namespace _ {  // private

CAPNP_DECLARE_STRUCT(
    ::capnp::compiler::Token, 91cc55cd57de5419,
    3, 1, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::compiler::Statement, c6725e678d60fa37,
    2, 3, INLINE_COMPOSITE);
CAPNP_DECLARE_STRUCT(
    ::capnp::compiler::LexedTokens, 9e69a92512b19d18,
    0, 1, POINTER);
CAPNP_DECLARE_STRUCT(
    ::capnp::compiler::LexedStatements, a11f97b9d6c73dd4,
    0, 1, POINTER);

}  // namespace _ (private)
}  // namespace capnp

// =======================================================================================

namespace capnp {
namespace compiler {

class Token::Reader {
public:
  typedef Token Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline ::capnp::MessageSize totalSize() const {
    return _reader.totalSize().asPublic();
  }

  inline Which which() const;
  inline bool isIdentifier() const;
  inline bool hasIdentifier() const;
  inline  ::capnp::Text::Reader getIdentifier() const;

  inline bool isStringLiteral() const;
  inline bool hasStringLiteral() const;
  inline  ::capnp::Text::Reader getStringLiteral() const;

  inline bool isIntegerLiteral() const;
  inline  ::uint64_t getIntegerLiteral() const;

  inline bool isFloatLiteral() const;
  inline double getFloatLiteral() const;

  inline bool isOperator() const;
  inline bool hasOperator() const;
  inline  ::capnp::Text::Reader getOperator() const;

  inline bool isParenthesizedList() const;
  inline bool hasParenthesizedList() const;
  inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader getParenthesizedList() const;

  inline bool isBracketedList() const;
  inline bool hasBracketedList() const;
  inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader getBracketedList() const;

  inline  ::uint32_t getStartByte() const;

  inline  ::uint32_t getEndByte() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Token::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Token::Reader reader) {
  return ::capnp::_::structString<Token>(reader._reader);
}

class Token::Builder {
public:
  typedef Token Builds;

  Builder() = delete;  // Deleted to discourage incorrect usage.
                       // You can explicitly initialize to nullptr instead.
  inline Builder(decltype(nullptr)) {}
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline ::capnp::MessageSize totalSize() const { return asReader().totalSize(); }

  inline Which which();
  inline bool isIdentifier();
  inline bool hasIdentifier();
  inline  ::capnp::Text::Builder getIdentifier();
  inline void setIdentifier( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initIdentifier(unsigned int size);
  inline void adoptIdentifier(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownIdentifier();

  inline bool isStringLiteral();
  inline bool hasStringLiteral();
  inline  ::capnp::Text::Builder getStringLiteral();
  inline void setStringLiteral( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initStringLiteral(unsigned int size);
  inline void adoptStringLiteral(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownStringLiteral();

  inline bool isIntegerLiteral();
  inline  ::uint64_t getIntegerLiteral();
  inline void setIntegerLiteral( ::uint64_t value);

  inline bool isFloatLiteral();
  inline double getFloatLiteral();
  inline void setFloatLiteral(double value);

  inline bool isOperator();
  inline bool hasOperator();
  inline  ::capnp::Text::Builder getOperator();
  inline void setOperator( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initOperator(unsigned int size);
  inline void adoptOperator(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownOperator();

  inline bool isParenthesizedList();
  inline bool hasParenthesizedList();
  inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder getParenthesizedList();
  inline void setParenthesizedList( ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader value);
  inline void setParenthesizedList(::kj::ArrayPtr<const  ::capnp::List< ::capnp::compiler::Token>::Reader> value);
  inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder initParenthesizedList(unsigned int size);
  inline void adoptParenthesizedList(::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>> disownParenthesizedList();

  inline bool isBracketedList();
  inline bool hasBracketedList();
  inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder getBracketedList();
  inline void setBracketedList( ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader value);
  inline void setBracketedList(::kj::ArrayPtr<const  ::capnp::List< ::capnp::compiler::Token>::Reader> value);
  inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder initBracketedList(unsigned int size);
  inline void adoptBracketedList(::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>> disownBracketedList();

  inline  ::uint32_t getStartByte();
  inline void setStartByte( ::uint32_t value);

  inline  ::uint32_t getEndByte();
  inline void setEndByte( ::uint32_t value);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Token::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Token::Builder builder) {
  return ::capnp::_::structString<Token>(builder._builder.asReader());
}

class Token::Pipeline {
public:
  typedef Token Pipelines;

  inline Pipeline(decltype(nullptr)): _typeless(nullptr) {}
  inline explicit Pipeline(::capnp::AnyPointer::Pipeline&& typeless)
      : _typeless(kj::mv(typeless)) {}

private:
  ::capnp::AnyPointer::Pipeline _typeless;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
};

class Statement::Reader {
public:
  typedef Statement Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline ::capnp::MessageSize totalSize() const {
    return _reader.totalSize().asPublic();
  }

  inline Which which() const;
  inline bool hasTokens() const;
  inline  ::capnp::List< ::capnp::compiler::Token>::Reader getTokens() const;

  inline bool isLine() const;
  inline  ::capnp::Void getLine() const;

  inline bool isBlock() const;
  inline bool hasBlock() const;
  inline  ::capnp::List< ::capnp::compiler::Statement>::Reader getBlock() const;

  inline bool hasDocComment() const;
  inline  ::capnp::Text::Reader getDocComment() const;

  inline  ::uint32_t getStartByte() const;

  inline  ::uint32_t getEndByte() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Statement::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(Statement::Reader reader) {
  return ::capnp::_::structString<Statement>(reader._reader);
}

class Statement::Builder {
public:
  typedef Statement Builds;

  Builder() = delete;  // Deleted to discourage incorrect usage.
                       // You can explicitly initialize to nullptr instead.
  inline Builder(decltype(nullptr)) {}
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline ::capnp::MessageSize totalSize() const { return asReader().totalSize(); }

  inline Which which();
  inline bool hasTokens();
  inline  ::capnp::List< ::capnp::compiler::Token>::Builder getTokens();
  inline void setTokens( ::capnp::List< ::capnp::compiler::Token>::Reader value);
  inline  ::capnp::List< ::capnp::compiler::Token>::Builder initTokens(unsigned int size);
  inline void adoptTokens(::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>> disownTokens();

  inline bool isLine();
  inline  ::capnp::Void getLine();
  inline void setLine( ::capnp::Void value = ::capnp::VOID);

  inline bool isBlock();
  inline bool hasBlock();
  inline  ::capnp::List< ::capnp::compiler::Statement>::Builder getBlock();
  inline void setBlock( ::capnp::List< ::capnp::compiler::Statement>::Reader value);
  inline  ::capnp::List< ::capnp::compiler::Statement>::Builder initBlock(unsigned int size);
  inline void adoptBlock(::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>> disownBlock();

  inline bool hasDocComment();
  inline  ::capnp::Text::Builder getDocComment();
  inline void setDocComment( ::capnp::Text::Reader value);
  inline  ::capnp::Text::Builder initDocComment(unsigned int size);
  inline void adoptDocComment(::capnp::Orphan< ::capnp::Text>&& value);
  inline ::capnp::Orphan< ::capnp::Text> disownDocComment();

  inline  ::uint32_t getStartByte();
  inline void setStartByte( ::uint32_t value);

  inline  ::uint32_t getEndByte();
  inline void setEndByte( ::uint32_t value);

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(Statement::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(Statement::Builder builder) {
  return ::capnp::_::structString<Statement>(builder._builder.asReader());
}

class Statement::Pipeline {
public:
  typedef Statement Pipelines;

  inline Pipeline(decltype(nullptr)): _typeless(nullptr) {}
  inline explicit Pipeline(::capnp::AnyPointer::Pipeline&& typeless)
      : _typeless(kj::mv(typeless)) {}

private:
  ::capnp::AnyPointer::Pipeline _typeless;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
};

class LexedTokens::Reader {
public:
  typedef LexedTokens Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline ::capnp::MessageSize totalSize() const {
    return _reader.totalSize().asPublic();
  }

  inline bool hasTokens() const;
  inline  ::capnp::List< ::capnp::compiler::Token>::Reader getTokens() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(LexedTokens::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(LexedTokens::Reader reader) {
  return ::capnp::_::structString<LexedTokens>(reader._reader);
}

class LexedTokens::Builder {
public:
  typedef LexedTokens Builds;

  Builder() = delete;  // Deleted to discourage incorrect usage.
                       // You can explicitly initialize to nullptr instead.
  inline Builder(decltype(nullptr)) {}
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline ::capnp::MessageSize totalSize() const { return asReader().totalSize(); }

  inline bool hasTokens();
  inline  ::capnp::List< ::capnp::compiler::Token>::Builder getTokens();
  inline void setTokens( ::capnp::List< ::capnp::compiler::Token>::Reader value);
  inline  ::capnp::List< ::capnp::compiler::Token>::Builder initTokens(unsigned int size);
  inline void adoptTokens(::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>> disownTokens();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(LexedTokens::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(LexedTokens::Builder builder) {
  return ::capnp::_::structString<LexedTokens>(builder._builder.asReader());
}

class LexedTokens::Pipeline {
public:
  typedef LexedTokens Pipelines;

  inline Pipeline(decltype(nullptr)): _typeless(nullptr) {}
  inline explicit Pipeline(::capnp::AnyPointer::Pipeline&& typeless)
      : _typeless(kj::mv(typeless)) {}

private:
  ::capnp::AnyPointer::Pipeline _typeless;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
};

class LexedStatements::Reader {
public:
  typedef LexedStatements Reads;

  Reader() = default;
  inline explicit Reader(::capnp::_::StructReader base): _reader(base) {}

  inline ::capnp::MessageSize totalSize() const {
    return _reader.totalSize().asPublic();
  }

  inline bool hasStatements() const;
  inline  ::capnp::List< ::capnp::compiler::Statement>::Reader getStatements() const;

private:
  ::capnp::_::StructReader _reader;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::_::PointerHelpers;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::List;
  friend class ::capnp::MessageBuilder;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(LexedStatements::Reader reader);
};

inline ::kj::StringTree KJ_STRINGIFY(LexedStatements::Reader reader) {
  return ::capnp::_::structString<LexedStatements>(reader._reader);
}

class LexedStatements::Builder {
public:
  typedef LexedStatements Builds;

  Builder() = delete;  // Deleted to discourage incorrect usage.
                       // You can explicitly initialize to nullptr instead.
  inline Builder(decltype(nullptr)) {}
  inline explicit Builder(::capnp::_::StructBuilder base): _builder(base) {}
  inline operator Reader() const { return Reader(_builder.asReader()); }
  inline Reader asReader() const { return *this; }

  inline ::capnp::MessageSize totalSize() const { return asReader().totalSize(); }

  inline bool hasStatements();
  inline  ::capnp::List< ::capnp::compiler::Statement>::Builder getStatements();
  inline void setStatements( ::capnp::List< ::capnp::compiler::Statement>::Reader value);
  inline  ::capnp::List< ::capnp::compiler::Statement>::Builder initStatements(unsigned int size);
  inline void adoptStatements(::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>>&& value);
  inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>> disownStatements();

private:
  ::capnp::_::StructBuilder _builder;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
  friend class ::capnp::Orphanage;
  friend ::kj::StringTree KJ_STRINGIFY(LexedStatements::Builder builder);
};

inline ::kj::StringTree KJ_STRINGIFY(LexedStatements::Builder builder) {
  return ::capnp::_::structString<LexedStatements>(builder._builder.asReader());
}

class LexedStatements::Pipeline {
public:
  typedef LexedStatements Pipelines;

  inline Pipeline(decltype(nullptr)): _typeless(nullptr) {}
  inline explicit Pipeline(::capnp::AnyPointer::Pipeline&& typeless)
      : _typeless(kj::mv(typeless)) {}

private:
  ::capnp::AnyPointer::Pipeline _typeless;
  template <typename T, ::capnp::Kind k>
  friend struct ::capnp::ToDynamic_;
};

// =======================================================================================

inline Token::Which Token::Reader::which() const {
  return _reader.getDataField<Which>(0 * ::capnp::ELEMENTS);
}
inline Token::Which Token::Builder::which() {
  return _builder.getDataField<Which>(0 * ::capnp::ELEMENTS);
}

inline bool Token::Reader::isIdentifier() const {
  return which() == Token::IDENTIFIER;
}
inline bool Token::Builder::isIdentifier() {
  return which() == Token::IDENTIFIER;
}
inline bool Token::Reader::hasIdentifier() const {
  if (which() != Token::IDENTIFIER) return false;
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool Token::Builder::hasIdentifier() {
  if (which() != Token::IDENTIFIER) return false;
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::Text::Reader Token::Reader::getIdentifier() const {
  KJ_IREQUIRE(which() == Token::IDENTIFIER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::Text::Builder Token::Builder::getIdentifier() {
  KJ_IREQUIRE(which() == Token::IDENTIFIER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void Token::Builder::setIdentifier( ::capnp::Text::Reader value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::IDENTIFIER);
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::Text::Builder Token::Builder::initIdentifier(unsigned int size) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::IDENTIFIER);
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void Token::Builder::adoptIdentifier(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::IDENTIFIER);
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Token::Builder::disownIdentifier() {
  KJ_IREQUIRE(which() == Token::IDENTIFIER,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline bool Token::Reader::isStringLiteral() const {
  return which() == Token::STRING_LITERAL;
}
inline bool Token::Builder::isStringLiteral() {
  return which() == Token::STRING_LITERAL;
}
inline bool Token::Reader::hasStringLiteral() const {
  if (which() != Token::STRING_LITERAL) return false;
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool Token::Builder::hasStringLiteral() {
  if (which() != Token::STRING_LITERAL) return false;
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::Text::Reader Token::Reader::getStringLiteral() const {
  KJ_IREQUIRE(which() == Token::STRING_LITERAL,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::Text::Builder Token::Builder::getStringLiteral() {
  KJ_IREQUIRE(which() == Token::STRING_LITERAL,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void Token::Builder::setStringLiteral( ::capnp::Text::Reader value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::STRING_LITERAL);
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::Text::Builder Token::Builder::initStringLiteral(unsigned int size) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::STRING_LITERAL);
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void Token::Builder::adoptStringLiteral(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::STRING_LITERAL);
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Token::Builder::disownStringLiteral() {
  KJ_IREQUIRE(which() == Token::STRING_LITERAL,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline bool Token::Reader::isIntegerLiteral() const {
  return which() == Token::INTEGER_LITERAL;
}
inline bool Token::Builder::isIntegerLiteral() {
  return which() == Token::INTEGER_LITERAL;
}
inline  ::uint64_t Token::Reader::getIntegerLiteral() const {
  KJ_IREQUIRE(which() == Token::INTEGER_LITERAL,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint64_t Token::Builder::getIntegerLiteral() {
  KJ_IREQUIRE(which() == Token::INTEGER_LITERAL,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Token::Builder::setIntegerLiteral( ::uint64_t value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::INTEGER_LITERAL);
  _builder.setDataField< ::uint64_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool Token::Reader::isFloatLiteral() const {
  return which() == Token::FLOAT_LITERAL;
}
inline bool Token::Builder::isFloatLiteral() {
  return which() == Token::FLOAT_LITERAL;
}
inline double Token::Reader::getFloatLiteral() const {
  KJ_IREQUIRE(which() == Token::FLOAT_LITERAL,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField<double>(
      1 * ::capnp::ELEMENTS);
}

inline double Token::Builder::getFloatLiteral() {
  KJ_IREQUIRE(which() == Token::FLOAT_LITERAL,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField<double>(
      1 * ::capnp::ELEMENTS);
}
inline void Token::Builder::setFloatLiteral(double value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::FLOAT_LITERAL);
  _builder.setDataField<double>(
      1 * ::capnp::ELEMENTS, value);
}

inline bool Token::Reader::isOperator() const {
  return which() == Token::OPERATOR;
}
inline bool Token::Builder::isOperator() {
  return which() == Token::OPERATOR;
}
inline bool Token::Reader::hasOperator() const {
  if (which() != Token::OPERATOR) return false;
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool Token::Builder::hasOperator() {
  if (which() != Token::OPERATOR) return false;
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::Text::Reader Token::Reader::getOperator() const {
  KJ_IREQUIRE(which() == Token::OPERATOR,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::Text::Builder Token::Builder::getOperator() {
  KJ_IREQUIRE(which() == Token::OPERATOR,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void Token::Builder::setOperator( ::capnp::Text::Reader value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::OPERATOR);
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::Text::Builder Token::Builder::initOperator(unsigned int size) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::OPERATOR);
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void Token::Builder::adoptOperator(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::OPERATOR);
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Token::Builder::disownOperator() {
  KJ_IREQUIRE(which() == Token::OPERATOR,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline bool Token::Reader::isParenthesizedList() const {
  return which() == Token::PARENTHESIZED_LIST;
}
inline bool Token::Builder::isParenthesizedList() {
  return which() == Token::PARENTHESIZED_LIST;
}
inline bool Token::Reader::hasParenthesizedList() const {
  if (which() != Token::PARENTHESIZED_LIST) return false;
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool Token::Builder::hasParenthesizedList() {
  if (which() != Token::PARENTHESIZED_LIST) return false;
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader Token::Reader::getParenthesizedList() const {
  KJ_IREQUIRE(which() == Token::PARENTHESIZED_LIST,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder Token::Builder::getParenthesizedList() {
  KJ_IREQUIRE(which() == Token::PARENTHESIZED_LIST,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void Token::Builder::setParenthesizedList( ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::PARENTHESIZED_LIST);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline void Token::Builder::setParenthesizedList(::kj::ArrayPtr<const  ::capnp::List< ::capnp::compiler::Token>::Reader> value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::PARENTHESIZED_LIST);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder Token::Builder::initParenthesizedList(unsigned int size) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::PARENTHESIZED_LIST);
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void Token::Builder::adoptParenthesizedList(
    ::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>&& value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::PARENTHESIZED_LIST);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>> Token::Builder::disownParenthesizedList() {
  KJ_IREQUIRE(which() == Token::PARENTHESIZED_LIST,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline bool Token::Reader::isBracketedList() const {
  return which() == Token::BRACKETED_LIST;
}
inline bool Token::Builder::isBracketedList() {
  return which() == Token::BRACKETED_LIST;
}
inline bool Token::Reader::hasBracketedList() const {
  if (which() != Token::BRACKETED_LIST) return false;
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool Token::Builder::hasBracketedList() {
  if (which() != Token::BRACKETED_LIST) return false;
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader Token::Reader::getBracketedList() const {
  KJ_IREQUIRE(which() == Token::BRACKETED_LIST,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder Token::Builder::getBracketedList() {
  KJ_IREQUIRE(which() == Token::BRACKETED_LIST,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void Token::Builder::setBracketedList( ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Reader value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::BRACKETED_LIST);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline void Token::Builder::setBracketedList(::kj::ArrayPtr<const  ::capnp::List< ::capnp::compiler::Token>::Reader> value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::BRACKETED_LIST);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>::Builder Token::Builder::initBracketedList(unsigned int size) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::BRACKETED_LIST);
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void Token::Builder::adoptBracketedList(
    ::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>&& value) {
  _builder.setDataField<Token::Which>(
      0 * ::capnp::ELEMENTS, Token::BRACKETED_LIST);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>> Token::Builder::disownBracketedList() {
  KJ_IREQUIRE(which() == Token::BRACKETED_LIST,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::List< ::capnp::compiler::Token>>>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline  ::uint32_t Token::Reader::getStartByte() const {
  return _reader.getDataField< ::uint32_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint32_t Token::Builder::getStartByte() {
  return _builder.getDataField< ::uint32_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Token::Builder::setStartByte( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::uint32_t Token::Reader::getEndByte() const {
  return _reader.getDataField< ::uint32_t>(
      4 * ::capnp::ELEMENTS);
}

inline  ::uint32_t Token::Builder::getEndByte() {
  return _builder.getDataField< ::uint32_t>(
      4 * ::capnp::ELEMENTS);
}
inline void Token::Builder::setEndByte( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      4 * ::capnp::ELEMENTS, value);
}

inline Statement::Which Statement::Reader::which() const {
  return _reader.getDataField<Which>(0 * ::capnp::ELEMENTS);
}
inline Statement::Which Statement::Builder::which() {
  return _builder.getDataField<Which>(0 * ::capnp::ELEMENTS);
}

inline bool Statement::Reader::hasTokens() const {
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool Statement::Builder::hasTokens() {
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::List< ::capnp::compiler::Token>::Reader Statement::Reader::getTokens() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::List< ::capnp::compiler::Token>::Builder Statement::Builder::getTokens() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void Statement::Builder::setTokens( ::capnp::List< ::capnp::compiler::Token>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::List< ::capnp::compiler::Token>::Builder Statement::Builder::initTokens(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void Statement::Builder::adoptTokens(
    ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>> Statement::Builder::disownTokens() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline bool Statement::Reader::isLine() const {
  return which() == Statement::LINE;
}
inline bool Statement::Builder::isLine() {
  return which() == Statement::LINE;
}
inline  ::capnp::Void Statement::Reader::getLine() const {
  KJ_IREQUIRE(which() == Statement::LINE,
              "Must check which() before get()ing a union member.");
  return _reader.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}

inline  ::capnp::Void Statement::Builder::getLine() {
  KJ_IREQUIRE(which() == Statement::LINE,
              "Must check which() before get()ing a union member.");
  return _builder.getDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS);
}
inline void Statement::Builder::setLine( ::capnp::Void value) {
  _builder.setDataField<Statement::Which>(
      0 * ::capnp::ELEMENTS, Statement::LINE);
  _builder.setDataField< ::capnp::Void>(
      0 * ::capnp::ELEMENTS, value);
}

inline bool Statement::Reader::isBlock() const {
  return which() == Statement::BLOCK;
}
inline bool Statement::Builder::isBlock() {
  return which() == Statement::BLOCK;
}
inline bool Statement::Reader::hasBlock() const {
  if (which() != Statement::BLOCK) return false;
  return !_reader.getPointerField(1 * ::capnp::POINTERS).isNull();
}
inline bool Statement::Builder::hasBlock() {
  if (which() != Statement::BLOCK) return false;
  return !_builder.getPointerField(1 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::List< ::capnp::compiler::Statement>::Reader Statement::Reader::getBlock() const {
  KJ_IREQUIRE(which() == Statement::BLOCK,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::get(
      _reader.getPointerField(1 * ::capnp::POINTERS));
}
inline  ::capnp::List< ::capnp::compiler::Statement>::Builder Statement::Builder::getBlock() {
  KJ_IREQUIRE(which() == Statement::BLOCK,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::get(
      _builder.getPointerField(1 * ::capnp::POINTERS));
}
inline void Statement::Builder::setBlock( ::capnp::List< ::capnp::compiler::Statement>::Reader value) {
  _builder.setDataField<Statement::Which>(
      0 * ::capnp::ELEMENTS, Statement::BLOCK);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::set(
      _builder.getPointerField(1 * ::capnp::POINTERS), value);
}
inline  ::capnp::List< ::capnp::compiler::Statement>::Builder Statement::Builder::initBlock(unsigned int size) {
  _builder.setDataField<Statement::Which>(
      0 * ::capnp::ELEMENTS, Statement::BLOCK);
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::init(
      _builder.getPointerField(1 * ::capnp::POINTERS), size);
}
inline void Statement::Builder::adoptBlock(
    ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>>&& value) {
  _builder.setDataField<Statement::Which>(
      0 * ::capnp::ELEMENTS, Statement::BLOCK);
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::adopt(
      _builder.getPointerField(1 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>> Statement::Builder::disownBlock() {
  KJ_IREQUIRE(which() == Statement::BLOCK,
              "Must check which() before get()ing a union member.");
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::disown(
      _builder.getPointerField(1 * ::capnp::POINTERS));
}

inline bool Statement::Reader::hasDocComment() const {
  return !_reader.getPointerField(2 * ::capnp::POINTERS).isNull();
}
inline bool Statement::Builder::hasDocComment() {
  return !_builder.getPointerField(2 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::Text::Reader Statement::Reader::getDocComment() const {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _reader.getPointerField(2 * ::capnp::POINTERS));
}
inline  ::capnp::Text::Builder Statement::Builder::getDocComment() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::get(
      _builder.getPointerField(2 * ::capnp::POINTERS));
}
inline void Statement::Builder::setDocComment( ::capnp::Text::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::set(
      _builder.getPointerField(2 * ::capnp::POINTERS), value);
}
inline  ::capnp::Text::Builder Statement::Builder::initDocComment(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::init(
      _builder.getPointerField(2 * ::capnp::POINTERS), size);
}
inline void Statement::Builder::adoptDocComment(
    ::capnp::Orphan< ::capnp::Text>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::Text>::adopt(
      _builder.getPointerField(2 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::Text> Statement::Builder::disownDocComment() {
  return ::capnp::_::PointerHelpers< ::capnp::Text>::disown(
      _builder.getPointerField(2 * ::capnp::POINTERS));
}

inline  ::uint32_t Statement::Reader::getStartByte() const {
  return _reader.getDataField< ::uint32_t>(
      1 * ::capnp::ELEMENTS);
}

inline  ::uint32_t Statement::Builder::getStartByte() {
  return _builder.getDataField< ::uint32_t>(
      1 * ::capnp::ELEMENTS);
}
inline void Statement::Builder::setStartByte( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      1 * ::capnp::ELEMENTS, value);
}

inline  ::uint32_t Statement::Reader::getEndByte() const {
  return _reader.getDataField< ::uint32_t>(
      2 * ::capnp::ELEMENTS);
}

inline  ::uint32_t Statement::Builder::getEndByte() {
  return _builder.getDataField< ::uint32_t>(
      2 * ::capnp::ELEMENTS);
}
inline void Statement::Builder::setEndByte( ::uint32_t value) {
  _builder.setDataField< ::uint32_t>(
      2 * ::capnp::ELEMENTS, value);
}

inline bool LexedTokens::Reader::hasTokens() const {
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool LexedTokens::Builder::hasTokens() {
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::List< ::capnp::compiler::Token>::Reader LexedTokens::Reader::getTokens() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::List< ::capnp::compiler::Token>::Builder LexedTokens::Builder::getTokens() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void LexedTokens::Builder::setTokens( ::capnp::List< ::capnp::compiler::Token>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::List< ::capnp::compiler::Token>::Builder LexedTokens::Builder::initTokens(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void LexedTokens::Builder::adoptTokens(
    ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Token>> LexedTokens::Builder::disownTokens() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Token>>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

inline bool LexedStatements::Reader::hasStatements() const {
  return !_reader.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline bool LexedStatements::Builder::hasStatements() {
  return !_builder.getPointerField(0 * ::capnp::POINTERS).isNull();
}
inline  ::capnp::List< ::capnp::compiler::Statement>::Reader LexedStatements::Reader::getStatements() const {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::get(
      _reader.getPointerField(0 * ::capnp::POINTERS));
}
inline  ::capnp::List< ::capnp::compiler::Statement>::Builder LexedStatements::Builder::getStatements() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::get(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}
inline void LexedStatements::Builder::setStatements( ::capnp::List< ::capnp::compiler::Statement>::Reader value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::set(
      _builder.getPointerField(0 * ::capnp::POINTERS), value);
}
inline  ::capnp::List< ::capnp::compiler::Statement>::Builder LexedStatements::Builder::initStatements(unsigned int size) {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::init(
      _builder.getPointerField(0 * ::capnp::POINTERS), size);
}
inline void LexedStatements::Builder::adoptStatements(
    ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>>&& value) {
  ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::adopt(
      _builder.getPointerField(0 * ::capnp::POINTERS), kj::mv(value));
}
inline ::capnp::Orphan< ::capnp::List< ::capnp::compiler::Statement>> LexedStatements::Builder::disownStatements() {
  return ::capnp::_::PointerHelpers< ::capnp::List< ::capnp::compiler::Statement>>::disown(
      _builder.getPointerField(0 * ::capnp::POINTERS));
}

}  // namespace
}  // namespace

#endif  // CAPNP_INCLUDED_a73956d2621fc3ee_
