/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "DicomTreeStudyComponent.h"
#include "DicomTreeDirectoryComponent.h"
#include "DicomTreeSerieComponent.h"

// GDCM includes
#include <gdcmScanner.h>
#include <gdcmIPPSorter.h>

using namespace camitk;


// --------------- Constructor -------------------
DicomTreeStudyComponent::DicomTreeStudyComponent(const std::vector< std::string > & fileNames) throw(AbortException) : Component("", "", NO_REPRESENTATION) {
    InterfaceNode* comp = this->getParent();

    // scan files study description
    gdcm::Scanner studyDescriptionScanner;
    gdcm::Tag studyDescriptionTag = gdcm::Tag(0x0008, 0x1030);
    studyDescriptionScanner.AddTag(studyDescriptionTag);
    studyDescriptionScanner.Scan(fileNames);
    const char* file = fileNames.at(0).c_str();
    setName(QString(studyDescriptionScanner.GetValue(file, studyDescriptionTag)));

    // scan files for series
    gdcm::Scanner seriesScanner;
    gdcm::Tag serieUIDTag = gdcm::Tag(0x0020, 0x000e);
    seriesScanner.AddTag(serieUIDTag);
    seriesScanner.Scan(fileNames);
    const std::set< std::string > serieValues = seriesScanner.GetValues();
    foreach(std::string value, serieValues) {
        std::vector< std::string > serieFileNames = seriesScanner.GetAllFilenamesFromTagToValue(serieUIDTag, value.c_str());

        // This filter aims at removing volumic images containing only a few images, for doctors TOPO for instance
        // if ippsorter algorithm returns 0, it means it hasn't been able to sort the files according to their Z spacing
        // It could come from a bad z spacing tolerance or the image files have no z spacing
        gdcm::IPPSorter ippsorter;
        ippsorter.SetComputeZSpacing(true);
        ippsorter.SetZSpacingTolerance(0.01);
        ippsorter.Sort(serieFileNames);
        serieFileNames = ippsorter.GetFilenames();

        if(serieFileNames.size() > 0)
            addChild(new DicomTreeSerieComponent(serieFileNames));
    }
}
// --------------- destructor -------------------
DicomTreeStudyComponent::~DicomTreeStudyComponent() {

}

