/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     YSHAPES = 258,
     YELASTIC = 259,
     YPADDING = 260,
     YSAMPLE = 261,
     YENDSAMPLE = 262,
     YBOX = 263,
     YEND = 264,
     YUNREC = 265,
     YREPLACE = 266,
     YREVERSE = 267,
     YTO = 268,
     YWITH = 269,
     YCHGDEL = 270,
     KEYWORD = 271,
     WORD = 272,
     STRING = 273,
     SHAPE = 274,
     YNUMBER = 275,
     YRXPFLAG = 276,
     YDELWORD = 277
   };
#endif
#define YSHAPES 258
#define YELASTIC 259
#define YPADDING 260
#define YSAMPLE 261
#define YENDSAMPLE 262
#define YBOX 263
#define YEND 264
#define YUNREC 265
#define YREPLACE 266
#define YREVERSE 267
#define YTO 268
#define YWITH 269
#define YCHGDEL 270
#define KEYWORD 271
#define WORD 272
#define STRING 273
#define SHAPE 274
#define YNUMBER 275
#define YRXPFLAG 276
#define YDELWORD 277




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

/*
 *  File:             parser.y
 *  Date created:     March 16, 1999 (Tuesday, 17:17h)
 *  Author:           Copyright (C) 1999 Thomas Jensen <boxes@thomasjensen.com>
 *  Version:          $Id: parser.y,v 1.25 2006/07/23 16:11:39 tsjensen Exp $
 *  Language:         GNU bison (ANSI C)
 *  World Wide Web:   http://boxes.thomasjensen.com/
 *  Purpose:          Yacc parser for boxes configuration files
 *
 *  Remarks: o This program is free software; you can redistribute it and/or
 *             modify it under the terms of the GNU General Public License as
 *             published by the Free Software Foundation; either version 2 of
 *             the License, or (at your option) any later version.
 *           o This program is distributed in the hope that it will be useful,
 *             but WITHOUT ANY WARRANTY; without even the implied warranty of
 *             MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *             GNU General Public License for more details.
 *           o You should have received a copy of the GNU General Public
 *             License along with this program; if not, write to the Free
 *             Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *             MA 02111-1307  USA
 *
 *  Revision History:
 *
 *    $Log: parser.y,v $
 *    Revision 1.25  2006/07/23 16:11:39  tsjensen
 *    Removed unsigned modifier from a pointer declaration in order to clear a warning
 *    which appeared on some Linuxes (reported by Andreas Heiduk)
 *
 *    Revision 1.24  2006/07/22 19:30:55  tsjensen
 *    Fix: Renamed yylineno to tjlineno to enable compilation on certain
 *    flexes (reported by Andreas Heiduk)
 *
 *    Revision 1.23  2006/07/12 05:31:25  tsjensen
 *    Updated email and web addresses in comment header
 *
 *    Revision 1.22  1999-08-21 08:53:58-07  tsjensen
 *    Removed check for empty sample block, which is also done in lexer.l
 *
 *    Revision 1.21  1999/08/18 15:38:44  tsjensen
 *    Added new tokens YCHGDEL and YDELWORD
 *    Added code for DELIMITER statements
 *
 *    Revision 1.20  1999/08/16 16:29:25  tsjensen
 *    Changed SAMPLE block syntax to get rid of all the quoting sh*t in SAMPLE
 *    blocks. Samples now look authentic even in the config file. Very simple now.
 *    Added new token YENDSAMPLE in the process.
 *
 *    Revision 1.19  1999/08/14 19:19:25  tsjensen
 *    Added anz_shapespec variable to count non-deepempty user-specified shapes
 *    (must at least be 1)
 *    Moved yylex declaration to lexer.h, where it belongs
 *    Bugfix: bison and yacc seem to differ in the way action code is treated
 *    which is associated with an error token. Since bison calls the action
 *    routine whenever a token is skipped while recovering, added skipping
 *    variable to ensure that only one "skipping to next design" message is
 *    printed. That was not necessary before. %-/
 *    Removed existence check from corner_check() routine (obsolete).
 *    Added code to generate required shapes which were not specified by the user
 *    Clean-up in shape_def rule (use freeshape() and some more)
 *
 *    Revision 1.18  1999/07/23 16:14:17  tsjensen
 *    Added computation of height of highest shape in design (maxshapeheight)
 *    Options -l and -d together now call quickinfo mode -> parse only 1 design
 *
 *    Revision 1.17  1999/07/22 12:27:16  tsjensen
 *    Added GNU GPL disclaimer
 *    Renamed parser.h include to lexer.h (same file)
 *    Added include config.h
 *
 *    Revision 1.16  1999/07/02 11:54:52  tsjensen
 *    Some minor changes to please compiler
 *    Communication of speed mode to lexer
 *    Bugfix: Forgot to check for opt.l before calling YYACCEPT
 *
 *    Revision 1.15  1999/06/30 12:13:47  tsjensen
 *    Now parsing only those designs which will be needed later on
 *    Checks formerly done in boxes.c now done here (no valid designs etc.)
 *
 *    Revision 1.14  1999/06/28 18:32:51  tsjensen
 *    Unified appearance of error messages, which are now all based on yyerror()
 *    Eliminated duplicate code by introducing intermediate rules
 *    New tokens YTO, YWITH, and YRXPFLAG to reduce strcasecmp() usage
 *    New token YUNREC for integration of lexer into error handling
 *    Some code restructuring and rule renaming for better consistency
 *    Added out-of-memory-checks to many strdup()s and such
 *
 *    Revision 1.13  1999/06/28 12:15:47  tsjensen
 *    Added error handling. Now skips to next design on error.
 *    Replaced DEBUG macro with PARSER_DEBUG, which is now activated in boxes.h
 *    Added rule first_rule, which performs init and cleanup formerly done in main()
 *    Introduced symbols YBOX and YEND
 *
 *    Revision 1.12  1999/06/22 12:01:01  tsjensen
 *    Added #undef DEBUG, because DEBUGging is now activated in boxes.h
 *    Added #include tools.h
 *
 *    Revision 1.11  1999/06/20 14:18:51  tsjensen
 *    Adden YPADDING and YNUMBER tokens plus code for padding blocks
 *
 *    Revision 1.10  1999/06/17 19:04:45  tsjensen
 *    Added detection of empty sample blocks (we don't want that)
 *    Added detection of duplicate sample blocks
 *
 *    Revision 1.9  1999/06/14 12:13:01  tsjensen
 *    Added YREVERSE token
 *    Added code for regexp reversion
 *
 *    Revision 1.7  1999/04/09 13:31:54  tsjensen
 *    Added checks for duplicate design names
 *    Added checks for valid design names (no extended ASCII or ctrl chars)
 *    Removed all code related to OFFSET blocks (obsolete)
 *
 *    Revision 1.6  1999/04/04 16:07:53  tsjensen
 *    Enforced use of PROJECT macro
 *    Added "indent" directive to grammar
 *    Added "replace" directive to grammar
 *
 *    Revision 1.5  1999/03/30 13:29:50  tsjensen
 *    Added computation of minimum width/height of each design.
 *
 *    Revision 1.4  1999/03/30 09:37:51  tsjensen
 *    It drew a correct box for the first time!
 *
 *    Revision 1.3  1999/03/24 17:29:12  tsjensen
 *    Added detection of empty shapes ("") which are now cleared (+warning)
 *    Changed rcs string to #ident directive
 *
 *    Revision 1.1  1999/03/18 15:10:06  tsjensen
 *    Initial revision
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "shape.h"
#include "boxes.h"
#include "tools.h"
#include "lexer.h"


const char rcsid_parser_y[] =
    "$Id: parser.y,v 1.25 2006/07/23 16:11:39 tsjensen Exp $";


static int pflicht = 0;
static int time_for_se_check = 0;
static int anz_shapespec = 0;            /* number of user-specified shapes */

int speeding = 0;                        /* true if we're skipping designs, */
                                         /* but no error                    */
static int skipping = 0;                 /* used to limit "skipping" msgs */



static int check_sizes()
/*
 *  For the author's convenience, it is required that shapes on one side
 *  have equal width (vertical sides) and height (horizontal sides).
 *
 *  RETURNS:  == 0   no problem detected
 *            != 0   on error (prints error message, too)
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
{
    int i, j, k;

    #ifdef PARSER_DEBUG
        fprintf (stderr, "check_sizes()\n");
    #endif

    for (i=0; i<ANZ_SIDES; ++i) {
        if (i == 0 || i == 2) {
            /*
             *  horizontal
             */
            for (j=0; j<SHAPES_PER_SIDE-1; ++j) {
                if (designs[design_idx].shape[sides[i][j]].height == 0)
                    continue;
                for (k=j+1; k<SHAPES_PER_SIDE; ++k) {
                    if (designs[design_idx].shape[sides[i][k]].height == 0)
                        continue;
                    if (designs[design_idx].shape[sides[i][j]].height
                            != designs[design_idx].shape[sides[i][k]].height) {
                        yyerror ("All shapes on horizontal sides must be of "
                                "equal height (%s: %d, %s: %d)\n",
                                shape_name[sides[i][j]],
                                designs[design_idx].shape[sides[i][j]].height,
                                shape_name[sides[i][k]],
                                designs[design_idx].shape[sides[i][k]].height);
                        return 1;
                    }
                }
            }
        }
        else {
            /*
             *  vertical
             */
            for (j=0; j<SHAPES_PER_SIDE-1; ++j) {
                if (designs[design_idx].shape[sides[i][j]].width == 0)
                    continue;
                for (k=j+1; k<SHAPES_PER_SIDE; ++k) {
                    if (designs[design_idx].shape[sides[i][k]].width == 0)
                        continue;
                    if (designs[design_idx].shape[sides[i][j]].width
                            != designs[design_idx].shape[sides[i][k]].width) {
                        yyerror ("All shapes on vertical sides must be of "
                                "equal width (%s: %d, %s: %d)\n",
                                shape_name[sides[i][j]],
                                designs[design_idx].shape[sides[i][j]].width,
                                shape_name[sides[i][k]],
                                designs[design_idx].shape[sides[i][k]].width);
                        return 1;
                    }
                }
            }
        }
    }

    return 0;                            /* all clear */
}



static int corner_check()
/*
 *  Check that no corners are elastic.
 *
 *  RETURNS:  == 0   no problem detected
 *            != 0   on error
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
{
    int c;

    #ifdef PARSER_DEBUG
        fprintf (stderr, "corner_check()\n");
    #endif

    for (c=0; c<ANZ_CORNERS; ++c) {
        if (designs[design_idx].shape[corners[c]].elastic) {
            yyerror ("Corners may not be elastic (%s)", shape_name[corners[c]]);
            return 1;
        }
    }

    return 0;                            /* all clear */
}



static shape_t non_existent_elastics()
{
    shape_t i;

    #ifdef PARSER_DEBUG
        fprintf (stderr, "non_existent_elastics()\n");
    #endif

    for (i=0; i<ANZ_SHAPES; ++i) {
        if (designs[design_idx].shape[i].elastic
         && isempty(designs[design_idx].shape+i))
            return i;
    }

    return (shape_t) ANZ_SHAPES;         /* all elastic shapes exist */
}



static int insufficient_elasticity()
{
    int i, j, ef;

    #ifdef PARSER_DEBUG
        fprintf (stderr, "insufficient_elasticity()\n");
    #endif

    for (i=0; i<ANZ_SIDES; ++i) {
        for (j=1,ef=0; j<4; ++j)
            if (designs[design_idx].shape[sides[i][j]].elastic)
                ++ef;
        if (ef != 1 && ef != 2)
            return 1;                    /* error */
    }

    return 0;                            /* all clear */
}



static int adjoining_elastics()
{
    int i, j, ef;

    #ifdef PARSER_DEBUG
        fprintf (stderr, "adjoining_elastics()\n");
    #endif

    for (i=0; i<ANZ_SIDES; ++i) {
        ef = 0;
        for (j=1; j<4; ++j) {
            if (isempty(designs[design_idx].shape+sides[i][j]))
                continue;
            if (designs[design_idx].shape[sides[i][j]].elastic) {
                if (ef)
                    return 1;            /* error detected */
                else
                    ef = 1;
            }
            else {
                ef = 0;
            }
        }
    }

    return 0;                            /* all clear */
}



static int perform_se_check()
/*
 *  (shape-elastic check)
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
{
    shape_t s_rc;

    s_rc = non_existent_elastics();
    if (s_rc != ANZ_SHAPES) {
        yyerror ("Shape %s has been specified as elastic but doesn't exist",
                shape_name[s_rc]);
        return 1;
    }

    if (corner_check()) {
        /* Error message printed in check func */
        return 1;
    }

    if (insufficient_elasticity()) {
        yyerror ("There must be exactly one or two elastic shapes per side");
        return 1;
    }

    if (adjoining_elastics()) {
        yyerror ("Two adjoining shapes may not be elastic");
        return 1;
    }

    return 0;
}



static void recover()
/*
 *  Reset parser to neutral state, so a new design can be parsed.
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
{
     pflicht = 0;
     time_for_se_check = 0;
     anz_shapespec = 0;
     chg_strdelims ('\\', '\"');

     /*
      *  Clear current design
      */
     BFREE (designs[design_idx].name);
     BFREE (designs[design_idx].author);
     BFREE (designs[design_idx].created);
     BFREE (designs[design_idx].revision);
     BFREE (designs[design_idx].revdate);
     BFREE (designs[design_idx].sample);
     memset (designs+design_idx, 0, sizeof(design_t));
     designs[design_idx].indentmode = DEF_INDENTMODE;
}



static int design_needed (const char *name, const int design_idx)
/*
 *  Return true if design of name name will be needed later on
 *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
{
    if (opt.design_choice_by_user) {
        return !strcasecmp (name, (char *) opt.design);
    }
    else {
        if (opt.r || opt.l)
            return 1;
        if (design_idx == 0)
            return 1;
    }

    return 0;
}




/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 416 "parser.y"
typedef union YYSTYPE {
    char *s;
    char c;
    shape_t shape;
    sentry_t sentry;
    int num;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 541 "parser.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 553 "parser.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   64

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  28
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  19
/* YYNRULES -- Number of rules. */
#define YYNRULES  37
/* YYNRULES -- Number of states. */
#define YYNSTATES  70

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   277

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      25,    26,     2,     2,    27,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    23,     2,    24,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     4,     7,    10,    12,    14,    16,    17,
      24,    27,    30,    32,    34,    37,    40,    43,    47,    52,
      57,    63,    69,    74,    76,    77,    81,    83,    85,    88,
      90,    93,    97,   100,   104,   106,   109,   111
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      29,     0,    -1,    -1,    30,    31,    -1,    31,    32,    -1,
      32,    -1,    33,    -1,     1,    -1,    -1,     8,    17,    34,
      35,     9,    17,    -1,    35,    36,    -1,    35,    37,    -1,
      36,    -1,    37,    -1,    16,    18,    -1,    15,    22,    -1,
      17,    18,    -1,     6,    18,     7,    -1,     3,    23,    41,
      24,    -1,     4,    25,    39,    26,    -1,    11,    38,    18,
      14,    18,    -1,    12,    38,    18,    13,    18,    -1,     5,
      23,    45,    24,    -1,    21,    -1,    -1,    39,    27,    40,
      -1,    40,    -1,    19,    -1,    41,    42,    -1,    42,    -1,
      19,    43,    -1,    25,    44,    26,    -1,    25,    26,    -1,
      44,    27,    18,    -1,    18,    -1,    45,    46,    -1,    46,
      -1,    17,    20,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   445,   445,   445,   488,   488,   491,   491,   503,   502,
     582,   582,   582,   582,   585,   637,   655,   664,   689,   831,
     840,   871,   902,   915,   920,   926,   926,   929,   940,   940,
     943,   963,   972,   979,  1009,  1034,  1034,  1037
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "YSHAPES", "YELASTIC", "YPADDING", 
  "YSAMPLE", "YENDSAMPLE", "YBOX", "YEND", "YUNREC", "YREPLACE", 
  "YREVERSE", "YTO", "YWITH", "YCHGDEL", "KEYWORD", "WORD", "STRING", 
  "SHAPE", "YNUMBER", "YRXPFLAG", "YDELWORD", "'{'", "'}'", "'('", "')'", 
  "','", "$accept", "first_rule", "@1", "config_file", "design_or_error", 
  "design", "@2", "layout", "entry", "block", "rflag", "elist", 
  "elist_entry", "slist", "slist_entry", "shape_def", "shape_lines", 
  "wlist", "wlist_entry", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   123,   125,    40,    41,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    28,    30,    29,    31,    31,    32,    32,    34,    33,
      35,    35,    35,    35,    36,    36,    36,    37,    37,    37,
      37,    37,    37,    38,    38,    39,    39,    40,    41,    41,
      42,    43,    43,    44,    44,    45,    45,    46
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     2,     2,     1,     1,     1,     0,     6,
       2,     2,     1,     1,     2,     2,     2,     3,     4,     4,
       5,     5,     4,     1,     0,     3,     1,     1,     2,     1,
       2,     3,     2,     3,     1,     2,     1,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,     0,     1,     7,     0,     0,     5,     6,     8,
       4,     0,     0,     0,     0,     0,    24,    24,     0,     0,
       0,     0,    12,    13,     0,     0,     0,     0,    23,     0,
       0,    15,    14,    16,     0,    10,    11,     0,     0,    29,
      27,     0,    26,     0,     0,    36,    17,     0,     0,     9,
       0,    30,    18,    28,    19,     0,    37,    22,    35,     0,
       0,    34,    32,     0,    25,    20,    21,    31,     0,    33
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     1,     2,     6,     7,     8,    11,    21,    22,    23,
      29,    41,    42,    38,    39,    51,    63,    44,    45
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -15
static const yysigned_char yypact[] =
{
     -15,     4,    29,   -15,   -15,   -10,    25,   -15,   -15,   -15,
     -15,    12,    -1,     7,    13,    21,    19,    19,    20,    23,
      26,    -3,   -15,   -15,    24,    27,    28,    40,   -15,    30,
      31,   -15,   -15,   -15,    33,   -15,   -15,    32,   -14,   -15,
     -15,    -6,   -15,    34,    14,   -15,   -15,    37,    39,   -15,
      -7,   -15,   -15,   -15,   -15,    27,   -15,   -15,   -15,    35,
      38,   -15,   -15,     8,   -15,   -15,   -15,   -15,    41,   -15
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -15,   -15,   -15,   -15,    49,   -15,   -15,   -15,    42,    43,
      44,   -15,     3,   -15,    22,   -15,   -15,   -15,    18
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -4
static const yysigned_char yytable[] =
{
      12,    13,    14,    15,     3,    37,    34,     9,    16,    17,
      52,    61,    18,    19,    20,    12,    13,    14,    15,    62,
      54,    55,    24,    16,    17,    -3,     4,    18,    19,    20,
       4,    43,    25,     5,    67,    68,    26,     5,    57,    27,
      28,    32,    31,    37,    33,    43,    40,    46,    47,    48,
      49,    59,    60,    65,    56,    10,    66,    50,    64,    69,
      53,    30,    58,    35,    36
};

static const unsigned char yycheck[] =
{
       3,     4,     5,     6,     0,    19,     9,    17,    11,    12,
      24,    18,    15,    16,    17,     3,     4,     5,     6,    26,
      26,    27,    23,    11,    12,     0,     1,    15,    16,    17,
       1,    17,    25,     8,    26,    27,    23,     8,    24,    18,
      21,    18,    22,    19,    18,    17,    19,     7,    18,    18,
      17,    14,    13,    18,    20,     6,    18,    25,    55,    18,
      38,    17,    44,    21,    21
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    29,    30,     0,     1,     8,    31,    32,    33,    17,
      32,    34,     3,     4,     5,     6,    11,    12,    15,    16,
      17,    35,    36,    37,    23,    25,    23,    18,    21,    38,
      38,    22,    18,    18,     9,    36,    37,    19,    41,    42,
      19,    39,    40,    17,    45,    46,     7,    18,    18,    17,
      25,    43,    24,    42,    26,    27,    20,    24,    46,    14,
      13,    18,    26,    44,    40,    18,    18,    26,    27,    18
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 445 "parser.y"
    {
        /*
         *  Initialize parser data structures
         */
        designs = (design_t *) calloc (1, sizeof(design_t));
        if (designs == NULL) {
            perror (PROJECT);
            YYABORT;
        }
        designs->indentmode = DEF_INDENTMODE;
    ;}
    break;

  case 3:
#line 457 "parser.y"
    {
        /*
         *  Clean up parser data structures
         */
        design_t *tmp;

        if (design_idx == 0) {
            BFREE (designs);
            anz_designs = 0;
            if (opt.design_choice_by_user) {
                fprintf (stderr, "%s: unknown box design -- %s\n",
                        PROJECT, (char *) opt.design);
            }
            else {
                yyerror ("no valid designs found");
            }
            YYABORT;
        }

        --design_idx;
        anz_designs = design_idx + 1;
        tmp = (design_t *) realloc (designs, anz_designs*sizeof(design_t));
        if (!tmp) {
            perror (PROJECT);
            YYABORT;
        }
        designs = tmp;
    ;}
    break;

  case 7:
#line 492 "parser.y"
    {
        if (!speeding && !skipping) {
            recover();
            yyerror ("skipping to next design");
            skipping = 1;
        }
    ;}
    break;

  case 8:
#line 503 "parser.y"
    {
        chg_strdelims ('\\', '\"');
        skipping = 0;
        if (!design_needed (yyvsp[0].s, design_idx)) {
            speeding = 1;
            begin_speedmode();
            YYERROR;
        }
    ;}
    break;

  case 9:
#line 513 "parser.y"
    {
        design_t *tmp;
        int i;
        char *p;

        #ifdef PARSER_DEBUG
            fprintf (stderr, "--------- ADDING DESIGN \"%s\".\n", yyvsp[-4].s);
        #endif

        if (strcasecmp (yyvsp[-4].s, yyvsp[0].s)) {
            yyerror ("box design name differs at BOX and END");
            YYERROR;
        }
        if (pflicht < 3) {
            yyerror ("entries SAMPLE, SHAPES, and ELASTIC are mandatory");
            YYERROR;
        }
        
        for (i=0; i<design_idx; ++i) {
            if (strcasecmp (yyvsp[-4].s, designs[i].name) == 0) {
                yyerror ("duplicate box design name -- %s", yyvsp[-4].s);
                YYERROR;
            }
        }

        p = yyvsp[-4].s;
        while (*p) {
            if (*p < 32 || *p > 126) {
                yyerror ("box design name must consist of printable standard "
                         "ASCII characters.");
                YYERROR;
            }
            ++p;
        }

        designs[design_idx].name = (char *) strdup (yyvsp[-4].s);
        if (designs[design_idx].name == NULL) {
            perror (PROJECT);
            YYABORT;
        }
        pflicht = 0;
        time_for_se_check = 0;
        anz_shapespec = 0;

        /*
         *  Check if we need to continue parsing. If not, return.
         *  The condition here must correspond to design_needed().
         */
        if (opt.design_choice_by_user || (!opt.r && !opt.l)) {
            anz_designs = design_idx + 1;
            YYACCEPT;
        }

        /*
         *  Allocate space for next design
         */
        ++design_idx;
        tmp = (design_t *) realloc (designs, (design_idx+1)*sizeof(design_t));
        if (tmp == NULL) {
            perror (PROJECT);
            YYABORT;
        }
        designs = tmp;
        memset (&(designs[design_idx]), 0, sizeof(design_t));
        designs[design_idx].indentmode = DEF_INDENTMODE;
    ;}
    break;

  case 14:
#line 586 "parser.y"
    {
        #ifdef PARSER_DEBUG
            fprintf (stderr, "entry rule fulfilled [%s = %s]\n", yyvsp[-1].s, yyvsp[0].s);
        #endif
        if (strcasecmp (yyvsp[-1].s, "author") == 0) {
            designs[design_idx].author = (char *) strdup (yyvsp[0].s);
            if (designs[design_idx].author == NULL) {
                perror (PROJECT);
                YYABORT;
            }
        }
        else if (strcasecmp (yyvsp[-1].s, "revision") == 0) {
            designs[design_idx].revision = (char *) strdup (yyvsp[0].s);
            if (designs[design_idx].revision == NULL) {
                perror (PROJECT);
                YYABORT;
            }
        }
        else if (strcasecmp (yyvsp[-1].s, "created") == 0) {
            designs[design_idx].created = (char *) strdup (yyvsp[0].s);
            if (designs[design_idx].created == NULL) {
                perror (PROJECT);
                YYABORT;
            }
        }
        else if (strcasecmp (yyvsp[-1].s, "revdate") == 0) {
            designs[design_idx].revdate = (char *) strdup (yyvsp[0].s);
            if (designs[design_idx].revdate == NULL) {
                perror (PROJECT);
                YYABORT;
            }
        }
        else if (strcasecmp (yyvsp[-1].s, "indent") == 0) {
            if (strcasecmp (yyvsp[0].s, "text") == 0 ||
                strcasecmp (yyvsp[0].s, "box") == 0 ||
                strcasecmp (yyvsp[0].s, "none") == 0) {
                designs[design_idx].indentmode = yyvsp[0].s[0];
            }
            else {
                yyerror ("indent keyword must be followed by \"text\", "
                         "\"box\", or \"none\"");
                YYERROR;
            }
        }
        else {
            yyerror ("internal parser error (unrecognized: %s) in line %d "
                    "of %s.", yyvsp[-1].s, __LINE__, __FILE__);
            YYERROR;
        }
    ;}
    break;

  case 15:
#line 638 "parser.y"
    {
        if (strlen(yyvsp[0].s) != 2) {
            yyerror ("invalid string delimiter specification -- %s", yyvsp[0].s);
            YYERROR;
        }
        if ((yyvsp[0].s)[0] == (yyvsp[0].s)[1]) {
            yyerror ("string delimiter and escape char may not be the same");
            YYERROR;
        }
        if (strchr (LEX_SDELIM, (yyvsp[0].s)[1]) == NULL) {
            yyerror ("invalid string delimiter -- %c (try one of %s)",
                    (yyvsp[0].s)[1], LEX_SDELIM);
            YYERROR;
        }
        chg_strdelims (yyvsp[0].s[0], yyvsp[0].s[1]);
    ;}
    break;

  case 16:
#line 656 "parser.y"
    {
        #ifdef PARSER_DEBUG
            fprintf (stderr, "%s: Discarding entry [%s = %s].\n", PROJECT, yyvsp[-1].s, yyvsp[0].s);
        #endif
    ;}
    break;

  case 17:
#line 665 "parser.y"
    {
        /*
         *  SAMPLE block    (STRING is non-empty if we get here)
         */
        char *line;

        #ifdef PARSER_DEBUG
            fprintf (stderr, "SAMPLE block rule satisfied\n");
        #endif

        if (designs[design_idx].sample) {
            yyerror ("duplicate SAMPLE block");
            YYERROR;
        }
        line = (char *) strdup (yyvsp[-1].s);
        if (line == NULL) {
            perror (PROJECT);
            YYABORT;
        }

        designs[design_idx].sample = line;
        ++pflicht;
    ;}
    break;

  case 18:
#line 690 "parser.y"
    {
        int     i,j;
        shape_t fshape;                  /* found shape */
        int     fside;                   /* first side */
        int     sc;                      /* side counter */
        int     side;                    /* effective side */
        int     rc;                      /* received return code */

        /*
         *  At least one shape must be specified
         */
        if (anz_shapespec < 1) {
            yyerror ("must specify at least one non-empty shape per design");
            YYERROR;
        }

        /*
         *  Ensure that all corners have been specified. Generate corners
         *  as necessary, starting at any side which already includes at
         *  least one shape in order to ensure correct measurements.
         */
        fshape = findshape (designs[design_idx].shape, ANZ_SHAPES);
        if (fshape == ANZ_SHAPES) {
            yyerror ("internal error");
            YYABORT;                        /* never happens ;-) */
        }
        fside = on_side (fshape, 0);
        if (fside == ANZ_SIDES) {
            yyerror ("internal error");
            YYABORT;                        /* never happens ;-) */
        }

        for (sc=0,side=fside; sc<ANZ_SIDES; ++sc,side=(side+1)%ANZ_SIDES) {
            shape_t   nshape;               /* next shape */
            sentry_t *c;                    /* corner to be processed */
            c = designs[design_idx].shape + sides[side][SHAPES_PER_SIDE-1];

            if (isempty(c)) {
                nshape = findshape (c, SHAPES_PER_SIDE);
                if (side == BLEF || side == BRIG) {
                    if (nshape == SHAPES_PER_SIDE)
                        c->height = 1;
                    else
                        c->height = c[nshape].height;
                    c->width = designs[design_idx].shape[fshape].width;
                }
                else {
                    if (nshape == SHAPES_PER_SIDE)
                        c->width = 1;
                    else
                        c->width = c[nshape].width;
                    c->height = designs[design_idx].shape[fshape].height;
                }
                c->elastic = 0;
                rc = genshape (c->width, c->height, &(c->chars));
                if (rc)
                    YYABORT;
            }

            fshape = sides[side][SHAPES_PER_SIDE-1];
        }

        /*
         *  For all sides whose side shapes have not been defined, generate
         *  an elastic middle side shape.
         */
        for (side=0; side<ANZ_SIDES; ++side) {
            int found = 0;
            for (i=1; i<SHAPES_PER_SIDE-1; ++i) {
                if (isempty (designs[design_idx].shape + sides[side][i]))
                    continue;
                else
                    found = 1;
            }
            if (!found) {
                sentry_t *c = designs[design_idx].shape
                    + sides[side][SHAPES_PER_SIDE/2];
                if (side == BLEF || side == BRIG) {
                    c->width = designs[design_idx].shape[sides[side][0]].width;
                    c->height = 1;
                }
                else {
                    c->width = 1;
                    c->height = designs[design_idx].shape[sides[side][0]].height;
                }
                c->elastic = 1;
                rc = genshape (c->width, c->height, &(c->chars));
                if (rc)
                    YYABORT;
            }
        }

        if (check_sizes())
            YYERROR;

        ++pflicht;
        if (++time_for_se_check > 1) {
            if (perform_se_check() != 0)
                YYERROR;
        }

        /*
         *  Compute minimum height/width of a box of current design
         */
        for (i=0; i<ANZ_SIDES; ++i) {
            size_t c = 0;
            if (i % 2) {                 /* vertical sides */
                for (j=0; j<SHAPES_PER_SIDE; ++j) {
                    if (!isempty(designs[design_idx].shape + sides[i][j]))
                        c += designs[design_idx].shape[sides[i][j]].height;
                }
                if (c > designs[design_idx].minheight)
                    designs[design_idx].minheight = c;
            }
            else {                       /* horizontal sides */
                for (j=0; j<SHAPES_PER_SIDE; ++j) {
                    if (!isempty(designs[design_idx].shape + sides[i][j]))
                        c += designs[design_idx].shape[sides[i][j]].width;
                }
                if (c > designs[design_idx].minwidth)
                    designs[design_idx].minwidth = c;
            }
        }

        /*
         *  Compute height of highest shape in design
         */
        for (i=0; i<ANZ_SHAPES; ++i) {
            if (isempty(designs[design_idx].shape + i))
                continue;
            if (designs[design_idx].shape[i].height > designs[design_idx].maxshapeheight)
                designs[design_idx].maxshapeheight = designs[design_idx].shape[i].height;
        }
        #ifdef PARSER_DEBUG
            fprintf (stderr, "Minimum box dimensions: width %d height %d\n",
                    designs[design_idx].minwidth, designs[design_idx].minheight);
            fprintf (stderr, "Maximum shape height: %d\n",
                    designs[design_idx].maxshapeheight);
        #endif
    ;}
    break;

  case 19:
#line 832 "parser.y"
    {
        ++pflicht;
        if (++time_for_se_check > 1) {
            if (perform_se_check() != 0)
                YYERROR;
        }
    ;}
    break;

  case 20:
#line 841 "parser.y"
    {
        int a = designs[design_idx].anz_reprules;

        #ifdef PARSER_DEBUG
            fprintf (stderr, "Adding replacement rule: \"%s\" with \"%s\" (%c)\n",
                    yyvsp[-2].s, yyvsp[0].s, yyvsp[-3].c);
        #endif

        designs[design_idx].reprules = (reprule_t *) realloc
            (designs[design_idx].reprules, (a+1) * sizeof(reprule_t));
        if (designs[design_idx].reprules == NULL) {
            perror (PROJECT);
            YYABORT;
        }
        memset (&(designs[design_idx].reprules[a]), 0, sizeof(reprule_t));
        designs[design_idx].reprules[a].search =
            (char *) strdup (yyvsp[-2].s);
        designs[design_idx].reprules[a].repstr =
            (char *) strdup (yyvsp[0].s);
        if (designs[design_idx].reprules[a].search == NULL
         || designs[design_idx].reprules[a].repstr == NULL)
        {
            perror (PROJECT);
            YYABORT;
        }
        designs[design_idx].reprules[a].line = tjlineno;
        designs[design_idx].reprules[a].mode = yyvsp[-3].c;
        designs[design_idx].anz_reprules = a + 1;
    ;}
    break;

  case 21:
#line 872 "parser.y"
    {
        int a = designs[design_idx].anz_revrules;

        #ifdef PARSER_DEBUG
            fprintf (stderr, "Adding reversion rule: \"%s\" to \"%s\" (%c)\n",
                    yyvsp[-2].s, yyvsp[0].s, yyvsp[-3].c);
        #endif

        designs[design_idx].revrules = (reprule_t *) realloc
            (designs[design_idx].revrules, (a+1) * sizeof(reprule_t));
        if (designs[design_idx].revrules == NULL) {
            perror (PROJECT);
            YYABORT;
        }
        memset (&(designs[design_idx].revrules[a]), 0, sizeof(reprule_t));
        designs[design_idx].revrules[a].search =
            (char *) strdup (yyvsp[-2].s);
        designs[design_idx].revrules[a].repstr =
            (char *) strdup (yyvsp[0].s);
        if (designs[design_idx].revrules[a].search == NULL
         || designs[design_idx].revrules[a].repstr == NULL)
        {
            perror (PROJECT);
            YYABORT;
        }
        designs[design_idx].revrules[a].line = tjlineno;
        designs[design_idx].revrules[a].mode = yyvsp[-3].c;
        designs[design_idx].anz_revrules = a + 1;
    ;}
    break;

  case 22:
#line 903 "parser.y"
    {
        #ifdef PARSER_DEBUG
            fprintf (stderr, "Padding set to (l%d o%d r%d u%d)\n",
                    designs[design_idx].padding[BLEF],
                    designs[design_idx].padding[BTOP],
                    designs[design_idx].padding[BRIG],
                    designs[design_idx].padding[BBOT]);
        #endif
    ;}
    break;

  case 23:
#line 916 "parser.y"
    {
        yyval.c = yyvsp[0].c;
    ;}
    break;

  case 24:
#line 920 "parser.y"
    {
        yyval.c = 'g';
    ;}
    break;

  case 27:
#line 930 "parser.y"
    {
        #ifdef PARSER_DEBUG
            fprintf (stderr, "Marked \'%s\' shape as elastic\n",
                    shape_name[(int)yyvsp[0].shape]);
        #endif
        designs[design_idx].shape[yyvsp[0].shape].elastic = 1;
    ;}
    break;

  case 30:
#line 944 "parser.y"
    {
        #ifdef PARSER_DEBUG
            fprintf (stderr, "Adding shape spec for \'%s\' (width %d "
                    "height %d)\n", shape_name[yyvsp[-1].shape], yyvsp[0].sentry.width, yyvsp[0].sentry.height);
        #endif

        if (isempty (designs[design_idx].shape + yyvsp[-1].shape)) {
            designs[design_idx].shape[yyvsp[-1].shape] = yyvsp[0].sentry;
            if (!isdeepempty(&(yyvsp[0].sentry)))
                ++anz_shapespec;
        }
        else {
            yyerror ("duplicate specification for %s shape", shape_name[yyvsp[-1].shape]);
            YYERROR;
        }
    ;}
    break;

  case 31:
#line 964 "parser.y"
    {
        if (yyvsp[-1].sentry.width == 0 || yyvsp[-1].sentry.height == 0) {
            yyerror ("minimum shape dimension is 1x1 - clearing");
            freeshape (&(yyvsp[-1].sentry));
        }
        yyval.sentry = yyvsp[-1].sentry;
    ;}
    break;

  case 32:
#line 973 "parser.y"
    {
        yyval.sentry = SENTRY_INITIALIZER;
    ;}
    break;

  case 33:
#line 980 "parser.y"
    {
        sentry_t rval = yyvsp[-2].sentry;
        size_t slen = strlen (yyvsp[0].s);
        char **tmp;

        #ifdef PARSER_DEBUG
            fprintf (stderr, "Extending a shape entry\n");
        #endif

        if (slen != rval.width) {
            yyerror ("all elements of a shape spec must be of equal length");
            YYERROR;
        }

        rval.height++;
        tmp = (char **) realloc (rval.chars, rval.height*sizeof(char*));
        if (tmp == NULL) {
            perror (PROJECT": shape_lines11");
            YYABORT;
        }
        rval.chars = tmp;
        rval.chars[rval.height-1] = (char *) strdup (yyvsp[0].s);
        if (rval.chars[rval.height-1] == NULL) {
            perror (PROJECT": shape_lines12");
            YYABORT;
        }
        yyval.sentry = rval;
    ;}
    break;

  case 34:
#line 1010 "parser.y"
    {
        sentry_t rval = SENTRY_INITIALIZER;

        #ifdef PARSER_DEBUG
            fprintf (stderr, "Initializing a shape entry with first line\n");
        #endif

        rval.width = strlen (yyvsp[0].s);
        rval.height = 1;
        rval.chars = (char **) malloc (sizeof(char*));
        if (rval.chars == NULL) {
            perror (PROJECT": shape_lines21");
            YYABORT;
        }
        rval.chars[0] = (char *) strdup (yyvsp[0].s);
        if (rval.chars[0] == NULL) {
            perror (PROJECT": shape_lines22");
            YYABORT;
        }
        yyval.sentry = rval;
    ;}
    break;

  case 37:
#line 1038 "parser.y"
    {
        if (yyvsp[0].num < 0) {
            yyerror ("padding must be a positive integer (%s %d) (ignored)",
                    yyvsp[-1].s, yyvsp[0].num);
        }
        else {
            size_t len1 = strlen (yyvsp[-1].s);
            if (len1 <= 3 && !strncasecmp ("all", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BTOP] = yyvsp[0].num;
                designs[design_idx].padding[BBOT] = yyvsp[0].num;
                designs[design_idx].padding[BLEF] = yyvsp[0].num;
                designs[design_idx].padding[BRIG] = yyvsp[0].num;
            }
            else if (len1 <= 10 && !strncasecmp ("horizontal", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BRIG] = yyvsp[0].num;
                designs[design_idx].padding[BLEF] = yyvsp[0].num;
            }
            else if (len1 <= 8 && !strncasecmp ("vertical", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BTOP] = yyvsp[0].num;
                designs[design_idx].padding[BBOT] = yyvsp[0].num;
            }
            else if (len1 <= 3 && !strncasecmp ("top", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BTOP] = yyvsp[0].num;
            }
            else if (len1 <= 5 && !strncasecmp ("right", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BRIG] = yyvsp[0].num;
            }
            else if (len1 <= 4 && !strncasecmp ("left", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BLEF] = yyvsp[0].num;
            }
            else if (len1 <= 6 && !strncasecmp ("bottom", yyvsp[-1].s, len1)) {
                designs[design_idx].padding[BBOT] = yyvsp[0].num;
            }
            else {
                yyerror ("invalid padding area %s (ignored)", yyvsp[-1].s);
            }
        }
    ;}
    break;


    }

/* Line 991 of yacc.c.  */
#line 2125 "parser.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 1079 "parser.y"


/*EOF*/                                          /* vim: set sw=4 cindent: */

