# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, os.path, time, weakref
import pygame, pygame.image, pygame.color
from pygame.locals import *

from balazar3.base      import *
from balazar3.driver_2d import *
import balazar3.globdef   as globdef
import balazar3.driver_2d as driver_2d


def init(screen_width = 800, screen_height = 480):
  driver_2d.init(screen_width, screen_height)
  
LogEntry.wrap_width = 672
LOG.nb_item         = 6


from balazar3.rooms import Room
Room_ij2xy = Room.ij2xy
Room_xy2ij = Room.xy2ij

def ij2xy(self, i, j):
  x, y = Room_ij2xy(self, i, j)
  return x + 80, y

def xy2ij(self, x, y):
  return Room_xy2ij(self, x - 80, y)

Room.ij2xy = ij2xy
Room.xy2ij = xy2ij


class Level(driver_2d.Level):
  def __init__(self, filename):
    driver_2d.Level.__init__(self, filename)
    self.build_shot()
    
  def __setstate__(self, state):
    driver_2d.Level.__setstate__(self, state)
    self.build_shot()

  def build_shot(self):
    shot = pygame.Surface((800, 480))
    shot.blit(self.shot, (80, 0))
    self.shot = shot
    

