/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.verifier;

import java.util.Stack;
import org.aspectj.apache.bcel.classfile.AnnotationDefault;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.BootstrapMethods;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.CodeException;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFieldref;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.aspectj.apache.bcel.classfile.ConstantInvokeDynamic;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantMethodHandle;
import org.aspectj.apache.bcel.classfile.ConstantMethodType;
import org.aspectj.apache.bcel.classfile.ConstantMethodref;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.Deprecated;
import org.aspectj.apache.bcel.classfile.EnclosingMethod;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.InnerClass;
import org.aspectj.apache.bcel.classfile.InnerClasses;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.LineNumber;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTypeTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.MethodParameters;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.StackMap;
import org.aspectj.apache.bcel.classfile.StackMapEntry;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.Unknown;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisTypeAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisParamAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisTypeAnnos;

public class DescendingVisitor
implements ClassVisitor {
    private JavaClass clazz;
    private ClassVisitor visitor;
    private Stack<Object> stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass clazz, ClassVisitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept((ClassVisitor)this);
    }

    public void visitJavaClass(JavaClass clazz) {
        this.stack.push(clazz);
        clazz.accept(this.visitor);
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            fields[i].accept((ClassVisitor)this);
            ++i;
        }
        Method[] methods = clazz.getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            methods[i2].accept((ClassVisitor)this);
            ++i2;
        }
        AttributeUtils.accept((Attribute[])clazz.getAttributes(), (ClassVisitor)this.visitor);
        clazz.getConstantPool().accept((ClassVisitor)this);
        this.stack.pop();
    }

    public void visitField(Field field) {
        this.stack.push(field);
        field.accept(this.visitor);
        AttributeUtils.accept((Attribute[])field.getAttributes(), (ClassVisitor)this.visitor);
        this.stack.pop();
    }

    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethod(Method method) {
        this.stack.push(method);
        method.accept(this.visitor);
        AttributeUtils.accept((Attribute[])method.getAttributes(), (ClassVisitor)this.visitor);
        this.stack.pop();
    }

    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    public void visitCode(Code code) {
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] table = code.getExceptionTable();
        int i = 0;
        while (i < table.length) {
            table[i].accept((ClassVisitor)this);
            ++i;
        }
        Attribute[] attributes = code.getAttributes();
        int i2 = 0;
        while (i2 < attributes.length) {
            attributes[i2].accept((ClassVisitor)this);
            ++i2;
        }
        this.stack.pop();
    }

    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLineNumberTable(LineNumberTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LineNumber[] numbers = table.getLineNumberTable();
        int i = 0;
        while (i < numbers.length) {
            numbers[i].accept((ClassVisitor)this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTable(LocalVariableTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LocalVariable[] vars = table.getLocalVariableTable();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept((ClassVisitor)this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitStackMap(StackMap table) {
        this.stack.push(table);
        table.accept(this.visitor);
        StackMapEntry[] vars = table.getStackMap();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept((ClassVisitor)this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitStackMapEntry(StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariable(LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        int i = 1;
        while (i < constants.length) {
            if (constants[i] != null) {
                constants[i].accept((ClassVisitor)this);
            }
            ++i;
        }
        this.stack.pop();
    }

    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantMethodHandle(ConstantMethodHandle constant) {
        throw new IllegalStateException("nyi");
    }

    public void visitConstantMethodType(ConstantMethodType obj) {
        throw new IllegalStateException("nyi");
    }

    public void visitConstantInvokeDynamic(ConstantInvokeDynamic obj) {
        throw new IllegalStateException("nyi");
    }

    public void visitBootstrapMethods(BootstrapMethods obj) {
        throw new IllegalStateException("nyi");
    }

    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    public void visitInnerClasses(InnerClasses ic) {
        this.stack.push(ic);
        ic.accept(this.visitor);
        InnerClass[] ics = ic.getInnerClasses();
        int i = 0;
        while (i < ics.length) {
            ics[i].accept((ClassVisitor)this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSignature(Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitEnclosingMethod(EnclosingMethod attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitRuntimeVisibleAnnotations(RuntimeVisAnnos attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitRuntimeInvisibleAnnotations(RuntimeInvisAnnos attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitRuntimeVisibleParameterAnnotations(RuntimeVisParamAnnos attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitRuntimeInvisibleParameterAnnotations(RuntimeInvisParamAnnos attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitRuntimeVisibleTypeAnnotations(RuntimeVisTypeAnnos attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitMethodParameters(MethodParameters attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitRuntimeInvisibleTypeAnnotations(RuntimeInvisTypeAnnos attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitAnnotationDefault(AnnotationDefault attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitLocalVariableTypeTable(LocalVariableTypeTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        LocalVariable[] vars = table.getLocalVariableTypeTable();
        int i = 0;
        while (i < vars.length) {
            vars[i].accept((ClassVisitor)this);
            ++i;
        }
        this.stack.pop();
    }

    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }
}

