/*
 * Decompiled with CFR 0.152.
 */
package jd.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jd.io.ClosedWriter;
import jd.io.FileUtil;

public class TabWriter
extends PrintWriter {
    private char[] buffer_;
    private int bufferUsed_;
    private int bufferFree_;
    private boolean trouble_;
    private boolean autoFlush_;
    private boolean newLineStarted_ = true;
    private int tabCount_ = 0;
    private char[] tabChars_ = new char[]{'\t'};
    private static final char[] defaultLineSeparator_ = TabWriter.getSeparatorChars(FileUtil.getLineSeparator());
    private char[] lineSeparator_ = defaultLineSeparator_;

    public TabWriter(Writer writer) {
        this(writer, false);
    }

    public TabWriter(Writer writer, boolean bl) {
        this(writer, bl, 4096);
    }

    public TabWriter(Writer writer, boolean bl, int n) {
        super(writer, bl);
        if (n < 2) {
            throw new IllegalArgumentException("invalid buffer size");
        }
        this.autoFlush_ = bl;
        this.buffer_ = new char[n];
        this.resetBuffer();
    }

    public void setTabChars(String string) {
        int n = string.length();
        this.tabChars_ = new char[n];
        string.getChars(0, n, this.tabChars_, 0);
    }

    public void setLineSeparator(String string) {
        this.lineSeparator_ = TabWriter.getSeparatorChars(string);
    }

    public void increaseTab() {
        ++this.tabCount_;
    }

    public void decreaseTab() {
        if (this.tabCount_ == 0) {
            throw new IllegalStateException("negative tab");
        }
        --this.tabCount_;
    }

    public int getTabCount() {
        return this.tabCount_;
    }

    protected void writeNewLineTab() {
        for (int i = this.tabCount_; i > 0; --i) {
            this.writeChars(this.tabChars_, 0, this.tabChars_.length);
        }
        this.newLineStarted_ = false;
    }

    public boolean newLineStarted() {
        return this.newLineStarted_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.flush();
            Object object = this.lock;
            synchronized (object) {
                Writer writer = this.out;
                this.out = ClosedWriter.INSTANCE;
                writer.close();
            }
        }
        catch (IOException iOException) {
            this.trouble_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.bufferUsed_ > 0) {
                    this.out.write(this.buffer_, 0, this.bufferUsed_);
                    this.resetBuffer();
                }
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.trouble_ = true;
        }
    }

    public boolean checkError() {
        if (this.out != ClosedWriter.INSTANCE) {
            this.flush();
        }
        return this.trouble_;
    }

    protected void setError() {
        this.trouble_ = true;
    }

    public void write(int n) {
        if (this.newLineStarted_) {
            this.writeNewLineTab();
        }
        if (this.bufferFree_ == 0) {
            this.flush();
        }
        this.buffer_[this.bufferUsed_++] = (char)n;
        --this.bufferFree_;
    }

    public void write(int n, int n2) {
        if (this.newLineStarted_) {
            this.writeNewLineTab();
        }
        if (this.bufferFree_ < 2) {
            this.flush();
        }
        this.buffer_[this.bufferUsed_++] = (char)n;
        this.buffer_[this.bufferUsed_++] = (char)n2;
        this.bufferFree_ -= 2;
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.newLineStarted_) {
            this.writeNewLineTab();
        }
        this.writeChars(cArray, n, n2);
    }

    private void writeChars(char[] cArray, int n, int n2) {
        while (n2 > this.bufferFree_) {
            System.arraycopy(cArray, n, this.buffer_, this.bufferUsed_, this.bufferFree_);
            n += this.bufferFree_;
            n2 -= this.bufferFree_;
            this.bufferUsed_ = this.buffer_.length;
            this.bufferFree_ = 0;
            this.flush();
        }
        System.arraycopy(cArray, n, this.buffer_, this.bufferUsed_, n2);
        this.bufferUsed_ += n2;
        this.bufferFree_ -= n2;
    }

    public void write(String string, int n, int n2) {
        if (this.newLineStarted_) {
            this.writeNewLineTab();
        }
        while (n2 > this.bufferFree_) {
            string.getChars(n, this.bufferFree_, this.buffer_, this.bufferUsed_);
            n += this.bufferFree_;
            n2 -= this.bufferFree_;
            this.bufferUsed_ = this.buffer_.length;
            this.bufferFree_ = 0;
            this.flush();
        }
        string.getChars(n, n + n2, this.buffer_, this.bufferUsed_);
        this.bufferUsed_ += n2;
        this.bufferFree_ -= n2;
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void print(char c) {
        this.write(c);
    }

    public void println() {
        if (this.newLineStarted_) {
            this.newLineStarted_ = false;
        }
        this.write(this.lineSeparator_, 0, this.lineSeparator_.length);
        if (this.autoFlush_) {
            this.flush();
        }
        this.newLineStarted_ = true;
    }

    public void println(boolean bl) {
        this.print(bl);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int n) {
        this.print(n);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] cArray) {
        this.print(cArray);
        this.println();
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }

    public void println(Object object) {
        this.print(object);
        this.println();
    }

    protected void resetBuffer() {
        this.bufferUsed_ = 0;
        this.bufferFree_ = this.buffer_.length;
    }

    protected int getBufferUsed() {
        return this.bufferUsed_;
    }

    private static char[] getSeparatorChars(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        return cArray;
    }
}

