/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ExtendedJLabel
extends JLabel
implements Scrollable {
    private boolean underlined = false;
    private boolean autoTooltip = false;

    public ExtendedJLabel() {
    }

    public ExtendedJLabel(String string) {
        super(string);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.getWidth() / 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(boolean bl) {
        this.underlined = bl;
        this.repaint();
    }

    public boolean getAutoTooltip() {
        return this.autoTooltip;
    }

    public void setAutoTooltip(boolean bl) {
        this.autoTooltip = bl;
        this.setToolTipText(this.getText());
    }

    public void setText(String string) {
        super.setText(string);
        if (this.autoTooltip) {
            this.setToolTipText(string);
        }
    }

    public void setText(short s) {
        this.setText(String.valueOf(s));
    }

    public void setText(int n) {
        this.setText(String.valueOf(n));
    }

    public void setText(double d) {
        this.setText(String.valueOf(d));
    }

    public void setText(float f) {
        this.setText(String.valueOf(f));
    }

    public void setText(long l) {
        this.setText(String.valueOf(l));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.underlined) {
            Insets insets = this.getInsets();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle(insets.left, insets.top, this.getWidth() - (insets.right + insets.left), this.getHeight() - (insets.bottom + insets.top));
            SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle2, new Rectangle(), rectangle, this.getText() == null ? 0 : (Integer)UIManager.get("Button.textIconGap"));
            int n = 2;
            if (UIManager.getLookAndFeel().isNativeLookAndFeel() && System.getProperty("os.name").startsWith("Windows")) {
                n = 1;
            }
            graphics.fillRect(rectangle.x + (Integer)UIManager.get("Button.textShiftOffset"), rectangle.y + fontMetrics.getAscent() + (Integer)UIManager.get("Button.textShiftOffset") + n, rectangle.width, 1);
        }
    }
}

