/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends AbstractArtifactTask {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private File file;

    /*
     * WARNING - void declaration
     */
    protected void doExecute() {
        void var6_6;
        ArtifactRepository deploymentRepository;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder builder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        Pom pom = this.buildPom(builder, localRepo);
        if (pom == null) {
            throw new BuildException("A POM element is required to deploy to the repository");
        }
        Artifact artifact = this.createArtifact(pom);
        DistributionManagement distributionManagement = pom.getDistributionManagement();
        if (this.remoteSnapshotRepository == null && this.remoteRepository == null && distributionManagement != null) {
            if (distributionManagement.getSnapshotRepository() != null) {
                this.remoteSnapshotRepository = this.createAntRemoteRepositoryBase(distributionManagement.getSnapshotRepository());
            }
            if (distributionManagement.getRepository() != null) {
                this.remoteRepository = this.createAntRemoteRepositoryBase(distributionManagement.getRepository());
            }
        }
        if (this.remoteSnapshotRepository == null) {
            this.remoteSnapshotRepository = this.remoteRepository;
        }
        if (artifact.isSnapshot() && this.remoteSnapshotRepository != null) {
            deploymentRepository = this.createRemoteArtifactRepository(this.remoteSnapshotRepository);
        } else if (this.remoteRepository != null) {
            deploymentRepository = this.createRemoteArtifactRepository(this.remoteRepository);
        } else {
            throw new BuildException("A distributionManagement element or remoteRepository element is required to deploy");
        }
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata(metadata);
        }
        this.log("Deploying to " + var6_6.getUrl());
        ArtifactDeployer deployer = (ArtifactDeployer)this.lookup(ArtifactDeployer.ROLE);
        try {
            if (!isPomArtifact) {
                deployer.deploy(this.file, artifact, (ArtifactRepository)var6_6, localRepo);
            } else {
                deployer.deploy(pom.getFile(), artifact, (ArtifactRepository)var6_6, localRepo);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new BuildException("Error deploying artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public void addRemoteSnapshotRepository(RemoteRepository remoteSnapshotRepository) {
        this.remoteSnapshotRepository = remoteSnapshotRepository;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepository = remoteRepository;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

