/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sparql.service.single;

import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;

/**
 * Interface for handling service execution requests on a per-binding level.
 */
@FunctionalInterface
public interface ServiceExecutor {
    /**
     * If this factory cannot handle the execution request then this method should return null.
     * Otherwise, a {@link QueryIterator} is returned.
     *
     * @return A QueryIterator if this factory can handle the request, or null otherwise.
     */
    public QueryIterator createExecution(OpService opExecute, OpService original, Binding binding, ExecutionContext execCxt);
}
