/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.content.pm.verify.domain;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

import java.util.Set;
import java.util.UUID;

/**
 * @hide
 */
@SystemApi
@DataClass(genParcelable = true, genEqualsHashCode = true, genAidl = true, genToString = true)
public final class DomainOwner implements Parcelable {

    /**
     * Package name of that owns the domain.
     */
    @NonNull
    private final String mPackageName;

    /**
     * Whether or not this owner can be automatically overridden.
     *
     * @see DomainVerificationManager#setDomainVerificationUserSelection(UUID, Set, boolean)
     */
    private final boolean mOverrideable;



    // Code below generated by codegen v1.0.22.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/content/pm/verify/domain/DomainOwner.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /**
     * Creates a new DomainOwner.
     *
     * @param packageName
     *   Package name of that owns the domain.
     * @param overrideable
     *   Whether or not this owner can be automatically overridden.
     */
    @DataClass.Generated.Member
    public DomainOwner(
            @NonNull String packageName,
            boolean overrideable) {
        this.mPackageName = packageName;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPackageName);
        this.mOverrideable = overrideable;

        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * Package name of that owns the domain.
     */
    @DataClass.Generated.Member
    public @NonNull String getPackageName() {
        return mPackageName;
    }

    /**
     * Whether or not this owner can be automatically overridden.
     *
     * @see DomainVerificationManager#setDomainVerificationUserSelection(UUID, Set, boolean)
     */
    @DataClass.Generated.Member
    public boolean isOverrideable() {
        return mOverrideable;
    }

    @Override
    @DataClass.Generated.Member
    public String toString() {
        // You can override field toString logic by defining methods like:
        // String fieldNameToString() { ... }

        return "DomainOwner { " +
                "packageName = " + mPackageName + ", " +
                "overrideable = " + mOverrideable +
        " }";
    }

    @Override
    @DataClass.Generated.Member
    public boolean equals(@android.annotation.Nullable Object o) {
        // You can override field equality logic by defining either of the methods like:
        // boolean fieldNameEquals(DomainOwner other) { ... }
        // boolean fieldNameEquals(FieldType otherValue) { ... }

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        @SuppressWarnings("unchecked")
        DomainOwner that = (DomainOwner) o;
        //noinspection PointlessBooleanExpression
        return true
                && java.util.Objects.equals(mPackageName, that.mPackageName)
                && mOverrideable == that.mOverrideable;
    }

    @Override
    @DataClass.Generated.Member
    public int hashCode() {
        // You can override field hashCode logic by defining methods like:
        // int fieldNameHashCode() { ... }

        int _hash = 1;
        _hash = 31 * _hash + java.util.Objects.hashCode(mPackageName);
        _hash = 31 * _hash + Boolean.hashCode(mOverrideable);
        return _hash;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        byte flg = 0;
        if (mOverrideable) flg |= 0x2;
        dest.writeByte(flg);
        dest.writeString(mPackageName);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ DomainOwner(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        byte flg = in.readByte();
        boolean overrideable = (flg & 0x2) != 0;
        String packageName = in.readString();

        this.mPackageName = packageName;
        com.android.internal.util.AnnotationValidations.validate(
                NonNull.class, null, mPackageName);
        this.mOverrideable = overrideable;

        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<DomainOwner> CREATOR
            = new Parcelable.Creator<DomainOwner>() {
        @Override
        public DomainOwner[] newArray(int size) {
            return new DomainOwner[size];
        }

        @Override
        public DomainOwner createFromParcel(@NonNull android.os.Parcel in) {
            return new DomainOwner(in);
        }
    };

    @DataClass.Generated(
            time = 1614721802044L,
            codegenVersion = "1.0.22",
            sourceFile = "frameworks/base/core/java/android/content/pm/verify/domain/DomainOwner.java",
            inputSignatures = "private final @android.annotation.NonNull java.lang.String mPackageName\nprivate final  boolean mOverrideable\nclass DomainOwner extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass(genParcelable=true, genEqualsHashCode=true, genAidl=true, genToString=true)")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
