#
# Makefile for the XML Fortran 90 library embedded in ABINIT
#

include ../../config.mk

all_targets all xmlf90: install
	@echo "$(xmlf90_pkg_name) is now ready for use."

uncompress: uncompress-stamp
	@echo "$(xmlf90_pkg_name) has been uncompressed."

configure: configure-stamp
	@echo "$(xmlf90_pkg_name) has been configured."

build: build-stamp
	@echo "$(xmlf90_pkg_name) has been built."

install: install-stamp
	@echo "$(xmlf90_pkg_name) has been installed in tmp."

uncompress-stamp:
	tar xf $(abinit_srcdir)/lib/xmlf90/$(xmlf90_pkg_name).tar
	touch uncompress-stamp

configure-stamp: uncompress
	-mkdir tmp
	cd $(xmlf90_pkg_name) && \
	 CPP="$(CPP)" \
	 CPPFLAGS="$(CPPFLAGS_XMLF90)" \
	 CC="$(CC)" \
	 CFLAGS="$(CFLAGS_XMLF90)" \
	 CXX="$(CXX)" \
	 CXXFLAGS="$(CXXFLAGS_XMLF90)" \
	 F77="$(FC)" \
	 FFLAGS="$(FCFLAGS_FIXEDFORM) $(FCFLAGS_XMLF90)" \
	 F90="$(FC)" \
	 F90FLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_XMLF90)" \
	 FC="$(FC)" \
	 FCFLAGS="$(FCFLAGS_FREEFORM) $(FCFLAGS_XMLF90)" \
	 ./configure --prefix=$(PWD)/tmp
	touch configure-stamp

build-stamp: configure
	cd $(xmlf90_pkg_name) && $(MAKE)
	touch build-stamp

install-stamp: build
	cd $(xmlf90_pkg_name) && $(MAKE) install
	mv tmp/include/xmlf90/* tmp/include
	rm -rf tmp/include/xmlf90
	touch install-stamp

clean:
	rm -rf $(xmlf90_pkg_name) tmp
	rm -f uncompress-stamp configure-stamp build-stamp install-stamp
