/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientDriver;

public class ClientConnectionPoolDataSource
extends ClientDataSource
implements ConnectionPoolDataSource {
    private static final long serialVersionUID = -539234282156481377L;
    public static final String className__ = "org.apache.derby.jdbc.ClientConnectionPoolDataSource";

    public PooledConnection getPooledConnection() throws SQLException {
        try {
            LogWriter logWriter = super.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry(this, "getPooledConnection");
            }
            PooledConnection pooledConnection = this.getPooledConnectionX(logWriter, this, this.getUser(), this.getPassword());
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        try {
            LogWriter logWriter = super.computeDncLogWriterForNewConnection("_cpds");
            if (logWriter != null) {
                logWriter.traceEntry((Object)this, "getPooledConnection", (Object)string, (Object)"<escaped>");
            }
            PooledConnection pooledConnection = this.getPooledConnectionX(logWriter, this, string, string2);
            if (logWriter != null) {
                logWriter.traceExit((Object)this, "getPooledConnection", pooledConnection);
            }
            return pooledConnection;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private PooledConnection getPooledConnectionX(LogWriter logWriter, ClientBaseDataSource clientBaseDataSource, String string, String string2) throws SQLException {
        return ClientDriver.getFactory().newClientPooledConnection(clientBaseDataSource, logWriter, string, string2);
    }
}

