#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Delores: A Thimbleweed Park Mini-Adventure
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220322.4

# Set game-specific variables

GAME_ID='delores-a-thimbleweed-park-mini-adventure'
GAME_NAME='Delores: A Thimbleweed Park Mini-Adventure'

ARCHIVE_BASE_0='setup_delores_a_thimbleweed_park_mini-adventure_1.1.191_(64bit)_(38487).exe'
ARCHIVE_BASE_0_MD5='30b609714d47171a84c8d41c1a1c038a'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='77000'
ARCHIVE_BASE_0_VERSION='1.1.1.191-gog38487'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/delores_a_thimbleweed_park_miniadventure'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
*.dll
delores.exe'
ARCHIVE_GAME_DATA_FILES='
delores.ggpack1
delores.ico
delores.rc'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='delores.exe'
APP_MAIN_ICON='delores.ico'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# The game expects to be running on top of Windows ≥ 10

APP_WINETRICKS='win10'
PKG_BIN_DEPS="$PKG_BIN_DEPS winetricks"

# A Windows native build of d3dcompiler is required

APP_WINETRICKS="$APP_WINETRICKS d3dcompiler_47"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
