#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Vampyre Story
# send your bug reports to contact@dotslashplay.it
###

script_version=20240820.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='a-vampyre-story'
GAME_NAME='A Vampyre Story'

## This DRM-free installer is no longer sold by gog.com
ARCHIVE_BASE_0_NAME='setup_a_vampyre_story_1.0_(43163).exe'
ARCHIVE_BASE_0_MD5='f2441fb51aac6eaca5e97f6e6a3ea0ab'
## Do not convert file paths to lowercase
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS=' '
ARCHIVE_BASE_0_PART1_NAME='setup_a_vampyre_story_1.0_(43163)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='2c652e191d82c70fbbe5af4d259f3ba2'
ARCHIVE_BASE_0_SIZE='3200000'
ARCHIVE_BASE_0_VERSION='1.0-gog43163'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
main.exe
w9xpopen.exe
__init__.pyc
library.zip
*.dll
*.pyd
*.pyo'
CONTENT_GAME_DATA_FILES='
assets
etc
tcl
installer.bmp
icon.ico'
CONTENT_DOC_DATA_FILES='
license.txt
readme.txt'

USER_PERSISTENT_DIRECTORIES='
assets/scripts
etc'

WINE_VIRTUAL_DESKTOP='auto'
## Disable CSMT rendering, as it messes up with movies playback
## cf. https://bugs.winehq.org/show_bug.cgi?id=37659
## TODO: Check if it is still required with current WINE builds
WINE_WINETRICKS_VERBS='csmt=off'

APP_MAIN_EXE='main.exe'
APP_MAIN_ICON='icon.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
