/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_ComputerSystemCapabilities.h"
#include "OpenDRIM_ComputerSystemCapabilitiesAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderSetInstance Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderModifyInstance
#endif

int Base_Server_OpenDRIM_ComputerSystemCapabilities_init(const CMPIBroker* broker);

int Base_Server_OpenDRIM_ComputerSystemCapabilities_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_ComputerSystemCapabilities> instances;
	string errorMessage;
	
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = Base_Server_OpenDRIM_ComputerSystemCapabilities_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_ComputerSystemCapabilities> instances;
	string errorMessage;
	
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = Base_Server_OpenDRIM_ComputerSystemCapabilities_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_ComputerSystemCapabilities instance;
	Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = Base_Server_OpenDRIM_ComputerSystemCapabilities_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_ComputerSystemCapabilities newInstance, oldInstance;
	Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, ci, newInstance);
	Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_ComputerSystemCapabilities instance;
	Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = Base_Server_OpenDRIM_ComputerSystemCapabilities_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_ComputerSystemCapabilities instance;
	Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus Base_Server_OpenDRIM_ComputerSystemCapabilitiesProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_ComputerSystemCapabilities instance;
	Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"InstanceID"};
	int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="CreateGoalSettings") {
		unsigned short returnValue;
		OpenDRIM_ComputerSystemCapabilities_CreateGoalSettings_In inArgs;
		Base_Server_OpenDRIM_ComputerSystemCapabilities_toCPP(_broker, in, inArgs);
		OpenDRIM_ComputerSystemCapabilities_CreateGoalSettings_Out outArgs;
		
		errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_CreateGoalSettings(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		Base_Server_OpenDRIM_ComputerSystemCapabilities_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint16, CMPI_uint16);
	}
	else {
		errorMessage = (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int Base_Server_OpenDRIM_ComputerSystemCapabilities_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "Base_Server_OpenDRIM_ComputerSystemCapabilities_init FAILED: " + (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystemCapabilities_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = Base_Server_OpenDRIM_ComputerSystemCapabilities_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "Base_Server_OpenDRIM_ComputerSystemCapabilities_unload FAILED: " + (string) OpenDRIM_ComputerSystemCapabilities_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define Base_Server_OpenDRIM_ComputerSystemCapabilities_INIT if (Base_Server_OpenDRIM_ComputerSystemCapabilities_init(_broker) < 0) return NULL

CMInstanceMIStub(Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider, Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider, _broker, Base_Server_OpenDRIM_ComputerSystemCapabilities_INIT);
CMMethodMIStub(Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider, Base_Server_OpenDRIM_ComputerSystemCapabilitiesProvider, _broker, Base_Server_OpenDRIM_ComputerSystemCapabilities_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
