#pragma once

#ifndef __MINX_H__
#define __MINX_H__


enum
{
		MINX_PC=1, MINX_SP, MINX_BA, MINX_HL, MINX_X, MINX_Y,
		MINX_U, MINX_V, MINX_F, MINX_E, MINX_N, MINX_I,
		MINX_XI, MINX_YI,
};


class minx_cpu_device :  public cpu_device
{
public:
	// construction/destruction
	minx_cpu_device(const machine_config &mconfig, const char *tag, device_t *owner, UINT32 clock);

protected:
	// device-level overrides
	virtual void device_start();
	virtual void device_reset();

	// device_execute_interface overrides
	virtual UINT32 execute_min_cycles() const { return 1; }
	virtual UINT32 execute_max_cycles() const { return 4; }
	virtual UINT32 execute_input_lines() const { return 1; }
	virtual void execute_run();
	virtual void execute_set_input(int inputnum, int state);

	// device_memory_interface overrides
	virtual const address_space_config *memory_space_config(address_spacenum spacenum = AS_0) const { return (spacenum == AS_PROGRAM) ? &m_program_config : NULL; }

	// device_state_interface overrides
	void state_string_export(const device_state_entry &entry, astring &string);

	// device_disasm_interface overrides
	virtual UINT32 disasm_min_opcode_bytes() const { return 1; }
	virtual UINT32 disasm_max_opcode_bytes() const { return 5; }
	virtual offs_t disasm_disassemble(char *buffer, offs_t pc, const UINT8 *oprom, const UINT8 *opram, UINT32 options);

private:
	address_space_config m_program_config;

	UINT16  m_PC;
	UINT16  m_SP;
	UINT16  m_BA;
	UINT16  m_HL;
	UINT16  m_X;
	UINT16  m_Y;
	UINT8   m_U;
	UINT8   m_V;
	UINT8   m_F;
	UINT8   m_E;
	UINT8   m_N;
	UINT8   m_I;
	UINT8   m_XI;
	UINT8   m_YI;
	UINT8   m_halted;
	UINT8   m_interrupt_pending;
	address_space *m_program;
	int m_icount;
	// For debugger
	UINT32 m_curpc;
	UINT16 m_flags;

	UINT16 rd16( UINT32 offset );
	void wr16( UINT32 offset, UINT16 data );
	UINT8 rdop();
	UINT16 rdop16();
	UINT8 ADD8( UINT8 arg1, UINT8 arg2 );
	UINT16 ADD16( UINT16 arg1, UINT16 arg2 );
	UINT8 ADDC8( UINT8 arg1, UINT8 arg2 );
	UINT16 ADDC16( UINT16 arg1, UINT16 arg2 );
	UINT8 INC8( UINT8 arg );
	UINT16 INC16( UINT16 arg );
	UINT8 SUB8( UINT8 arg1, UINT8 arg2 );
	UINT16 SUB16( UINT16 arg1, UINT16 arg2 );
	UINT8 SUBC8( UINT8 arg1, UINT8 arg2 );
	UINT16 SUBC16( UINT16 arg1, UINT16 arg2 );
	UINT8 DEC8( UINT8 arg );
	UINT16 DEC16( UINT16 arg );
	UINT8 AND8( UINT8 arg1, UINT8 arg2 );
	UINT8 OR8( UINT8 arg1, UINT8 arg2 );
	UINT8 XOR8( UINT8 arg1, UINT8 arg2 );
	UINT8 NOT8( UINT8 arg );
	UINT8 NEG8( UINT8 arg );
	UINT8 SAL8( UINT8 arg );
	UINT8 SAR8( UINT8 arg );
	UINT8 SHL8( UINT8 arg );
	UINT8 SHR8( UINT8 arg );
	UINT8 ROLC8( UINT8 arg );
	UINT8 RORC8( UINT8 arg );
	UINT8 ROL8( UINT8 arg );
	UINT8 ROR8( UINT8 arg );
	void PUSH8( UINT8 arg );
	void PUSH16( UINT16 arg );
	UINT8 POP8();
	UINT16 POP16();
	void JMP( UINT16 arg );
	void CALL( UINT16 arg );

	void minx_00();
	void minx_01();
	void minx_02();
	void minx_03();
	void minx_04();
	void minx_05();
	void minx_06();
	void minx_07();
	void minx_08();
	void minx_09();
	void minx_0A();
	void minx_0B();
	void minx_0C();
	void minx_0D();
	void minx_0E();
	void minx_0F();
	void minx_10();
	void minx_11();
	void minx_12();
	void minx_13();
	void minx_14();
	void minx_15();
	void minx_16();
	void minx_17();
	void minx_18();
	void minx_19();
	void minx_1A();
	void minx_1B();
	void minx_1C();
	void minx_1D();
	void minx_1E();
	void minx_1F();
	void minx_20();
	void minx_21();
	void minx_22();
	void minx_23();
	void minx_24();
	void minx_25();
	void minx_26();
	void minx_27();
	void minx_28();
	void minx_29();
	void minx_2A();
	void minx_2B();
	void minx_2C();
	void minx_2D();
	void minx_2E();
	void minx_2F();
	void minx_30();
	void minx_31();
	void minx_32();
	void minx_33();
	void minx_34();
	void minx_35();
	void minx_36();
	void minx_37();
	void minx_38();
	void minx_39();
	void minx_3A();
	void minx_3B();
	void minx_3C();
	void minx_3D();
	void minx_3E();
	void minx_3F();
	void minx_40();
	void minx_41();
	void minx_42();
	void minx_43();
	void minx_44();
	void minx_45();
	void minx_46();
	void minx_47();
	void minx_48();
	void minx_49();
	void minx_4A();
	void minx_4B();
	void minx_4C();
	void minx_4D();
	void minx_4E();
	void minx_4F();
	void minx_50();
	void minx_51();
	void minx_52();
	void minx_53();
	void minx_54();
	void minx_55();
	void minx_56();
	void minx_57();
	void minx_58();
	void minx_59();
	void minx_5A();
	void minx_5B();
	void minx_5C();
	void minx_5D();
	void minx_5E();
	void minx_5F();
	void minx_60();
	void minx_61();
	void minx_62();
	void minx_63();
	void minx_64();
	void minx_65();
	void minx_66();
	void minx_67();
	void minx_68();
	void minx_69();
	void minx_6A();
	void minx_6B();
	void minx_6C();
	void minx_6D();
	void minx_6E();
	void minx_6F();
	void minx_70();
	void minx_71();
	void minx_72();
	void minx_73();
	void minx_74();
	void minx_75();
	void minx_76();
	void minx_77();
	void minx_78();
	void minx_79();
	void minx_7A();
	void minx_7B();
	void minx_7C();
	void minx_7D();
	void minx_7E();
	void minx_7F();
	void minx_80();
	void minx_81();
	void minx_82();
	void minx_83();
	void minx_84();
	void minx_85();
	void minx_86();
	void minx_87();
	void minx_88();
	void minx_89();
	void minx_8A();
	void minx_8B();
	void minx_8C();
	void minx_8D();
	void minx_8E();
	void minx_8F();
	void minx_90();
	void minx_91();
	void minx_92();
	void minx_93();
	void minx_94();
	void minx_95();
	void minx_96();
	void minx_97();
	void minx_98();
	void minx_99();
	void minx_9A();
	void minx_9B();
	void minx_9C();
	void minx_9D();
	void minx_9E();
	void minx_9F();
	void minx_A0();
	void minx_A1();
	void minx_A2();
	void minx_A3();
	void minx_A4();
	void minx_A5();
	void minx_A6();
	void minx_A7();
	void minx_A8();
	void minx_A9();
	void minx_AA();
	void minx_AB();
	void minx_AC();
	void minx_AD();
	void minx_AE();
	void minx_AF();
	void minx_B0();
	void minx_B1();
	void minx_B2();
	void minx_B3();
	void minx_B4();
	void minx_B5();
	void minx_B6();
	void minx_B7();
	void minx_B8();
	void minx_B9();
	void minx_BA();
	void minx_BB();
	void minx_BC();
	void minx_BD();
	void minx_BE();
	void minx_BF();
	void minx_C0();
	void minx_C1();
	void minx_C2();
	void minx_C3();
	void minx_C4();
	void minx_C5();
	void minx_C6();
	void minx_C7();
	void minx_C8();
	void minx_C9();
	void minx_CA();
	void minx_CB();
	void minx_CC();
	void minx_CD();
	void minx_CE();
	void minx_CF();
	void minx_D0();
	void minx_D1();
	void minx_D2();
	void minx_D3();
	void minx_D4();
	void minx_D5();
	void minx_D6();
	void minx_D7();
	void minx_D8();
	void minx_D9();
	void minx_DA();
	void minx_DB();
	void minx_DC();
	void minx_DD();
	void minx_DE();
	void minx_DF();
	void minx_E0();
	void minx_E1();
	void minx_E2();
	void minx_E3();
	void minx_E4();
	void minx_E5();
	void minx_E6();
	void minx_E7();
	void minx_E8();
	void minx_E9();
	void minx_EA();
	void minx_EB();
	void minx_EC();
	void minx_ED();
	void minx_EE();
	void minx_EF();
	void minx_F0();
	void minx_F1();
	void minx_F2();
	void minx_F3();
	void minx_F4();
	void minx_F5();
	void minx_F6();
	void minx_F7();
	void minx_F8();
	void minx_F9();
	void minx_FA();
	void minx_FB();
	void minx_FC();
	void minx_FD();
	void minx_FE();
	void minx_FF();

	void minx_CE_00();
	void minx_CE_01();
	void minx_CE_02();
	void minx_CE_03();
	void minx_CE_04();
	void minx_CE_05();
	void minx_CE_06();
	void minx_CE_07();
	void minx_CE_08();
	void minx_CE_09();
	void minx_CE_0A();
	void minx_CE_0B();
	void minx_CE_0C();
	void minx_CE_0D();
	void minx_CE_0E();
	void minx_CE_0F();
	void minx_CE_10();
	void minx_CE_11();
	void minx_CE_12();
	void minx_CE_13();
	void minx_CE_14();
	void minx_CE_15();
	void minx_CE_16();
	void minx_CE_17();
	void minx_CE_18();
	void minx_CE_19();
	void minx_CE_1A();
	void minx_CE_1B();
	void minx_CE_1C();
	void minx_CE_1D();
	void minx_CE_1E();
	void minx_CE_1F();
	void minx_CE_20();
	void minx_CE_21();
	void minx_CE_22();
	void minx_CE_23();
	void minx_CE_24();
	void minx_CE_25();
	void minx_CE_26();
	void minx_CE_27();
	void minx_CE_28();
	void minx_CE_29();
	void minx_CE_2A();
	void minx_CE_2B();
	void minx_CE_2C();
	void minx_CE_2D();
	void minx_CE_2E();
	void minx_CE_2F();
	void minx_CE_30();
	void minx_CE_31();
	void minx_CE_32();
	void minx_CE_33();
	void minx_CE_34();
	void minx_CE_35();
	void minx_CE_36();
	void minx_CE_37();
	void minx_CE_38();
	void minx_CE_39();
	void minx_CE_3A();
	void minx_CE_3B();
	void minx_CE_3C();
	void minx_CE_3D();
	void minx_CE_3E();
	void minx_CE_3F();
	void minx_CE_40();
	void minx_CE_41();
	void minx_CE_42();
	void minx_CE_43();
	void minx_CE_44();
	void minx_CE_45();
	void minx_CE_46();
	void minx_CE_47();
	void minx_CE_48();
	void minx_CE_49();
	void minx_CE_4A();
	void minx_CE_4B();
	void minx_CE_4C();
	void minx_CE_4D();
	void minx_CE_4E();
	void minx_CE_4F();
	void minx_CE_50();
	void minx_CE_51();
	void minx_CE_52();
	void minx_CE_53();
	void minx_CE_54();
	void minx_CE_55();
	void minx_CE_56();
	void minx_CE_57();
	void minx_CE_58();
	void minx_CE_59();
	void minx_CE_5A();
	void minx_CE_5B();
	void minx_CE_5C();
	void minx_CE_5D();
	void minx_CE_5E();
	void minx_CE_5F();
	void minx_CE_60();
	void minx_CE_61();
	void minx_CE_62();
	void minx_CE_63();
	void minx_CE_64();
	void minx_CE_65();
	void minx_CE_66();
	void minx_CE_67();
	void minx_CE_68();
	void minx_CE_69();
	void minx_CE_6A();
	void minx_CE_6B();
	void minx_CE_6C();
	void minx_CE_6D();
	void minx_CE_6E();
	void minx_CE_6F();
	void minx_CE_70();
	void minx_CE_71();
	void minx_CE_72();
	void minx_CE_73();
	void minx_CE_74();
	void minx_CE_75();
	void minx_CE_76();
	void minx_CE_77();
	void minx_CE_78();
	void minx_CE_79();
	void minx_CE_7A();
	void minx_CE_7B();
	void minx_CE_7C();
	void minx_CE_7D();
	void minx_CE_7E();
	void minx_CE_7F();
	void minx_CE_80();
	void minx_CE_81();
	void minx_CE_82();
	void minx_CE_83();
	void minx_CE_84();
	void minx_CE_85();
	void minx_CE_86();
	void minx_CE_87();
	void minx_CE_88();
	void minx_CE_89();
	void minx_CE_8A();
	void minx_CE_8B();
	void minx_CE_8C();
	void minx_CE_8D();
	void minx_CE_8E();
	void minx_CE_8F();
	void minx_CE_90();
	void minx_CE_91();
	void minx_CE_92();
	void minx_CE_93();
	void minx_CE_94();
	void minx_CE_95();
	void minx_CE_96();
	void minx_CE_97();
	void minx_CE_98();
	void minx_CE_99();
	void minx_CE_9A();
	void minx_CE_9B();
	void minx_CE_9C();
	void minx_CE_9D();
	void minx_CE_9E();
	void minx_CE_9F();
	void minx_CE_A0();
	void minx_CE_A1();
	void minx_CE_A2();
	void minx_CE_A3();
	void minx_CE_A4();
	void minx_CE_A5();
	void minx_CE_A6();
	void minx_CE_A7();
	void minx_CE_A8();
	void minx_CE_A9();
	void minx_CE_AA();
	void minx_CE_AB();
	void minx_CE_AC();
	void minx_CE_AD();
	void minx_CE_AE();
	void minx_CE_AF();
	void minx_CE_B0();
	void minx_CE_B1();
	void minx_CE_B2();
	void minx_CE_B3();
	void minx_CE_B4();
	void minx_CE_B5();
	void minx_CE_B6();
	void minx_CE_B7();
	void minx_CE_B8();
	void minx_CE_B9();
	void minx_CE_BA();
	void minx_CE_BB();
	void minx_CE_BC();
	void minx_CE_BD();
	void minx_CE_BE();
	void minx_CE_BF();
	void minx_CE_C0();
	void minx_CE_C1();
	void minx_CE_C2();
	void minx_CE_C3();
	void minx_CE_C4();
	void minx_CE_C5();
	void minx_CE_C6();
	void minx_CE_C7();
	void minx_CE_C8();
	void minx_CE_C9();
	void minx_CE_CA();
	void minx_CE_CB();
	void minx_CE_CC();
	void minx_CE_CD();
	void minx_CE_CE();
	void minx_CE_CF();
	void minx_CE_D0();
	void minx_CE_D1();
	void minx_CE_D2();
	void minx_CE_D3();
	void minx_CE_D4();
	void minx_CE_D5();
	void minx_CE_D6();
	void minx_CE_D7();
	void minx_CE_D8();
	void minx_CE_D9();
	void minx_CE_DA();
	void minx_CE_DB();
	void minx_CE_DC();
	void minx_CE_DD();
	void minx_CE_DE();
	void minx_CE_DF();
	void minx_CE_E0();
	void minx_CE_E1();
	void minx_CE_E2();
	void minx_CE_E3();
	void minx_CE_E4();
	void minx_CE_E5();
	void minx_CE_E6();
	void minx_CE_E7();
	void minx_CE_E8();
	void minx_CE_E9();
	void minx_CE_EA();
	void minx_CE_EB();
	void minx_CE_EC();
	void minx_CE_ED();
	void minx_CE_EE();
	void minx_CE_EF();
	void minx_CE_F0();
	void minx_CE_F1();
	void minx_CE_F2();
	void minx_CE_F3();
	void minx_CE_F4();
	void minx_CE_F5();
	void minx_CE_F6();
	void minx_CE_F7();
	void minx_CE_F8();
	void minx_CE_F9();
	void minx_CE_FA();
	void minx_CE_FB();
	void minx_CE_FC();
	void minx_CE_FD();
	void minx_CE_FE();
	void minx_CE_FF();

	void minx_CF_00();
	void minx_CF_01();
	void minx_CF_02();
	void minx_CF_03();
	void minx_CF_04();
	void minx_CF_05();
	void minx_CF_06();
	void minx_CF_07();
	void minx_CF_08();
	void minx_CF_09();
	void minx_CF_0A();
	void minx_CF_0B();
	void minx_CF_0C();
	void minx_CF_0D();
	void minx_CF_0E();
	void minx_CF_0F();
	void minx_CF_10();
	void minx_CF_11();
	void minx_CF_12();
	void minx_CF_13();
	void minx_CF_14();
	void minx_CF_15();
	void minx_CF_16();
	void minx_CF_17();
	void minx_CF_18();
	void minx_CF_19();
	void minx_CF_1A();
	void minx_CF_1B();
	void minx_CF_1C();
	void minx_CF_1D();
	void minx_CF_1E();
	void minx_CF_1F();
	void minx_CF_20();
	void minx_CF_21();
	void minx_CF_22();
	void minx_CF_23();
	void minx_CF_24();
	void minx_CF_25();
	void minx_CF_26();
	void minx_CF_27();
	void minx_CF_28();
	void minx_CF_29();
	void minx_CF_2A();
	void minx_CF_2B();
	void minx_CF_2C();
	void minx_CF_2D();
	void minx_CF_2E();
	void minx_CF_2F();
	void minx_CF_30();
	void minx_CF_31();
	void minx_CF_32();
	void minx_CF_33();
	void minx_CF_34();
	void minx_CF_35();
	void minx_CF_36();
	void minx_CF_37();
	void minx_CF_38();
	void minx_CF_39();
	void minx_CF_3A();
	void minx_CF_3B();
	void minx_CF_3C();
	void minx_CF_3D();
	void minx_CF_3E();
	void minx_CF_3F();
	void minx_CF_40();
	void minx_CF_41();
	void minx_CF_42();
	void minx_CF_43();
	void minx_CF_44();
	void minx_CF_45();
	void minx_CF_46();
	void minx_CF_47();
	void minx_CF_48();
	void minx_CF_49();
	void minx_CF_4A();
	void minx_CF_4B();
	void minx_CF_4C();
	void minx_CF_4D();
	void minx_CF_4E();
	void minx_CF_4F();
	void minx_CF_50();
	void minx_CF_51();
	void minx_CF_52();
	void minx_CF_53();
	void minx_CF_54();
	void minx_CF_55();
	void minx_CF_56();
	void minx_CF_57();
	void minx_CF_58();
	void minx_CF_59();
	void minx_CF_5A();
	void minx_CF_5B();
	void minx_CF_5C();
	void minx_CF_5D();
	void minx_CF_5E();
	void minx_CF_5F();
	void minx_CF_60();
	void minx_CF_61();
	void minx_CF_62();
	void minx_CF_63();
	void minx_CF_64();
	void minx_CF_65();
	void minx_CF_66();
	void minx_CF_67();
	void minx_CF_68();
	void minx_CF_69();
	void minx_CF_6A();
	void minx_CF_6B();
	void minx_CF_6C();
	void minx_CF_6D();
	void minx_CF_6E();
	void minx_CF_6F();
	void minx_CF_70();
	void minx_CF_71();
	void minx_CF_72();
	void minx_CF_73();
	void minx_CF_74();
	void minx_CF_75();
	void minx_CF_76();
	void minx_CF_77();
	void minx_CF_78();
	void minx_CF_79();
	void minx_CF_7A();
	void minx_CF_7B();
	void minx_CF_7C();
	void minx_CF_7D();
	void minx_CF_7E();
	void minx_CF_7F();
	void minx_CF_80();
	void minx_CF_81();
	void minx_CF_82();
	void minx_CF_83();
	void minx_CF_84();
	void minx_CF_85();
	void minx_CF_86();
	void minx_CF_87();
	void minx_CF_88();
	void minx_CF_89();
	void minx_CF_8A();
	void minx_CF_8B();
	void minx_CF_8C();
	void minx_CF_8D();
	void minx_CF_8E();
	void minx_CF_8F();
	void minx_CF_90();
	void minx_CF_91();
	void minx_CF_92();
	void minx_CF_93();
	void minx_CF_94();
	void minx_CF_95();
	void minx_CF_96();
	void minx_CF_97();
	void minx_CF_98();
	void minx_CF_99();
	void minx_CF_9A();
	void minx_CF_9B();
	void minx_CF_9C();
	void minx_CF_9D();
	void minx_CF_9E();
	void minx_CF_9F();
	void minx_CF_A0();
	void minx_CF_A1();
	void minx_CF_A2();
	void minx_CF_A3();
	void minx_CF_A4();
	void minx_CF_A5();
	void minx_CF_A6();
	void minx_CF_A7();
	void minx_CF_A8();
	void minx_CF_A9();
	void minx_CF_AA();
	void minx_CF_AB();
	void minx_CF_AC();
	void minx_CF_AD();
	void minx_CF_AE();
	void minx_CF_AF();
	void minx_CF_B0();
	void minx_CF_B1();
	void minx_CF_B2();
	void minx_CF_B3();
	void minx_CF_B4();
	void minx_CF_B5();
	void minx_CF_B6();
	void minx_CF_B7();
	void minx_CF_B8();
	void minx_CF_B9();
	void minx_CF_BA();
	void minx_CF_BB();
	void minx_CF_BC();
	void minx_CF_BD();
	void minx_CF_BE();
	void minx_CF_BF();
	void minx_CF_C0();
	void minx_CF_C1();
	void minx_CF_C2();
	void minx_CF_C3();
	void minx_CF_C4();
	void minx_CF_C5();
	void minx_CF_C6();
	void minx_CF_C7();
	void minx_CF_C8();
	void minx_CF_C9();
	void minx_CF_CA();
	void minx_CF_CB();
	void minx_CF_CC();
	void minx_CF_CD();
	void minx_CF_CE();
	void minx_CF_CF();
	void minx_CF_D0();
	void minx_CF_D1();
	void minx_CF_D2();
	void minx_CF_D3();
	void minx_CF_D4();
	void minx_CF_D5();
	void minx_CF_D6();
	void minx_CF_D7();
	void minx_CF_D8();
	void minx_CF_D9();
	void minx_CF_DA();
	void minx_CF_DB();
	void minx_CF_DC();
	void minx_CF_DD();
	void minx_CF_DE();
	void minx_CF_DF();
	void minx_CF_E0();
	void minx_CF_E1();
	void minx_CF_E2();
	void minx_CF_E3();
	void minx_CF_E4();
	void minx_CF_E5();
	void minx_CF_E6();
	void minx_CF_E7();
	void minx_CF_E8();
	void minx_CF_E9();
	void minx_CF_EA();
	void minx_CF_EB();
	void minx_CF_EC();
	void minx_CF_ED();
	void minx_CF_EE();
	void minx_CF_EF();
	void minx_CF_F0();
	void minx_CF_F1();
	void minx_CF_F2();
	void minx_CF_F3();
	void minx_CF_F4();
	void minx_CF_F5();
	void minx_CF_F6();
	void minx_CF_F7();
	void minx_CF_F8();
	void minx_CF_F9();
	void minx_CF_FA();
	void minx_CF_FB();
	void minx_CF_FC();
	void minx_CF_FD();
	void minx_CF_FE();
	void minx_CF_FF();

	typedef void (minx_cpu_device::*op_func)();
	static const op_func insnminx[256];
	static const int insnminx_cycles[256];

	static const op_func insnminx_CE[256];
	static const int insnminx_cycles_CE[256];

	static const op_func insnminx_CF[256];
	static const int insnminx_cycles_CF[256];

};


extern const device_type MINX;


#endif /* __MINX_H__ */
