/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfileClassIT;

public final class TiffProfileClassITMP
extends TiffProfileClassIT {
    public TiffProfileClassITMP() {
        this._profileText = "TIFF/IT-MP (ISO 12639:1998)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        int n;
        if (!super.satisfiesThisProfile(iFD)) {
            return false;
        }
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getBitsPerSample() == null) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 32895})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        if (nisoImageMetadata.getCompressionScheme() == 32895 && (n = tiffIFD.getRasterPadding()) != 0 && n != 1 && n != 2 && n != 9 && n != 10) {
            return false;
        }
        if (!this.satisfiesImageColorIndicator(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        n = tiffIFD.getImageColorIndicator();
        return n != 1 || tiffIFD.getImageColorValue() != -1;
    }
}

