/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;

public class FileSpecification {
    String _specString;
    PdfObject _sourceObject;

    public FileSpecification(PdfObject pdfObject) throws PdfException {
        try {
            this._sourceObject = pdfObject;
            if (pdfObject instanceof PdfDictionary) {
                PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("F");
                if (pdfSimpleObject == null) {
                    pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Unix");
                }
                if (pdfSimpleObject == null) {
                    pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("DOS");
                }
                if (pdfSimpleObject == null) {
                    pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Mac");
                }
                if (pdfSimpleObject != null) {
                    this._specString = pdfSimpleObject.getStringValue();
                }
            } else if (pdfObject instanceof PdfSimpleObject) {
                this._specString = ((PdfSimpleObject)pdfObject).getStringValue();
            }
        }
        catch (ClassCastException classCastException) {
            throw new PdfInvalidException("Invalid file specification");
        }
    }

    public String getSpecString() {
        return this._specString;
    }

    public PdfObject getSourceObject() {
        return this._sourceObject;
    }
}

