/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.BitSet;
import java.util.List;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.PeekableIterator;
import net.sf.picard.util.ReferenceSequenceMask;
import net.sf.samtools.SAMFileHeader;

public class IntervalListReferenceSequenceMask
implements ReferenceSequenceMask {
    private final SAMFileHeader header;
    private final BitSet currentBitSet = new BitSet();
    private int currentSequenceIndex = -1;
    private final PeekableIterator<Interval> intervalIterator;
    private final int lastSequenceIndex;
    private final int lastPosition;

    public IntervalListReferenceSequenceMask(IntervalList intervalList) {
        List<Interval> uniqueIntervals;
        this.header = intervalList.getHeader();
        if (intervalList.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            intervalList.sort();
        }
        if ((uniqueIntervals = intervalList.getUniqueIntervals()).isEmpty()) {
            this.lastSequenceIndex = -1;
            this.lastPosition = 0;
        } else {
            Interval lastInterval = uniqueIntervals.get(uniqueIntervals.size() - 1);
            this.lastSequenceIndex = this.header.getSequenceIndex(lastInterval.getSequence());
            this.lastPosition = lastInterval.getEnd();
        }
        this.intervalIterator = new PeekableIterator<Interval>(uniqueIntervals.iterator());
    }

    @Override
    public boolean get(int sequenceIndex, int position) {
        this.ensureSequenceLoaded(sequenceIndex);
        return this.currentBitSet.get(position);
    }

    @Override
    public int nextPosition(int sequenceIndex, int position) {
        this.ensureSequenceLoaded(sequenceIndex);
        return this.currentBitSet.nextSetBit(position + 1);
    }

    private void ensureSequenceLoaded(int sequenceIndex) {
        if (sequenceIndex < this.currentSequenceIndex) {
            throw new IllegalArgumentException("Cannot look at an earlier sequence.  Current: " + this.currentSequenceIndex + "; requested: " + sequenceIndex);
        }
        if (sequenceIndex > this.currentSequenceIndex) {
            this.currentBitSet.clear();
            while (this.intervalIterator.hasNext()) {
                Interval interval = this.intervalIterator.peek();
                int nextSequenceIndex = this.header.getSequenceIndex(interval.getSequence());
                if (nextSequenceIndex < sequenceIndex) {
                    this.intervalIterator.next();
                    continue;
                }
                if (nextSequenceIndex != sequenceIndex) break;
                this.currentBitSet.set(interval.getStart(), interval.getEnd() + 1);
                this.intervalIterator.next();
            }
            this.currentSequenceIndex = sequenceIndex;
        }
    }

    @Override
    public int getMaxSequenceIndex() {
        return this.lastSequenceIndex;
    }

    @Override
    public int getMaxPosition() {
        return this.lastPosition;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }
}

