/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.security;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.security.MockSecurityManager;

public class SecurityForbiddenTestCase
extends TestCase {
    private SecurityManager oldSecMgr;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable;
    static /* synthetic */ Class class$java$lang$Class;

    public static Test suite() throws Exception {
        PathableClassLoader parent = new PathableClassLoader(null);
        parent.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = SecurityForbiddenTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        parent.addLogicalLib("commons-logging");
        parent.addLogicalLib("testclasses");
        Class<?> testClass = parent.loadClass("org.apache.commons.logging.security.SecurityForbiddenTestCase");
        return new PathableTestSuite(testClass, parent);
    }

    public void setUp() {
        this.oldSecMgr = System.getSecurityManager();
    }

    public void tearDown() {
        System.setSecurityManager(this.oldSecMgr);
    }

    public void testAllForbidden() {
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", (class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable == null ? (class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable = SecurityForbiddenTestCase.class$("org.apache.commons.logging.security.SecurityForbiddenTestCase$CustomHashtable")) : class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable).getName());
        MockSecurityManager mySecurityManager = new MockSecurityManager();
        System.setSecurityManager(mySecurityManager);
        try {
            Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
            Method m = c.getMethod("getLog", class$java$lang$Class == null ? (class$java$lang$Class = SecurityForbiddenTestCase.class$("java.lang.Class")) : class$java$lang$Class);
            Log log = (Log)m.invoke(null, ((Object)((Object)this)).getClass());
            log.info((Object)"testing");
            System.setSecurityManager(this.oldSecMgr);
            Field factoryField = c.getDeclaredField("factories");
            ((AccessibleObject)factoryField).setAccessible(true);
            Object factoryTable = factoryField.get(null);
            Assert.assertNotNull((Object)factoryTable);
            String ftClassName = factoryTable.getClass().getName();
            Assert.assertTrue((String)"Custom hashtable unexpectedly used", (!(class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable == null ? (class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable = SecurityForbiddenTestCase.class$("org.apache.commons.logging.security.SecurityForbiddenTestCase$CustomHashtable")) : class$org$apache$commons$logging$security$SecurityForbiddenTestCase$CustomHashtable).getName().equals(ftClassName) ? 1 : 0) != 0);
            Assert.assertEquals((int)0, (int)mySecurityManager.getUntrustedCodeCount());
        }
        catch (Throwable t) {
            System.setSecurityManager(this.oldSecMgr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            Assert.fail((String)("Unexpected exception:" + t.getMessage() + ":" + sw.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CustomHashtable
    extends Hashtable {
    }
}

