#ifndef _PARSER_H
#define _PARSER_H

#define strLenMax 200	/* ̍ő̒ */
#define ESP_CODE 4
#define EBP_CODE 5

/* R[h̏ */
typedef struct{
	char name[12];
	int ope1,ope2;
	byte code,mod;
}CODE_MAP;

/* IyR[h̎ */
typedef enum{
	NO_MATCH,MMX_CODE,_3DNOW_CODE,PREFETCH_CODE
}OPECODE_GROUP;

typedef struct{
	OPECODE_GROUP group;
	int num;		/* ߂̓ԍ */
}OPECODE;

/* AhbVO */
typedef struct{
	char seg;				/* ZOg (Ȃ-1) */
	char base;				/* x[X (l) */
	char index;				/* CfbNX (l) */
	char scale;				/* *1,*2,*4,*8 ꂼɑ΂ 0, 1, 2, 3 */
	char disp[40];			/* '['']'܂܂Ȃ萔\ */
}ADDRESSING;

/* Iyh̎ */

enum{
	 tNONE=1
	,tMMX =2
	,tR32 =4
	,tMEM =8
	,tIMM8 =16
};

typedef struct{
	int type;			/* or ĝenumgȂ */
	union{
		int reg;		/* WX^R[h */
		int32 imm;		/* l */
		ADDRESSING adr;	/*  */
	}ope;
}OPERAND;

/* "label:opecode operand1,operan2" ܂Ƃ߂\ */
typedef struct{
	char label[40];		/* x */
	OPECODE icode;		/* mnemonic̓ԍ(-1͊Y) */
	OPERAND ope1,ope2;
}CODE;

/* ͗p */

typedef enum{
	TOKEN_NONE,		/*  */
	TOKEN_COLON,	/* ':' */
	TOKEN_COMMA,	/* ',' */
	TOKEN_ADD,		/* '+' */
	TOKEN_SUB,		/* '-' */
	TOKEN_MUL,		/* '*' */
	TOKEN_OPEN,		/* '[' */
	TOKEN_CLOSE,	/* ']' */
	TOKEN_EQU,		/* '=' */
	TOKEN_STR		/* ' ','\t' Ə̕܂܂Ȃ */
}TOKEN_TYPE;

typedef struct{
	TOKEN_TYPE type;
	char str[strLenMax];
	char *begin;	/* o񂪂ʒu */
}TOKEN;

/*
 *	TOKEN_TYPEɑΉ鎟̕Ă
 *	tok->begin=o񂪂|C^
 *	o̍Ō̕|C^+1Ԃ
 *	*src==NUL̏ꍇsrcԂ
 */

char *nextToken(TOKEN *tok,char *src);

/*
 *	͂Iyh̏𓾂
 *	ope͐lłȂƂȂ
 */

CODE_MAP *getCodeProperty(OPECODE ope);

/*
 *	1s̃f[^烉xAIyR[hAIyh͂
 */

int analyzeCode(CODE *code,char *src);

#endif
