/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PSTR.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushString(struct Cfg_Getopt *optstru, char *string)

 *	Push a string, which is not preprocessed in way
 
ob(ject): cfgPushString
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Push a string
he(ader files): 
lo(ng description): Push a string onto the input stack. The contents of the
	string must not be changed until all arguments have been aquired.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pstr.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <stdio.h>
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PSTR.C 1.5 2001/02/27 01:28:06 ska Exp ska $";
#endif

void cfgPushString(struct Cfg_Getopt * const optstru
 , const char * const string)
{	DBG_ENTER("cfgPushString", Suppl_cmdline)
	if(string && *string)
		cfg_addContext(optstru, (void*)string, aF(cfg_rdString), 0);
	DBG_EXIT
}
