//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <atomic>

// template <class T>
//     bool
//     atomic_is_lock_free(const volatile atomic<T>* obj);
// 
// template <class T>
//     bool
//     atomic_is_lock_free(const atomic<T>* obj);

#include <atomic>

template <class T>
void
test()
{
    typedef std::atomic<T> A;
    A t;
    bool b1 = std::atomic_is_lock_free(static_cast<const A*>(&t));
    volatile A vt;
    bool b2 = std::atomic_is_lock_free(static_cast<const volatile A*>(&vt));
}

struct A
{
    char _[4];
};

int main()
{
    test<A>();
    test<char>();
    test<signed char>();
    test<unsigned char>();
    test<short>();
    test<unsigned short>();
    test<int>();
    test<unsigned int>();
    test<long>();
    test<unsigned long>();
    test<long long>();
    test<unsigned long long>();
    test<wchar_t>();
#ifndef _LIBCPP_HAS_NO_UNICODE_CHARS
    test<char16_t>();
    test<char32_t>();
#endif  // _LIBCPP_HAS_NO_UNICODE_CHARS
    test<int*>();
    test<const int*>();
}
