/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafInstallRequestXml/MinPackageElemXml.h"

#include "Doc/CafInstallRequestDoc/CInstallProviderSpecDoc.h"
#include "Doc/CafInstallRequestDoc/CMinPackageElemDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafInstallRequestXml/InstallProviderSpecXml.h"

using namespace Caf;

void InstallProviderSpecXml::add(
	const SmartPtrCInstallProviderSpecDoc installProviderSpecDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstallProviderSpecXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(installProviderSpecDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdVal =
			BasePlatform::UuidToString(installProviderSpecDoc->getClientId());
		CAF_CM_VALIDATE_STRING(clientIdVal);
		thisXml->addAttribute("clientId", clientIdVal);

		const std::string providerNamespaceVal = installProviderSpecDoc->getProviderNamespace();
		CAF_CM_VALIDATE_STRING(providerNamespaceVal);
		thisXml->addAttribute("providerNamespace", providerNamespaceVal);

		const std::string providerNameVal = installProviderSpecDoc->getProviderName();
		CAF_CM_VALIDATE_STRING(providerNameVal);
		thisXml->addAttribute("providerName", providerNameVal);

		const std::string providerVersionVal = installProviderSpecDoc->getProviderVersion();
		CAF_CM_VALIDATE_STRING(providerVersionVal);
		thisXml->addAttribute("providerVersion", providerVersionVal);

		const std::deque<SmartPtrCMinPackageElemDoc> packageValVal =
			installProviderSpecDoc->getPackageCollection();
		CAF_CM_VALIDATE_STL(packageValVal);

		if (! packageValVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCMinPackageElemDoc> > packageValIter(packageValVal);
				packageValIter; packageValIter++) {
				const SmartPtrCXmlElement packageValXml =
					thisXml->createAndAddElement("package");
				MinPackageElemXml::add(*packageValIter, packageValXml);
			}
		}

		thisXml->addAttribute("version", "1.0");
	}
	CAF_CM_EXIT;
}

SmartPtrCInstallProviderSpecDoc InstallProviderSpecXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("InstallProviderSpecXml", "parse");

	SmartPtrCInstallProviderSpecDoc installProviderSpecDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdStrVal =
			thisXml->findRequiredAttribute("clientId");
		UUID clientIdVal = CAFCOMMON_GUID_NULL;
		if (! clientIdStrVal.empty()) {
			BasePlatform::UuidFromString(clientIdStrVal.c_str(), clientIdVal);
		}

		const std::string providerNamespaceStrVal =
			thisXml->findRequiredAttribute("providerNamespace");
		const std::string providerNamespaceVal = providerNamespaceStrVal;

		const std::string providerNameStrVal =
			thisXml->findRequiredAttribute("providerName");
		const std::string providerNameVal = providerNameStrVal;

		const std::string providerVersionStrVal =
			thisXml->findRequiredAttribute("providerVersion");
		const std::string providerVersionVal = providerVersionStrVal;

		const CXmlElement::SmartPtrCElementCollection packageValChildrenXml =
			thisXml->findRequiredChildren("package");

		std::deque<SmartPtrCMinPackageElemDoc> packageValVal;
		if (! packageValChildrenXml.IsNull() && ! packageValChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> packageValXmlIter(*packageValChildrenXml);
				packageValXmlIter; packageValXmlIter++) {
				const SmartPtrCXmlElement packageValXml = packageValXmlIter->second;
				const SmartPtrCMinPackageElemDoc packageValDoc =
					MinPackageElemXml::parse(packageValXml);
				packageValVal.push_back(packageValDoc);
			}
		}

		installProviderSpecDoc.CreateInstance();
		installProviderSpecDoc->initialize(
			clientIdVal,
			providerNamespaceVal,
			providerNameVal,
			providerVersionVal,
			packageValVal);
	}
	CAF_CM_EXIT;

	return installProviderSpecDoc;
}

