/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-package-mechanism.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_PACKAGE_MECHANISM_H
#define __UNITY_WEBAPPS_PACKAGE_MECHANISM_H


#define UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM              (unity_webapps_package_mechanism_get_type())
#define UNITY_WEBAPPS_PACKAGE_MECHANISM(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM, UnityWebappsPackageMechanism))
#define UNITY_WEBAPPS_PACKAGE_MECHANISM_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM, UnityWebappsPackageMechanismClass))
#define UNITY_WEBAPPS_IS_PACKAGE_MECHANISM(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM))
#define UNITY_WEBAPPS_IS_PACKAGE_MECHANISM_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM))
#define UNITY_WEBAPPS_PACKAGE_MECHANISM_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_PACKAGE_MECHANISM, UnityWebappsPackageMechanismClass))

typedef struct _UnityWebappsPackageMechanismPrivate UnityWebappsPackageMechanismPrivate;

typedef struct _UnityWebappsPackageMechanism UnityWebappsPackageMechanism;


struct _UnityWebappsPackageMechanism {
	GObject object;

	UnityWebappsPackageMechanismPrivate *priv;
};

typedef struct _UnityWebappsPackageMechanismClass UnityWebappsPackageMechanismClass;

typedef enum {
	UNITY_WEBAPPS_PACKAGE_STATUS_AVAILABLE,
	UNITY_WEBAPPS_PACKAGE_STATUS_INSTALLED,
	UNITY_WEBAPPS_PACKAGE_STATUS_UNAVAILABLE
} UnityWebappsPackageStatus;

typedef void (*UnityWebappsPackageMechanismStatusCallback) (UnityWebappsPackageMechanism *mechanism,
															const gchar *package,
															UnityWebappsPackageStatus status,
															gpointer user_data);

struct _UnityWebappsPackageMechanismClass
{
	GObjectClass parent_class;
	
	gboolean (*get_package_status) (UnityWebappsPackageMechanism *mechanism, const gchar *name, UnityWebappsPackageMechanismStatusCallback callback, gpointer user_data);
	gboolean (*install_package) (UnityWebappsPackageMechanism *mechanism, const gchar *name, UnityWebappsPackageMechanismStatusCallback callback, gpointer user_data);
};

GType unity_webapps_package_mechanism_get_type (void) G_GNUC_CONST;

gboolean unity_webapps_package_mechanism_get_package_status (UnityWebappsPackageMechanism *mechanism, const gchar *name,
															 UnityWebappsPackageMechanismStatusCallback callback,
															 gpointer user_data);

gboolean unity_webapps_package_mechanism_install_package (UnityWebappsPackageMechanism *mechanism, const gchar *name,
														  UnityWebappsPackageMechanismStatusCallback callback,
														  gpointer user_data);

#endif
