/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import jd.xml.xpath.model.XPathNode;

public class XsltParseException
extends Exception {
    private Exception next_;
    private String baseUri_;
    private String parserMsg_;
    private XPathNode node_;

    public XsltParseException(String string, String string2, Exception exception) {
        super(string);
        this.parserMsg_ = string;
        this.next_ = exception;
        this.baseUri_ = string2;
    }

    public XsltParseException(String string, XPathNode xPathNode, Exception exception) {
        this(string, xPathNode.getRoot().getDocumentBaseUri(), exception);
        this.node_ = xPathNode;
    }

    public String getMessage() {
        return this.parserMsg_ + this.getContext();
    }

    public String getContext() {
        String string = "";
        if (this.baseUri_ != null) {
            string = string + "baseUri='" + this.baseUri_ + "' ";
        }
        if (this.node_ != null) {
            string = string + this.node_.getTypeName() + '=' + this.getNodeInfo(this.node_) + ' ';
            if (this.node_.getType() == 2) {
                string = string + ", Element=" + this.getNodeInfo(this.node_.getParent()) + ' ';
            }
        }
        if (this.next_ != null) {
            string = string + "nested exception = '" + this.next_ + "'";
        }
        if (string.length() > 0) {
            string = " (" + string.trim() + ")";
        }
        return string;
    }

    public Exception getException() {
        return this.next_;
    }

    public String getParserMessage() {
        return this.parserMsg_;
    }

    public String getBaseUri() {
        return this.baseUri_;
    }

    public XPathNode getNode() {
        return this.node_;
    }

    public String getNodeInfo(XPathNode xPathNode) {
        if (xPathNode == null) {
            return null;
        }
        switch (xPathNode.getType()) {
            case 0: {
                String string = xPathNode.getName();
                int n = xPathNode.getLineNumber();
                if (n != -1) {
                    string = string + " (line " + n + ")";
                }
                return string;
            }
            case 2: 
            case 5: {
                return xPathNode.getName();
            }
            case 1: 
            case 4: {
                return "'" + xPathNode.getValue() + "'";
            }
        }
        return "#root";
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this.next_ != null) {
            printWriter.println("original exception was:");
            this.next_.printStackTrace(printWriter);
        }
    }

    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this.next_ != null) {
            printStream.println("Original exception is:");
            this.next_.printStackTrace(printStream);
        }
    }
}

