/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.FieldInstruction;
import serp.bytecode.visitor.BCVisitor;

public class GetFieldInstruction
extends FieldInstruction {
    GetFieldInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public int getLogicalStackChange() {
        if (this.getOpcode() == 178) {
            return 1;
        }
        return 0;
    }

    public int getStackChange() {
        String type = this.getFieldTypeName();
        if (type == null) {
            return 0;
        }
        int stack = 0;
        if (Long.TYPE.getName().equals(type) || Double.TYPE.getName().equals(type)) {
            ++stack;
        }
        if (this.getOpcode() == 178) {
            ++stack;
        }
        return stack;
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterGetFieldInstruction(this);
        visit.exitGetFieldInstruction(this);
    }
}

