; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -O3 < %s | FileCheck %s -check-prefix=PPC64LE

; Test cases are generated from:
; long long NAME(PARAM a, PARAM b) {
;   if (LHS > RHS)
;     return b;
;   if (LHS < RHS)
;     return a;\
;   return a * b;
; }
; Please note funtion name is defined as <PARAM>_<LHS>_<RHS>. Take ll_a_op_b__1
; for example. ll is PARAM, a_op_b (i.e., a << b) is LHS, _1 (i.e., -1) is RHS.

target datalayout = "e-m:e-i64:64-n32:64"
target triple = "powerpc64le-unknown-linux-gnu"

define i64 @ll_a_op_b__2(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_op_b__2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    sld 5, 3, 4
; PPC64LE-NEXT:    cmpdi 5, -2
; PPC64LE-NEXT:    ble 0, .LBB0_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB0_2: # %if.end
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, -2
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b__1(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_op_b__1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    sld 5, 3, 4
; PPC64LE-NEXT:    cmpdi 5, -1
; PPC64LE-NEXT:    ble 0, .LBB1_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB1_2: # %if.end
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, -1
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_0(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_op_b_0:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    sld. 5, 3, 4
; PPC64LE-NEXT:    ble 0, .LBB2_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB2_2: # %if.end
; PPC64LE-NEXT:    cmpldi 5, 0
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 0
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_1(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_op_b_1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    sld 5, 3, 4
; PPC64LE-NEXT:    cmpdi 5, 1
; PPC64LE-NEXT:    ble 0, .LBB3_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB3_2: # %if.end
; PPC64LE-NEXT:    cmpldi 5, 1
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 1
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_op_b_2(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_op_b_2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    sld 5, 3, 4
; PPC64LE-NEXT:    cmpdi 5, 2
; PPC64LE-NEXT:    ble 0, .LBB4_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB4_2: # %if.end
; PPC64LE-NEXT:    cmpldi 5, 2
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i64 %a, %b
  %cmp = icmp sgt i64 %shl, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i64 %shl, 2
  %mul = select i1 %cmp2, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a__2(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a__2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    cmpdi 3, -2
; PPC64LE-NEXT:    ble 0, .LBB5_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB5_2: # %if.end
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, -2
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a__1(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a__1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    cmpdi 3, -1
; PPC64LE-NEXT:    ble 0, .LBB6_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB6_2: # %if.end
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, -1
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_0(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_0:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    cmpdi 3, 0
; PPC64LE-NEXT:    ble 0, .LBB7_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB7_2: # %if.end
; PPC64LE-NEXT:    cmpldi 3, 0
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 0
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_1(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    cmpdi 3, 1
; PPC64LE-NEXT:    ble 0, .LBB8_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB8_2: # %if.end
; PPC64LE-NEXT:    cmpldi 3, 1
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 1
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @ll_a_2(i64 %a, i64 %b) {
; PPC64LE-LABEL: ll_a_2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    cmpdi 3, 2
; PPC64LE-NEXT:    ble 0, .LBB9_2
; PPC64LE-NEXT:  # %bb.1: # %return
; PPC64LE-NEXT:    mr 3, 4
; PPC64LE-NEXT:    blr
; PPC64LE-NEXT:  .LBB9_2: # %if.end
; PPC64LE-NEXT:    cmpldi 3, 2
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    isel 4, 4, 5, 2
; PPC64LE-NEXT:    mulld 3, 4, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i64 %a, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i64 %a, 2
  %mul = select i1 %cmp1, i64 %b, i64 1
  %spec.select = mul nsw i64 %mul, %a
  ret i64 %spec.select

return:                                           ; preds = %entry
  ret i64 %b
}

define i64 @i_a_op_b__2(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_op_b__2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    slw 6, 3, 4
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmpwi 6, -2
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    mullw 3, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, -2
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b__1(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_op_b__1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    slw 6, 3, 4
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmpwi 6, -1
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    mullw 3, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, -1
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_0(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_op_b_0:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    slw. 5, 3, 4
; PPC64LE-NEXT:    li 6, 1
; PPC64LE-NEXT:    isel 6, 4, 6, 2
; PPC64LE-NEXT:    cmpwi 5, 0
; PPC64LE-NEXT:    mullw 3, 6, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 0
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_1(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_op_b_1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    slw 6, 3, 4
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmplwi 6, 1
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    cmpwi 6, 1
; PPC64LE-NEXT:    mullw 3, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 1
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_op_b_2(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_op_b_2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    slw 6, 3, 4
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmplwi 6, 2
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    cmpwi 6, 2
; PPC64LE-NEXT:    mullw 3, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %shl = shl i32 %a, %b
  %cmp = icmp sgt i32 %shl, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp2 = icmp eq i32 %shl, 2
  %mul = select i1 %cmp2, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a__2(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a__2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmpwi 3, -2
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    mullw 3, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, -2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, -2
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a__1(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a__1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmpwi 3, -1
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    mullw 3, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 3, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, -1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, -1
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_0(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_0:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmplwi 3, 0
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    cmpwi 0, 3, 0
; PPC64LE-NEXT:    mullw 5, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 5, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 0
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_1(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_1:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmplwi 3, 1
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    cmpwi 0, 3, 1
; PPC64LE-NEXT:    mullw 5, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 5, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 1
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 1
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}

define i64 @i_a_2(i32 signext %a, i32 signext %b) {
; PPC64LE-LABEL: i_a_2:
; PPC64LE:       # %bb.0: # %entry
; PPC64LE-NEXT:    li 5, 1
; PPC64LE-NEXT:    cmplwi 3, 2
; PPC64LE-NEXT:    isel 5, 4, 5, 2
; PPC64LE-NEXT:    cmpwi 0, 3, 2
; PPC64LE-NEXT:    mullw 5, 5, 3
; PPC64LE-NEXT:    isel 3, 4, 5, 1
; PPC64LE-NEXT:    extsw 3, 3
; PPC64LE-NEXT:    blr
entry:
  %cmp = icmp sgt i32 %a, 2
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %cmp1 = icmp eq i32 %a, 2
  %mul = select i1 %cmp1, i32 %b, i32 1
  %spec.select = mul nsw i32 %mul, %a
  br label %return

return:                                           ; preds = %if.end, %entry
  %retval.0.in = phi i32 [ %b, %entry ], [ %spec.select, %if.end ]
  %retval.0 = sext i32 %retval.0.in to i64
  ret i64 %retval.0
}
