; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='require<profile-summary>,function(codegenprepare)' -S < %s | FileCheck %s
; RUN: opt -enable-debugify -passes='require<profile-summary>,function(codegenprepare)' -S < %s | FileCheck %s -check-prefix=DEBUG
; RUN: opt -enable-debugify -passes='require<profile-summary>,function(codegenprepare)' -S < %s --try-experimental-debuginfo-iterators | FileCheck %s -check-prefix=DEBUG

target triple = "x86_64-unknown-unknown"

; Nothing to sink and convert here.

define i32 @no_sink(double %a, ptr %b, i32 %x, i32 %y)  {
; CHECK-LABEL: @no_sink(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LOAD:%.*]] = load double, ptr [[B:%.*]], align 8
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt double [[LOAD]], [[A:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 [[X:%.*]], i32 [[Y:%.*]]
; CHECK-NEXT:    ret i32 [[SEL]]
;
; DEBUG-LABEL: @no_sink(
; DEBUG-NEXT:  entry:
; DEBUG-NEXT:    [[LOAD:%.*]] = load double, ptr [[B:%.*]], align 8, !dbg [[DBG15:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(double [[LOAD]], [[META9:![0-9]+]], !DIExpression(), [[DBG15]])
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp olt double [[LOAD]], [[A:%.*]], !dbg [[DBG16:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META11:![0-9]+]], !DIExpression(), [[DBG16]])
; DEBUG-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 [[X:%.*]], i32 [[Y:%.*]], !dbg [[DBG17:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i32 [[SEL]], [[META13:![0-9]+]], !DIExpression(), [[DBG17]])
; DEBUG-NEXT:    ret i32 [[SEL]], !dbg [[DBG18:![0-9]+]]
;
entry:
  %load = load double, ptr %b, align 8
  %cmp = fcmp olt double %load, %a
  %sel = select i1 %cmp, i32 %x, i32 %y
  ret i32 %sel
}


; An 'fdiv' is expensive, so sink it rather than speculatively execute it.

define float @fdiv_true_sink(float %a, float %b) {
; CHECK-LABEL: @fdiv_true_sink(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SEL_FROZEN:%.*]] = freeze float [[A:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[SEL_FROZEN]], 1.000000e+00
; CHECK-NEXT:    br i1 [[CMP]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END:%.*]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv float [[A]], [[B:%.*]]
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[SEL:%.*]] = phi float [ [[DIV]], [[SELECT_TRUE_SINK]] ], [ 2.000000e+00, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret float [[SEL]]
;
; DEBUG-LABEL: @fdiv_true_sink(
; DEBUG-NEXT:  entry:
; DEBUG-NEXT:    [[SEL_FROZEN:%.*]] = freeze float [[A:%.*]]
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp ogt float [[SEL_FROZEN]], 1.000000e+00, !dbg [[DBG24:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META22:![0-9]+]], !DIExpression(), [[DBG24]])
; DEBUG-NEXT:    br i1 [[CMP]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_END:%.*]], !dbg [[DBG25:![0-9]+]]
; DEBUG:       select.true.sink:
; DEBUG-NEXT:    [[DIV:%.*]] = fdiv float [[A]], [[B:%.*]], !dbg [[DBG26:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[DIV]], [[META21:![0-9]+]], !DIExpression(), [[DBG26]])
; DEBUG-NEXT:    br label [[SELECT_END]], !dbg [[DBG27:![0-9]+]]
; DEBUG:       select.end:
; DEBUG-NEXT:    [[SEL:%.*]] = phi float [ [[DIV]], [[SELECT_TRUE_SINK]] ], [ 2.000000e+00, [[ENTRY:%.*]] ], !dbg [[DBG25]]
; DEBUG-NEXT:      #dbg_value(float [[SEL]], [[META23:![0-9]+]], !DIExpression(), [[DBG25]])
; DEBUG-NEXT:    ret float [[SEL]], !dbg [[DBG27]]
;
entry:
  %div = fdiv float %a, %b
  %cmp = fcmp ogt float %a, 1.0
  %sel = select i1 %cmp, float %div, float 2.0
  ret float %sel
}

define float @fdiv_false_sink(float %a, float %b) {
; CHECK-LABEL: @fdiv_false_sink(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SEL_FROZEN:%.*]] = freeze float [[A:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[SEL_FROZEN]], 3.000000e+00
; CHECK-NEXT:    br i1 [[CMP]], label [[SELECT_END:%.*]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv float [[A]], [[B:%.*]]
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[SEL:%.*]] = phi float [ 4.000000e+00, [[ENTRY:%.*]] ], [ [[DIV]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    ret float [[SEL]]
;
; DEBUG-LABEL: @fdiv_false_sink(
; DEBUG-NEXT:  entry:
; DEBUG-NEXT:    [[SEL_FROZEN:%.*]] = freeze float [[A:%.*]]
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp ogt float [[SEL_FROZEN]], 3.000000e+00, !dbg [[DBG33:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META31:![0-9]+]], !DIExpression(), [[DBG33]])
; DEBUG-NEXT:    br i1 [[CMP]], label [[SELECT_END:%.*]], label [[SELECT_FALSE_SINK:%.*]], !dbg [[DBG34:![0-9]+]]
; DEBUG:       select.false.sink:
; DEBUG-NEXT:    [[DIV:%.*]] = fdiv float [[A]], [[B:%.*]], !dbg [[DBG35:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[DIV]], [[META30:![0-9]+]], !DIExpression(), [[DBG35]])
; DEBUG-NEXT:    br label [[SELECT_END]], !dbg [[DBG36:![0-9]+]]
; DEBUG:       select.end:
; DEBUG-NEXT:    [[SEL:%.*]] = phi float [ 4.000000e+00, [[ENTRY:%.*]] ], [ [[DIV]], [[SELECT_FALSE_SINK]] ], !dbg [[DBG34]]
; DEBUG-NEXT:      #dbg_value(float [[SEL]], [[META32:![0-9]+]], !DIExpression(), [[DBG34]])
; DEBUG-NEXT:    ret float [[SEL]], !dbg [[DBG36]]
;
entry:
  %div = fdiv float %a, %b
  %cmp = fcmp ogt float %a, 3.0
  %sel = select i1 %cmp, float 4.0, float %div
  ret float %sel
}

define float @fdiv_both_sink(float %a, float %b) {
; CHECK-LABEL: @fdiv_both_sink(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SEL_FROZEN:%.*]] = freeze float [[A:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[SEL_FROZEN]], 5.000000e+00
; CHECK-NEXT:    br i1 [[CMP]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_FALSE_SINK:%.*]]
; CHECK:       select.true.sink:
; CHECK-NEXT:    [[DIV1:%.*]] = fdiv float [[A]], [[B:%.*]]
; CHECK-NEXT:    br label [[SELECT_END:%.*]]
; CHECK:       select.false.sink:
; CHECK-NEXT:    [[DIV2:%.*]] = fdiv float [[B]], [[A]]
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[SEL:%.*]] = phi float [ [[DIV1]], [[SELECT_TRUE_SINK]] ], [ [[DIV2]], [[SELECT_FALSE_SINK]] ]
; CHECK-NEXT:    ret float [[SEL]]
;
; DEBUG-LABEL: @fdiv_both_sink(
; DEBUG-NEXT:  entry:
; DEBUG-NEXT:    [[SEL_FROZEN:%.*]] = freeze float [[A:%.*]]
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp ogt float [[SEL_FROZEN]], 5.000000e+00, !dbg [[DBG43:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META41:![0-9]+]], !DIExpression(), [[DBG43]])
; DEBUG-NEXT:    br i1 [[CMP]], label [[SELECT_TRUE_SINK:%.*]], label [[SELECT_FALSE_SINK:%.*]], !dbg [[DBG44:![0-9]+]]
; DEBUG:       select.true.sink:
; DEBUG-NEXT:    [[DIV1:%.*]] = fdiv float [[A]], [[B:%.*]], !dbg [[DBG45:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[DIV1]], [[META39:![0-9]+]], !DIExpression(), [[DBG45]])
; DEBUG-NEXT:    br label [[SELECT_END:%.*]], !dbg [[DBG46:![0-9]+]]
; DEBUG:       select.false.sink:
; DEBUG-NEXT:    [[DIV2:%.*]] = fdiv float [[B]], [[A]], !dbg [[DBG47:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[DIV2]], [[META40:![0-9]+]], !DIExpression(), [[DBG47]])
; DEBUG-NEXT:    br label [[SELECT_END]], !dbg [[DBG46]]
; DEBUG:       select.end:
; DEBUG-NEXT:    [[SEL:%.*]] = phi float [ [[DIV1]], [[SELECT_TRUE_SINK]] ], [ [[DIV2]], [[SELECT_FALSE_SINK]] ], !dbg [[DBG44]]
; DEBUG-NEXT:      #dbg_value(float [[SEL]], [[META42:![0-9]+]], !DIExpression(), [[DBG44]])
; DEBUG-NEXT:    ret float [[SEL]], !dbg [[DBG46]]
;
entry:
  %div1 = fdiv float %a, %b
  %div2 = fdiv float %b, %a
  %cmp = fcmp ogt float %a, 5.0
  %sel = select i1 %cmp, float %div1, float %div2
  ret float %sel
}

; But if the select is marked unpredictable, then don't turn it into a branch.

define float @unpredictable_select(float %a, float %b) {
; CHECK-LABEL: @unpredictable_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[A]], 1.000000e+00
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float [[DIV]], float 2.000000e+00, !unpredictable [[META0:![0-9]+]]
; CHECK-NEXT:    ret float [[SEL]]
;
; DEBUG-LABEL: @unpredictable_select(
; DEBUG-NEXT:  entry:
; DEBUG-NEXT:    [[DIV:%.*]] = fdiv float [[A:%.*]], [[B:%.*]], !dbg [[DBG53:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[DIV]], [[META50:![0-9]+]], !DIExpression(), [[DBG53]])
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp ogt float [[A]], 1.000000e+00, !dbg [[DBG54:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META51:![0-9]+]], !DIExpression(), [[DBG54]])
; DEBUG-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float [[DIV]], float 2.000000e+00, !dbg [[DBG55:![0-9]+]], !unpredictable [[META7:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[SEL]], [[META52:![0-9]+]], !DIExpression(), [[DBG55]])
; DEBUG-NEXT:    ret float [[SEL]], !dbg [[DBG56:![0-9]+]]
;
entry:
  %div = fdiv float %a, %b
  %cmp = fcmp ogt float %a, 1.0
  %sel = select i1 %cmp, float %div, float 2.0, !unpredictable !0
  ret float %sel
}

!0 = !{}

; An 'fadd' is not too expensive, so it's ok to speculate.

define float @fadd_no_sink(float %a, float %b) {
; CHECK-LABEL: @fadd_no_sink(
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float 6.000000e+00, [[A]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float [[ADD]], float 7.000000e+00
; CHECK-NEXT:    ret float [[SEL]]
;
; DEBUG-LABEL: @fadd_no_sink(
; DEBUG-NEXT:    [[ADD:%.*]] = fadd float [[A:%.*]], [[B:%.*]], !dbg [[DBG62:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[ADD]], [[META59:![0-9]+]], !DIExpression(), [[DBG62]])
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp ogt float 6.000000e+00, [[A]], !dbg [[DBG63:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META60:![0-9]+]], !DIExpression(), [[DBG63]])
; DEBUG-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float [[ADD]], float 7.000000e+00, !dbg [[DBG64:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[SEL]], [[META61:![0-9]+]], !DIExpression(), [[DBG64]])
; DEBUG-NEXT:    ret float [[SEL]], !dbg [[DBG65:![0-9]+]]
;
  %add = fadd float %a, %b
  %cmp = fcmp ogt float 6.0, %a
  %sel = select i1 %cmp, float %add, float 7.0
  ret float %sel
}

; Possible enhancement: sinkability is only calculated with the direct
; operand of the select, so we don't try to sink this. The fdiv cost is not
; taken into account.

define float @fdiv_no_sink(float %a, float %b) {
; CHECK-LABEL: @fdiv_no_sink(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DIV:%.*]] = fdiv float [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[ADD:%.*]] = fadd float [[DIV]], [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt float [[A]], 1.000000e+00
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float [[ADD]], float 8.000000e+00
; CHECK-NEXT:    ret float [[SEL]]
;
; DEBUG-LABEL: @fdiv_no_sink(
; DEBUG-NEXT:  entry:
; DEBUG-NEXT:    [[DIV:%.*]] = fdiv float [[A:%.*]], [[B:%.*]], !dbg [[DBG72:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[DIV]], [[META68:![0-9]+]], !DIExpression(), [[DBG72]])
; DEBUG-NEXT:    [[ADD:%.*]] = fadd float [[DIV]], [[B]], !dbg [[DBG73:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[ADD]], [[META69:![0-9]+]], !DIExpression(), [[DBG73]])
; DEBUG-NEXT:    [[CMP:%.*]] = fcmp ogt float [[A]], 1.000000e+00, !dbg [[DBG74:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META70:![0-9]+]], !DIExpression(), [[DBG74]])
; DEBUG-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], float [[ADD]], float 8.000000e+00, !dbg [[DBG75:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(float [[SEL]], [[META71:![0-9]+]], !DIExpression(), [[DBG75]])
; DEBUG-NEXT:    ret float [[SEL]], !dbg [[DBG76:![0-9]+]]
;
entry:
  %div = fdiv float %a, %b
  %add = fadd float %div, %b
  %cmp = fcmp ogt float %a, 1.0
  %sel = select i1 %cmp, float %add, float 8.0
  ret float %sel
}

; Do not transform the CFG if the select operands may have side effects.

declare ptr @bar(i32, i32, i32)
declare ptr @baz(i32, i32, i32)

define ptr @calls_no_sink(i32 %in) {
; CHECK-LABEL: @calls_no_sink(
; CHECK-NEXT:    [[CALL1:%.*]] = call ptr @bar(i32 1, i32 2, i32 3)
; CHECK-NEXT:    [[CALL2:%.*]] = call ptr @baz(i32 1, i32 2, i32 3)
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[IN:%.*]], 0
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[TOBOOL]], ptr [[CALL1]], ptr [[CALL2]]
; CHECK-NEXT:    ret ptr [[SEL]]
;
; DEBUG-LABEL: @calls_no_sink(
; DEBUG-NEXT:    [[CALL1:%.*]] = call ptr @bar(i32 1, i32 2, i32 3), !dbg [[DBG83:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(ptr [[CALL1]], [[META79:![0-9]+]], !DIExpression(), [[DBG83]])
; DEBUG-NEXT:    [[CALL2:%.*]] = call ptr @baz(i32 1, i32 2, i32 3), !dbg [[DBG84:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(ptr [[CALL2]], [[META80:![0-9]+]], !DIExpression(), [[DBG84]])
; DEBUG-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[IN:%.*]], 0, !dbg [[DBG85:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[TOBOOL]], [[META81:![0-9]+]], !DIExpression(), [[DBG85]])
; DEBUG-NEXT:    [[SEL:%.*]] = select i1 [[TOBOOL]], ptr [[CALL1]], ptr [[CALL2]], !dbg [[DBG86:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(ptr [[SEL]], [[META82:![0-9]+]], !DIExpression(), [[DBG86]])
; DEBUG-NEXT:    ret ptr [[SEL]], !dbg [[DBG87:![0-9]+]]
;
  %call1 = call ptr @bar(i32 1, i32 2, i32 3)
  %call2 = call ptr @baz(i32 1, i32 2, i32 3)
  %tobool = icmp ne i32 %in, 0
  %sel = select i1 %tobool, ptr %call1, ptr %call2
  ret ptr %sel
}

define i32 @sdiv_no_sink(i32 %a, i32 %b) {
; CHECK-LABEL: @sdiv_no_sink(
; CHECK-NEXT:    [[DIV1:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[DIV2:%.*]] = sdiv i32 [[B]], [[A]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], 5
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 [[DIV1]], i32 [[DIV2]]
; CHECK-NEXT:    ret i32 [[SEL]]
;
; DEBUG-LABEL: @sdiv_no_sink(
; DEBUG-NEXT:    [[DIV1:%.*]] = sdiv i32 [[A:%.*]], [[B:%.*]], !dbg [[DBG94:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i32 [[DIV1]], [[META90:![0-9]+]], !DIExpression(), [[DBG94]])
; DEBUG-NEXT:    [[DIV2:%.*]] = sdiv i32 [[B]], [[A]], !dbg [[DBG95:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i32 [[DIV2]], [[META91:![0-9]+]], !DIExpression(), [[DBG95]])
; DEBUG-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[A]], 5, !dbg [[DBG96:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i1 [[CMP]], [[META92:![0-9]+]], !DIExpression(), [[DBG96]])
; DEBUG-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i32 [[DIV1]], i32 [[DIV2]], !dbg [[DBG97:![0-9]+]]
; DEBUG-NEXT:      #dbg_value(i32 [[SEL]], [[META93:![0-9]+]], !DIExpression(), [[DBG97]])
; DEBUG-NEXT:    ret i32 [[SEL]], !dbg [[DBG98:![0-9]+]]
;
  %div1 = sdiv i32 %a, %b
  %div2 = sdiv i32 %b, %a
  %cmp = icmp sgt i32 %a, 5
  %sel = select i1 %cmp, i32 %div1, i32 %div2
  ret i32 %sel
}

