; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s

; This test case tests multiply high for i32 and i64. When the values are
; sign-extended, mulh[d|w] is emitted. When values are zero-extended,
; mulh[d|w]u is emitted instead.

; The primary goal is transforming the pattern:
; (shift (mul (ext $a, <wide_type>), (ext $b, <wide_type>)), <narrow_type>)
; into (mulhs $a, $b) for sign extend, and (mulhu $a, $b) for zero extend,
; provided that the mulh operation is legal for <narrow_type>.
; The shift operation can be either the srl or sra operations.

; When no attribute is present on i32, the shift operation is srl.
define i32 @test_mulhw(i32 %a, i32 %b) {
; CHECK-LABEL: test_mulhw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhw r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
  %1 = sext i32 %a to i64
  %2 = sext i32 %b to i64
  %mul = mul i64 %1, %2
  %shr = lshr i64 %mul, 32
  %tr = trunc i64 %shr to i32
  ret i32 %tr
}

define i32 @test_mulhu(i32 %a, i32 %b) {
; CHECK-LABEL: test_mulhu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhwu r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
  %1 = zext i32 %a to i64
  %2 = zext i32 %b to i64
  %mul = mul i64 %1, %2
  %shr = lshr i64 %mul, 32
  %tr = trunc i64 %shr to i32
  ret i32 %tr
}

define i64 @test_mulhd(i64 %a, i64 %b) {
; CHECK-LABEL: test_mulhd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhd r3, r3, r4
; CHECK-NEXT:    blr
  %1 = sext i64 %a to i128
  %2 = sext i64 %b to i128
  %mul = mul i128 %1, %2
  %shr = lshr i128 %mul, 64
  %tr = trunc i128 %shr to i64
  ret i64 %tr
}

define i64 @test_mulhdu(i64 %a, i64 %b) {
; CHECK-LABEL: test_mulhdu:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhdu r3, r3, r4
; CHECK-NEXT:    blr
  %1 = zext i64 %a to i128
  %2 = zext i64 %b to i128
  %mul = mul i128 %1, %2
  %shr = lshr i128 %mul, 64
  %tr = trunc i128 %shr to i64
  ret i64 %tr
}

; When the signext attribute is present on i32, the shift operation is sra.
; We are actually transforming (sra (mul sext_in_reg, sext_in_reg)) into mulh.
define signext i32 @test_mulhw_signext(i32 %a, i32 %b) {
; CHECK-LABEL: test_mulhw_signext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhw r3, r3, r4
; CHECK-NEXT:    extsw r3, r3
; CHECK-NEXT:    blr
  %1 = sext i32 %a to i64
  %2 = sext i32 %b to i64
  %mul = mul i64 %1, %2
  %shr = lshr i64 %mul, 32
  %tr = trunc i64 %shr to i32
  ret i32 %tr
}

define zeroext i32 @test_mulhu_zeroext(i32 %a, i32 %b) {
; CHECK-LABEL: test_mulhu_zeroext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhwu r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
  %1 = zext i32 %a to i64
  %2 = zext i32 %b to i64
  %mul = mul i64 %1, %2
  %shr = lshr i64 %mul, 32
  %tr = trunc i64 %shr to i32
  ret i32 %tr
}

define signext i64 @test_mulhd_signext(i64 %a, i64 %b) {
; CHECK-LABEL: test_mulhd_signext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhd r3, r3, r4
; CHECK-NEXT:    blr
  %1 = sext i64 %a to i128
  %2 = sext i64 %b to i128
  %mul = mul i128 %1, %2
  %shr = lshr i128 %mul, 64
  %tr = trunc i128 %shr to i64
  ret i64 %tr
}

define zeroext i64 @test_mulhdu_zeroext(i64 %a, i64 %b) {
; CHECK-LABEL: test_mulhdu_zeroext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mulhdu r3, r3, r4
; CHECK-NEXT:    blr
  %1 = zext i64 %a to i128
  %2 = zext i64 %b to i128
  %mul = mul i128 %1, %2
  %shr = lshr i128 %mul, 64
  %tr = trunc i128 %shr to i64
  ret i64 %tr
}
