// RUN: llvm-mc -arch=amdgcn -mcpu=tonga -show-encoding %s | FileCheck %s

v_cndmask_b32 v5, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x00]

v_cndmask_b32 v255, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x01]

v_cndmask_b32 v5, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x00]

v_cndmask_b32 v5, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x00]

v_cndmask_b32 v5, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x00]

v_cndmask_b32 v5, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x00]

v_cndmask_b32 v5, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x00]

v_cndmask_b32 v5, src_lds_direct, v2, vcc
// CHECK: [0xfe,0x04,0x0a,0x00]

v_cndmask_b32 v5, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x00]

v_add_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x02]

v_add_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x03]

v_add_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x02]

v_add_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x02]

v_add_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x02]

v_add_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x02]

v_add_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x02]

v_add_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x02]

v_add_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x02]

v_add_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x02]

v_add_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x02]

v_add_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x02]

v_add_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x02]

v_add_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x02]

v_add_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x02]

v_add_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x02]

v_add_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x02]

v_add_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x02]

v_add_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x02]

v_add_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x02]

v_add_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x02]

v_add_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x02]

v_add_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x02]

v_add_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x02]

v_add_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x02]

v_add_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x02,0x56,0x34,0x12,0xaf]

v_add_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x02,0x73,0x72,0x71,0x3f]

v_add_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x02]

v_sub_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x04]

v_sub_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x05]

v_sub_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x04]

v_sub_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x04]

v_sub_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x04]

v_sub_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x04]

v_sub_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x04]

v_sub_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x04]

v_sub_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x04]

v_sub_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x04]

v_sub_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x04]

v_sub_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x04]

v_sub_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x04]

v_sub_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x04]

v_sub_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x04]

v_sub_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x04]

v_sub_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x04]

v_sub_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x04]

v_sub_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x04]

v_sub_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x04]

v_sub_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x04]

v_sub_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x04]

v_sub_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x04]

v_sub_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x04]

v_sub_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x04]

v_sub_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x04,0x56,0x34,0x12,0xaf]

v_sub_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x04,0x73,0x72,0x71,0x3f]

v_sub_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x04]

v_subrev_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x06]

v_subrev_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x07]

v_subrev_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x06]

v_subrev_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x06]

v_subrev_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x06]

v_subrev_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x06]

v_subrev_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x06]

v_subrev_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x06]

v_subrev_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x06]

v_subrev_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x06]

v_subrev_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x06]

v_subrev_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x06]

v_subrev_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x06]

v_subrev_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x06]

v_subrev_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x06]

v_subrev_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x06]

v_subrev_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x06]

v_subrev_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x06]

v_subrev_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x06]

v_subrev_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x06]

v_subrev_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x06]

v_subrev_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x06]

v_subrev_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x06]

v_subrev_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x06]

v_subrev_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x06,0x56,0x34,0x12,0xaf]

v_subrev_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x06,0x73,0x72,0x71,0x3f]

v_subrev_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x06]

v_mul_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x08]

v_mul_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x09]

v_mul_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x08]

v_mul_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x08]

v_mul_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x08,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x08,0x73,0x72,0x71,0x3f]

v_mul_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x08]

v_mul_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0a]

v_mul_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0b]

v_mul_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0a]

v_mul_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0a]

v_mul_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x0a]

v_mul_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x0a]

v_mul_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x0a]

v_mul_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0a]

v_mul_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0a]

v_mul_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0a]

v_mul_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0a]

v_mul_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0a]

v_mul_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0a]

v_mul_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0a]

v_mul_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0a]

v_mul_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0a]

v_mul_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0a]

v_mul_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0a]

v_mul_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0a]

v_mul_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0a]

v_mul_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0a]

v_mul_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x0a]

v_mul_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x0a]

v_mul_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x0a]

v_mul_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x0a]

v_mul_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0a,0x56,0x34,0x12,0xaf]

v_mul_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0a,0x73,0x72,0x71,0x3f]

v_mul_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0a]

v_mul_i32_i24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0c]

v_mul_i32_i24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0d]

v_mul_i32_i24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0c]

v_mul_i32_i24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x0c]

v_mul_i32_i24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0c,0x56,0x34,0x12,0xaf]

v_mul_i32_i24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0c,0x73,0x72,0x71,0x3f]

v_mul_i32_i24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0c]

v_mul_hi_i32_i24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0e]

v_mul_hi_i32_i24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0f]

v_mul_hi_i32_i24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0e]

v_mul_hi_i32_i24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x0e]

v_mul_hi_i32_i24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0e,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0e,0x73,0x72,0x71,0x3f]

v_mul_hi_i32_i24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0e]

v_mul_u32_u24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x10]

v_mul_u32_u24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x11]

v_mul_u32_u24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x10]

v_mul_u32_u24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x10]

v_mul_u32_u24 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x10]

v_mul_u32_u24 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x10]

v_mul_u32_u24 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x10]

v_mul_u32_u24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x10]

v_mul_u32_u24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x10]

v_mul_u32_u24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x10]

v_mul_u32_u24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x10]

v_mul_u32_u24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x10]

v_mul_u32_u24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x10]

v_mul_u32_u24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x10]

v_mul_u32_u24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x10]

v_mul_u32_u24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x10]

v_mul_u32_u24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x10]

v_mul_u32_u24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x10]

v_mul_u32_u24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x10]

v_mul_u32_u24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x10]

v_mul_u32_u24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x10]

v_mul_u32_u24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x10]

v_mul_u32_u24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x10]

v_mul_u32_u24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x10]

v_mul_u32_u24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x10]

v_mul_u32_u24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x10,0x56,0x34,0x12,0xaf]

v_mul_u32_u24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x10,0x73,0x72,0x71,0x3f]

v_mul_u32_u24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x10]

v_mul_hi_u32_u24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x12]

v_mul_hi_u32_u24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x13]

v_mul_hi_u32_u24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x12]

v_mul_hi_u32_u24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x12]

v_mul_hi_u32_u24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x12,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x12,0x73,0x72,0x71,0x3f]

v_mul_hi_u32_u24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x12]

v_min_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x14]

v_min_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x15]

v_min_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x14]

v_min_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x14]

v_min_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x14]

v_min_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x14]

v_min_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x14]

v_min_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x14]

v_min_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x14]

v_min_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x14]

v_min_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x14]

v_min_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x14]

v_min_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x14]

v_min_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x14]

v_min_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x14]

v_min_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x14]

v_min_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x14]

v_min_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x14]

v_min_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x14]

v_min_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x14]

v_min_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x14]

v_min_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x14]

v_min_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x14]

v_min_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x14]

v_min_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x14]

v_min_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x14,0x56,0x34,0x12,0xaf]

v_min_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x14,0x73,0x72,0x71,0x3f]

v_min_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x14]

v_max_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x16]

v_max_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x17]

v_max_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x16]

v_max_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x16]

v_max_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x16]

v_max_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x16]

v_max_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x16]

v_max_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x16]

v_max_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x16]

v_max_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x16]

v_max_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x16]

v_max_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x16]

v_max_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x16]

v_max_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x16]

v_max_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x16]

v_max_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x16]

v_max_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x16]

v_max_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x16]

v_max_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x16]

v_max_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x16]

v_max_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x16]

v_max_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x16]

v_max_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x16]

v_max_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x16]

v_max_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x16]

v_max_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x16,0x56,0x34,0x12,0xaf]

v_max_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x16,0x73,0x72,0x71,0x3f]

v_max_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x16]

v_min_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x18]

v_min_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x19]

v_min_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x18]

v_min_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x18]

v_min_i32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x18]

v_min_i32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x18]

v_min_i32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x18]

v_min_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x18]

v_min_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x18]

v_min_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x18]

v_min_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x18]

v_min_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x18]

v_min_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x18]

v_min_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x18]

v_min_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x18]

v_min_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x18]

v_min_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x18]

v_min_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x18]

v_min_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x18]

v_min_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x18]

v_min_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x18]

v_min_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x18]

v_min_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x18]

v_min_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x18]

v_min_i32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x18]

v_min_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x18,0x56,0x34,0x12,0xaf]

v_min_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x18,0x73,0x72,0x71,0x3f]

v_min_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x18]

v_max_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1a]

v_max_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1b]

v_max_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1a]

v_max_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1a]

v_max_i32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x1a]

v_max_i32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x1a]

v_max_i32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x1a]

v_max_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1a]

v_max_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1a]

v_max_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1a]

v_max_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1a]

v_max_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1a]

v_max_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1a]

v_max_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1a]

v_max_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1a]

v_max_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1a]

v_max_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1a]

v_max_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1a]

v_max_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1a]

v_max_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1a]

v_max_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1a]

v_max_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x1a]

v_max_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x1a]

v_max_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x1a]

v_max_i32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x1a]

v_max_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1a,0x56,0x34,0x12,0xaf]

v_max_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1a,0x73,0x72,0x71,0x3f]

v_max_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1a]

v_min_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1c]

v_min_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1d]

v_min_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1c]

v_min_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1c]

v_min_u32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x1c]

v_min_u32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x1c]

v_min_u32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x1c]

v_min_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1c]

v_min_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1c]

v_min_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1c]

v_min_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1c]

v_min_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1c]

v_min_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1c]

v_min_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1c]

v_min_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1c]

v_min_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1c]

v_min_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1c]

v_min_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1c]

v_min_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1c]

v_min_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1c]

v_min_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1c]

v_min_u32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x1c]

v_min_u32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x1c]

v_min_u32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x1c]

v_min_u32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x1c]

v_min_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1c,0x56,0x34,0x12,0xaf]

v_min_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1c,0x73,0x72,0x71,0x3f]

v_min_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1c]

v_max_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1e]

v_max_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1f]

v_max_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1e]

v_max_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1e]

v_max_u32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x1e]

v_max_u32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x1e]

v_max_u32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x1e]

v_max_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1e]

v_max_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1e]

v_max_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1e]

v_max_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1e]

v_max_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1e]

v_max_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1e]

v_max_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1e]

v_max_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1e]

v_max_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1e]

v_max_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1e]

v_max_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1e]

v_max_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1e]

v_max_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1e]

v_max_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1e]

v_max_u32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x1e]

v_max_u32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x1e]

v_max_u32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x1e]

v_max_u32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x1e]

v_max_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1e,0x56,0x34,0x12,0xaf]

v_max_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1e,0x73,0x72,0x71,0x3f]

v_max_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1e]

v_lshrrev_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x20]

v_lshrrev_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x21]

v_lshrrev_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x20]

v_lshrrev_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x20]

v_lshrrev_b32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x20]

v_lshrrev_b32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x20]

v_lshrrev_b32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x20]

v_lshrrev_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x20]

v_lshrrev_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x20]

v_lshrrev_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x20]

v_lshrrev_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x20]

v_lshrrev_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x20]

v_lshrrev_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x20]

v_lshrrev_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x20]

v_lshrrev_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x20]

v_lshrrev_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x20]

v_lshrrev_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x20]

v_lshrrev_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x20]

v_lshrrev_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x20]

v_lshrrev_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x20]

v_lshrrev_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x20]

v_lshrrev_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x20]

v_lshrrev_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x20]

v_lshrrev_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x20]

v_lshrrev_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x20,0x56,0x34,0x12,0xaf]

v_lshrrev_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x20,0x73,0x72,0x71,0x3f]

v_lshrrev_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x20]

v_ashrrev_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x22]

v_ashrrev_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x23]

v_ashrrev_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x22]

v_ashrrev_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x22]

v_ashrrev_i32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x22]

v_ashrrev_i32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x22]

v_ashrrev_i32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x22]

v_ashrrev_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x22]

v_ashrrev_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x22]

v_ashrrev_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x22]

v_ashrrev_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x22]

v_ashrrev_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x22]

v_ashrrev_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x22]

v_ashrrev_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x22]

v_ashrrev_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x22]

v_ashrrev_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x22]

v_ashrrev_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x22]

v_ashrrev_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x22]

v_ashrrev_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x22]

v_ashrrev_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x22]

v_ashrrev_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x22]

v_ashrrev_i32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x22]

v_ashrrev_i32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x22]

v_ashrrev_i32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x22]

v_ashrrev_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x22,0x56,0x34,0x12,0xaf]

v_ashrrev_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x22,0x73,0x72,0x71,0x3f]

v_ashrrev_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x22]

v_lshlrev_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x24]

v_lshlrev_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x25]

v_lshlrev_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x24]

v_lshlrev_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x24]

v_lshlrev_b32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x24]

v_lshlrev_b32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x24]

v_lshlrev_b32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x24]

v_lshlrev_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x24]

v_lshlrev_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x24]

v_lshlrev_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x24]

v_lshlrev_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x24]

v_lshlrev_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x24]

v_lshlrev_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x24]

v_lshlrev_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x24]

v_lshlrev_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x24]

v_lshlrev_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x24]

v_lshlrev_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x24]

v_lshlrev_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x24]

v_lshlrev_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x24]

v_lshlrev_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x24]

v_lshlrev_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x24]

v_lshlrev_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x24]

v_lshlrev_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x24]

v_lshlrev_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x24]

v_lshlrev_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x24,0x56,0x34,0x12,0xaf]

v_lshlrev_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x24,0x73,0x72,0x71,0x3f]

v_lshlrev_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x24]

v_and_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x26]

v_and_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x27]

v_and_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x26]

v_and_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x26]

v_and_b32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x26]

v_and_b32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x26]

v_and_b32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x26]

v_and_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x26]

v_and_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x26]

v_and_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x26]

v_and_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x26]

v_and_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x26]

v_and_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x26]

v_and_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x26]

v_and_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x26]

v_and_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x26]

v_and_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x26]

v_and_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x26]

v_and_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x26]

v_and_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x26]

v_and_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x26]

v_and_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x26]

v_and_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x26]

v_and_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x26]

v_and_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x26]

v_and_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x26,0x56,0x34,0x12,0xaf]

v_and_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x26,0x73,0x72,0x71,0x3f]

v_and_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x26]

v_or_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x28]

v_or_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x29]

v_or_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x28]

v_or_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x28]

v_or_b32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x28]

v_or_b32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x28]

v_or_b32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x28]

v_or_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x28]

v_or_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x28]

v_or_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x28]

v_or_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x28]

v_or_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x28]

v_or_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x28]

v_or_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x28]

v_or_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x28]

v_or_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x28]

v_or_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x28]

v_or_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x28]

v_or_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x28]

v_or_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x28]

v_or_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x28]

v_or_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x28]

v_or_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x28]

v_or_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x28]

v_or_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x28]

v_or_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x28,0x56,0x34,0x12,0xaf]

v_or_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x28,0x73,0x72,0x71,0x3f]

v_or_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x28]

v_xor_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2a]

v_xor_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2b]

v_xor_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2a]

v_xor_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2a]

v_xor_b32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x2a]

v_xor_b32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x2a]

v_xor_b32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x2a]

v_xor_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2a]

v_xor_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2a]

v_xor_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2a]

v_xor_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2a]

v_xor_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2a]

v_xor_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2a]

v_xor_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2a]

v_xor_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2a]

v_xor_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2a]

v_xor_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2a]

v_xor_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2a]

v_xor_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2a]

v_xor_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2a]

v_xor_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2a]

v_xor_b32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x2a]

v_xor_b32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x2a]

v_xor_b32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x2a]

v_xor_b32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x2a]

v_xor_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2a,0x56,0x34,0x12,0xaf]

v_xor_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2a,0x73,0x72,0x71,0x3f]

v_xor_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2a]

v_mac_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2c]

v_mac_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2d]

v_mac_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2c]

v_mac_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2c]

v_mac_f32 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x2c]

v_mac_f32 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x2c]

v_mac_f32 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x2c]

v_mac_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2c]

v_mac_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2c]

v_mac_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2c]

v_mac_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2c]

v_mac_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2c]

v_mac_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2c]

v_mac_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2c]

v_mac_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2c]

v_mac_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2c]

v_mac_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2c]

v_mac_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2c]

v_mac_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2c]

v_mac_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2c]

v_mac_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2c]

v_mac_f32 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x2c]

v_mac_f32 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x2c]

v_mac_f32 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x2c]

v_mac_f32 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x2c]

v_mac_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2c,0x56,0x34,0x12,0xaf]

v_mac_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2c,0x73,0x72,0x71,0x3f]

v_mac_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2c]

v_madmk_f32 v5, v1, 0x11213141, v3
// CHECK: [0x01,0x07,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v255, v1, 0x11213141, v3
// CHECK: [0x01,0x07,0xfe,0x2f,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v255, 0x11213141, v3
// CHECK: [0xff,0x07,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0, 0x11213141, v3
// CHECK: [0x80,0x06,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -1, 0x11213141, v3
// CHECK: [0xc1,0x06,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0.5, 0x11213141, v3
// CHECK: [0xf0,0x06,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -4.0, 0x11213141, v3
// CHECK: [0xf7,0x06,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, src_lds_direct, 0x11213141, v3
// CHECK: [0xfe,0x06,0x0a,0x2e,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v1, 0xa1b1c1d1, v3
// CHECK: [0x01,0x07,0x0a,0x2e,0xd1,0xc1,0xb1,0xa1]

v_madmk_f32 v5, v1, 0x11213141, v255
// CHECK: [0x01,0xff,0x0b,0x2e,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0x11213141
// CHECK: [0x01,0x05,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v255, v1, v2, 0x11213141
// CHECK: [0x01,0x05,0xfe,0x31,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v255, v2, 0x11213141
// CHECK: [0xff,0x05,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0, v2, 0x11213141
// CHECK: [0x80,0x04,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -1, v2, 0x11213141
// CHECK: [0xc1,0x04,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0.5, v2, 0x11213141
// CHECK: [0xf0,0x04,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -4.0, v2, 0x11213141
// CHECK: [0xf7,0x04,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, src_lds_direct, v2, 0x11213141
// CHECK: [0xfe,0x04,0x0a,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v255, 0x11213141
// CHECK: [0x01,0xff,0x0b,0x30,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0xa1b1c1d1
// CHECK: [0x01,0x05,0x0a,0x30,0xd1,0xc1,0xb1,0xa1]

v_add_u32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x32]

v_add_u32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x33]

v_add_u32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x32]

v_add_u32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x32]

v_add_u32 v5, vcc, s101, v2
// CHECK: [0x65,0x04,0x0a,0x32]

v_add_u32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x32]

v_add_u32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x32]

v_add_u32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x32]

v_add_u32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x32]

v_add_u32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x32]

v_add_u32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x32]

v_add_u32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x32]

v_add_u32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x32]

v_add_u32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x32]

v_add_u32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x32]

v_add_u32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x32]

v_add_u32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x32]

v_add_u32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x32]

v_add_u32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x32]

v_add_u32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x32]

v_add_u32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x32]

v_add_u32 v5, vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x32]

v_add_u32 v5, vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x32]

v_add_u32 v5, vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x32]

v_add_u32 v5, vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x32]

v_add_u32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x32,0x56,0x34,0x12,0xaf]

v_add_u32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x32,0x73,0x72,0x71,0x3f]

v_add_u32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x32]

v_sub_u32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x34]

v_sub_u32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x35]

v_sub_u32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x34]

v_sub_u32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, s101, v2
// CHECK: [0x65,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x34]

v_sub_u32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x34,0x56,0x34,0x12,0xaf]

v_sub_u32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x34,0x73,0x72,0x71,0x3f]

v_sub_u32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x34]

v_subrev_u32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x36]

v_subrev_u32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x37]

v_subrev_u32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x36]

v_subrev_u32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, s101, v2
// CHECK: [0x65,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x36]

v_subrev_u32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x36,0x56,0x34,0x12,0xaf]

v_subrev_u32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x36,0x73,0x72,0x71,0x3f]

v_subrev_u32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x36]

v_addc_u32 v5, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x38]

v_addc_u32 v255, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x39]

v_addc_u32 v5, vcc, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x38]

v_addc_u32 v5, vcc, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x38]

v_addc_u32 v5, vcc, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x38]

v_addc_u32 v5, vcc, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x38]

v_addc_u32 v5, vcc, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x38]

v_addc_u32 v5, vcc, src_lds_direct, v2, vcc
// CHECK: [0xfe,0x04,0x0a,0x38]

v_addc_u32 v5, vcc, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x38]

v_subb_u32 v5, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x3a]

v_subb_u32 v255, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x3b]

v_subb_u32 v5, vcc, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x3a]

v_subb_u32 v5, vcc, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x3a]

v_subb_u32 v5, vcc, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x3a]

v_subb_u32 v5, vcc, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x3a]

v_subb_u32 v5, vcc, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x3a]

v_subb_u32 v5, vcc, src_lds_direct, v2, vcc
// CHECK: [0xfe,0x04,0x0a,0x3a]

v_subb_u32 v5, vcc, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x3a]

v_subbrev_u32 v5, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x3c]

v_subbrev_u32 v255, vcc, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x3d]

v_subbrev_u32 v5, vcc, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x3c]

v_subbrev_u32 v5, vcc, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x3c]

v_subbrev_u32 v5, vcc, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x3c]

v_subbrev_u32 v5, vcc, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x3c]

v_subbrev_u32 v5, vcc, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x3c]

v_subbrev_u32 v5, vcc, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x3c]

v_add_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3e]

v_add_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3f]

v_add_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3e]

v_add_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3e]

v_add_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x3e]

v_add_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x3e]

v_add_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x3e]

v_add_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3e]

v_add_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3e]

v_add_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3e]

v_add_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3e]

v_add_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3e]

v_add_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3e]

v_add_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3e]

v_add_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3e]

v_add_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3e]

v_add_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3e]

v_add_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3e]

v_add_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3e]

v_add_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3e]

v_add_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3e]

v_add_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x3e]

v_add_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x3e]

v_add_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x3e]

v_add_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x3e]

v_add_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x3e,0x0b,0xfe,0x00,0x00]

v_add_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x3e,0x56,0x34,0x00,0x00]

v_add_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3e]

v_sub_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x40]

v_sub_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x41]

v_sub_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x40]

v_sub_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x40]

v_sub_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x40]

v_sub_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x40]

v_sub_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x40]

v_sub_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x40]

v_sub_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x40]

v_sub_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x40]

v_sub_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x40]

v_sub_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x40]

v_sub_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x40]

v_sub_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x40]

v_sub_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x40]

v_sub_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x40]

v_sub_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x40]

v_sub_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x40]

v_sub_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x40]

v_sub_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x40]

v_sub_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x40]

v_sub_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x40]

v_sub_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x40]

v_sub_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x40]

v_sub_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x40]

v_sub_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x40,0x0b,0xfe,0x00,0x00]

v_sub_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x40,0x56,0x34,0x00,0x00]

v_sub_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x40]

v_subrev_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x42]

v_subrev_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x43]

v_subrev_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x42]

v_subrev_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x42]

v_subrev_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x42]

v_subrev_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x42]

v_subrev_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x42]

v_subrev_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x42]

v_subrev_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x42]

v_subrev_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x42]

v_subrev_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x42]

v_subrev_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x42]

v_subrev_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x42]

v_subrev_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x42]

v_subrev_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x42]

v_subrev_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x42]

v_subrev_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x42]

v_subrev_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x42]

v_subrev_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x42]

v_subrev_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x42]

v_subrev_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x42]

v_subrev_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x42]

v_subrev_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x42]

v_subrev_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x42]

v_subrev_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x42,0x0b,0xfe,0x00,0x00]

v_subrev_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x42,0x56,0x34,0x00,0x00]

v_subrev_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x42]

v_mul_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x44]

v_mul_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x45]

v_mul_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x44]

v_mul_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x44]

v_mul_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x44]

v_mul_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x44]

v_mul_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x44]

v_mul_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x44]

v_mul_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x44]

v_mul_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x44]

v_mul_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x44]

v_mul_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x44]

v_mul_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x44]

v_mul_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x44]

v_mul_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x44]

v_mul_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x44]

v_mul_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x44]

v_mul_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x44]

v_mul_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x44]

v_mul_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x44]

v_mul_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x44]

v_mul_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x44]

v_mul_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x44]

v_mul_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x44]

v_mul_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x44]

v_mul_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x44,0x0b,0xfe,0x00,0x00]

v_mul_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x44,0x56,0x34,0x00,0x00]

v_mul_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x44]

v_mac_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x46]

v_mac_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x47]

v_mac_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x46]

v_mac_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x46]

v_mac_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x46]

v_mac_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x46]

v_mac_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x46]

v_mac_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x46]

v_mac_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x46]

v_mac_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x46]

v_mac_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x46]

v_mac_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x46]

v_mac_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x46]

v_mac_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x46]

v_mac_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x46]

v_mac_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x46]

v_mac_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x46]

v_mac_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x46]

v_mac_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x46]

v_mac_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x46]

v_mac_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x46]

v_mac_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x46]

v_mac_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x46]

v_mac_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x46]

v_mac_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x46]

v_mac_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x46,0x0b,0xfe,0x00,0x00]

v_mac_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x46,0x56,0x34,0x00,0x00]

v_mac_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x46]

v_madmk_f16 v5, v1, 0x1121, v3
// CHECK: [0x01,0x07,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v255, v1, 0x1121, v3
// CHECK: [0x01,0x07,0xfe,0x49,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, v255, 0x1121, v3
// CHECK: [0xff,0x07,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, 0, 0x1121, v3
// CHECK: [0x80,0x06,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, -1, 0x1121, v3
// CHECK: [0xc1,0x06,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, 0.5, 0x1121, v3
// CHECK: [0xf0,0x06,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, -4.0, 0x1121, v3
// CHECK: [0xf7,0x06,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, src_lds_direct, 0x1121, v3
// CHECK: [0xfe,0x06,0x0a,0x48,0x21,0x11,0x00,0x00]

v_madmk_f16 v5, v1, 0xa1b1, v3
// CHECK: [0x01,0x07,0x0a,0x48,0xb1,0xa1,0x00,0x00]

v_madmk_f16 v5, v1, 0x1121, v255
// CHECK: [0x01,0xff,0x0b,0x48,0x21,0x11,0x00,0x00]

v_madak_f16 v5, v1, v2, 0x1121
// CHECK: [0x01,0x05,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v255, v1, v2, 0x1121
// CHECK: [0x01,0x05,0xfe,0x4b,0x21,0x11,0x00,0x00]

v_madak_f16 v5, v255, v2, 0x1121
// CHECK: [0xff,0x05,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, 0, v2, 0x1121
// CHECK: [0x80,0x04,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, -1, v2, 0x1121
// CHECK: [0xc1,0x04,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, 0.5, v2, 0x1121
// CHECK: [0xf0,0x04,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, -4.0, v2, 0x1121
// CHECK: [0xf7,0x04,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, src_lds_direct, v2, 0x1121
// CHECK: [0xfe,0x04,0x0a,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, v1, v255, 0x1121
// CHECK: [0x01,0xff,0x0b,0x4a,0x21,0x11,0x00,0x00]

v_madak_f16 v5, v1, v2, 0xa1b1
// CHECK: [0x01,0x05,0x0a,0x4a,0xb1,0xa1,0x00,0x00]

v_add_u16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4c]

v_add_u16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4d]

v_add_u16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4c]

v_add_u16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4c]

v_add_u16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x4c]

v_add_u16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x4c]

v_add_u16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x4c]

v_add_u16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4c]

v_add_u16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4c]

v_add_u16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4c]

v_add_u16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4c]

v_add_u16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4c]

v_add_u16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4c]

v_add_u16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4c]

v_add_u16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4c]

v_add_u16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4c]

v_add_u16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4c]

v_add_u16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4c]

v_add_u16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4c]

v_add_u16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x00,0x38,0x00,0x00]

v_add_u16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x00,0xc4,0x00,0x00]

v_add_u16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x4c]

v_add_u16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x4c]

v_add_u16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x4c]

v_add_u16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x4c]

v_add_u16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x0b,0xfe,0x00,0x00]

v_add_u16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x56,0x34,0x00,0x00]

v_add_u16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4c]

v_sub_u16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4e]

v_sub_u16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4f]

v_sub_u16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4e]

v_sub_u16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4e]

v_sub_u16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x4e]

v_sub_u16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x4e]

v_sub_u16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x4e]

v_sub_u16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4e]

v_sub_u16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4e]

v_sub_u16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4e]

v_sub_u16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4e]

v_sub_u16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4e]

v_sub_u16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4e]

v_sub_u16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4e]

v_sub_u16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4e]

v_sub_u16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4e]

v_sub_u16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4e]

v_sub_u16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4e]

v_sub_u16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4e]

v_sub_u16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x4e,0x00,0x38,0x00,0x00]

v_sub_u16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x4e,0x00,0xc4,0x00,0x00]

v_sub_u16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x4e]

v_sub_u16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x4e]

v_sub_u16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x4e]

v_sub_u16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x4e]

v_sub_u16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x4e,0x0b,0xfe,0x00,0x00]

v_sub_u16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x4e,0x56,0x34,0x00,0x00]

v_sub_u16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4e]

v_subrev_u16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x50]

v_subrev_u16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x51]

v_subrev_u16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x50]

v_subrev_u16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x50]

v_subrev_u16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x50]

v_subrev_u16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x50]

v_subrev_u16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x50]

v_subrev_u16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x50]

v_subrev_u16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x50]

v_subrev_u16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x50]

v_subrev_u16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x50]

v_subrev_u16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x50]

v_subrev_u16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x50]

v_subrev_u16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x50]

v_subrev_u16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x50]

v_subrev_u16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x50]

v_subrev_u16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x50]

v_subrev_u16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x50]

v_subrev_u16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x50]

v_subrev_u16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x50,0x00,0x38,0x00,0x00]

v_subrev_u16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x50,0x00,0xc4,0x00,0x00]

v_subrev_u16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x50]

v_subrev_u16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x50]

v_subrev_u16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x50]

v_subrev_u16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x50,0x0b,0xfe,0x00,0x00]

v_subrev_u16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x50,0x56,0x34,0x00,0x00]

v_subrev_u16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x50]

v_mul_lo_u16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x52]

v_mul_lo_u16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x53]

v_mul_lo_u16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x52]

v_mul_lo_u16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x52]

v_mul_lo_u16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x52]

v_mul_lo_u16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x52]

v_mul_lo_u16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x52]

v_mul_lo_u16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x52]

v_mul_lo_u16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x52]

v_mul_lo_u16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x52]

v_mul_lo_u16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x52]

v_mul_lo_u16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x52]

v_mul_lo_u16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x52]

v_mul_lo_u16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x52]

v_mul_lo_u16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x52]

v_mul_lo_u16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x52]

v_mul_lo_u16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x52]

v_mul_lo_u16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x52]

v_mul_lo_u16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x52]

v_mul_lo_u16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x52,0x00,0x38,0x00,0x00]

v_mul_lo_u16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x52,0x00,0xc4,0x00,0x00]

v_mul_lo_u16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x52]

v_mul_lo_u16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x52]

v_mul_lo_u16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x52]

v_mul_lo_u16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x52]

v_mul_lo_u16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x52,0x0b,0xfe,0x00,0x00]

v_mul_lo_u16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x52,0x56,0x34,0x00,0x00]

v_mul_lo_u16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x52]

v_lshlrev_b16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x54]

v_lshlrev_b16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x55]

v_lshlrev_b16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x54]

v_lshlrev_b16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x54]

v_lshlrev_b16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x54]

v_lshlrev_b16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x54]

v_lshlrev_b16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x54]

v_lshlrev_b16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x54]

v_lshlrev_b16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x54]

v_lshlrev_b16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x54]

v_lshlrev_b16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x54]

v_lshlrev_b16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x54]

v_lshlrev_b16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x54]

v_lshlrev_b16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x54]

v_lshlrev_b16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x54]

v_lshlrev_b16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x54]

v_lshlrev_b16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x54]

v_lshlrev_b16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x54]

v_lshlrev_b16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x54]

v_lshlrev_b16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x54,0x00,0x38,0x00,0x00]

v_lshlrev_b16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x54,0x00,0xc4,0x00,0x00]

v_lshlrev_b16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x54]

v_lshlrev_b16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x54]

v_lshlrev_b16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x54]

v_lshlrev_b16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x54,0x0b,0xfe,0x00,0x00]

v_lshlrev_b16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x54,0x56,0x34,0x00,0x00]

v_lshlrev_b16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x54]

v_lshrrev_b16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x56]

v_lshrrev_b16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x57]

v_lshrrev_b16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x56]

v_lshrrev_b16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x56]

v_lshrrev_b16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x56]

v_lshrrev_b16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x56]

v_lshrrev_b16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x56]

v_lshrrev_b16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x56]

v_lshrrev_b16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x56]

v_lshrrev_b16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x56]

v_lshrrev_b16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x56]

v_lshrrev_b16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x56]

v_lshrrev_b16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x56]

v_lshrrev_b16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x56]

v_lshrrev_b16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x56]

v_lshrrev_b16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x56]

v_lshrrev_b16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x56]

v_lshrrev_b16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x56]

v_lshrrev_b16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x56]

v_lshrrev_b16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x56,0x00,0x38,0x00,0x00]

v_lshrrev_b16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x56,0x00,0xc4,0x00,0x00]

v_lshrrev_b16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x56]

v_lshrrev_b16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x56]

v_lshrrev_b16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x56]

v_lshrrev_b16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x56,0x0b,0xfe,0x00,0x00]

v_lshrrev_b16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x56,0x56,0x34,0x00,0x00]

v_lshrrev_b16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x56]

v_ashrrev_i16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x58]

v_ashrrev_i16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x59]

v_ashrrev_i16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x58]

v_ashrrev_i16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x58]

v_ashrrev_i16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x58]

v_ashrrev_i16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x58]

v_ashrrev_i16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x58]

v_ashrrev_i16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x58]

v_ashrrev_i16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x58]

v_ashrrev_i16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x58]

v_ashrrev_i16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x58]

v_ashrrev_i16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x58]

v_ashrrev_i16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x58]

v_ashrrev_i16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x58]

v_ashrrev_i16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x58]

v_ashrrev_i16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x58]

v_ashrrev_i16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x58]

v_ashrrev_i16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x58]

v_ashrrev_i16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x58]

v_ashrrev_i16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x58,0x00,0x38,0x00,0x00]

v_ashrrev_i16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x58,0x00,0xc4,0x00,0x00]

v_ashrrev_i16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x58]

v_ashrrev_i16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x58]

v_ashrrev_i16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x58]

v_ashrrev_i16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x58,0x0b,0xfe,0x00,0x00]

v_ashrrev_i16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x58,0x56,0x34,0x00,0x00]

v_ashrrev_i16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x58]

v_max_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x5a]

v_max_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x5b]

v_max_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x5a]

v_max_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x5a]

v_max_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x5a]

v_max_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x5a]

v_max_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x5a]

v_max_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x5a]

v_max_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x5a]

v_max_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x5a]

v_max_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x5a]

v_max_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x5a]

v_max_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x5a]

v_max_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x5a]

v_max_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x5a]

v_max_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x5a]

v_max_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x5a]

v_max_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x5a]

v_max_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x5a]

v_max_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x5a]

v_max_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x5a]

v_max_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x5a]

v_max_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x5a]

v_max_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x5a]

v_max_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x5a]

v_max_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x5a,0x0b,0xfe,0x00,0x00]

v_max_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x5a,0x56,0x34,0x00,0x00]

v_max_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x5a]

v_min_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x5c]

v_min_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x5d]

v_min_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x5c]

v_min_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x5c]

v_min_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x5c]

v_min_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x5c]

v_min_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x5c]

v_min_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x5c]

v_min_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x5c]

v_min_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x5c]

v_min_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x5c]

v_min_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x5c]

v_min_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x5c]

v_min_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x5c]

v_min_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x5c]

v_min_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x5c]

v_min_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x5c]

v_min_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x5c]

v_min_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x5c]

v_min_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x5c]

v_min_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x5c]

v_min_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x5c]

v_min_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x5c]

v_min_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x5c]

v_min_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x5c]

v_min_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x5c,0x0b,0xfe,0x00,0x00]

v_min_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x5c,0x56,0x34,0x00,0x00]

v_min_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x5c]

v_max_u16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x5e]

v_max_u16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x5f]

v_max_u16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x5e]

v_max_u16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x5e]

v_max_u16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x5e]

v_max_u16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x5e]

v_max_u16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x5e]

v_max_u16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x5e]

v_max_u16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x5e]

v_max_u16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x5e]

v_max_u16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x5e]

v_max_u16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x5e]

v_max_u16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x5e]

v_max_u16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x5e]

v_max_u16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x5e]

v_max_u16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x5e]

v_max_u16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x5e]

v_max_u16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x5e]

v_max_u16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x5e]

v_max_u16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x5e,0x00,0x38,0x00,0x00]

v_max_u16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x5e,0x00,0xc4,0x00,0x00]

v_max_u16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x5e]

v_max_u16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x5e]

v_max_u16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x5e]

v_max_u16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x5e]

v_max_u16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x5e,0x0b,0xfe,0x00,0x00]

v_max_u16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x5e,0x56,0x34,0x00,0x00]

v_max_u16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x5e]

v_max_i16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x60]

v_max_i16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x61]

v_max_i16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x60]

v_max_i16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x60]

v_max_i16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x60]

v_max_i16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x60]

v_max_i16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x60]

v_max_i16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x60]

v_max_i16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x60]

v_max_i16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x60]

v_max_i16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x60]

v_max_i16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x60]

v_max_i16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x60]

v_max_i16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x60]

v_max_i16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x60]

v_max_i16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x60]

v_max_i16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x60]

v_max_i16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x60]

v_max_i16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x60]

v_max_i16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x60,0x00,0x38,0x00,0x00]

v_max_i16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x60,0x00,0xc4,0x00,0x00]

v_max_i16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x60]

v_max_i16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x60]

v_max_i16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x60]

v_max_i16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x60]

v_max_i16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x60,0x0b,0xfe,0x00,0x00]

v_max_i16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x60,0x56,0x34,0x00,0x00]

v_max_i16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x60]

v_min_u16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x62]

v_min_u16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x63]

v_min_u16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x62]

v_min_u16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x62]

v_min_u16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x62]

v_min_u16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x62]

v_min_u16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x62]

v_min_u16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x62]

v_min_u16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x62]

v_min_u16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x62]

v_min_u16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x62]

v_min_u16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x62]

v_min_u16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x62]

v_min_u16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x62]

v_min_u16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x62]

v_min_u16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x62]

v_min_u16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x62]

v_min_u16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x62]

v_min_u16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x62]

v_min_u16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x62,0x00,0x38,0x00,0x00]

v_min_u16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x62,0x00,0xc4,0x00,0x00]

v_min_u16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x62]

v_min_u16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x62]

v_min_u16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x62]

v_min_u16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x62]

v_min_u16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x62,0x0b,0xfe,0x00,0x00]

v_min_u16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x62,0x56,0x34,0x00,0x00]

v_min_u16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x62]

v_min_i16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x64]

v_min_i16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x65]

v_min_i16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x64]

v_min_i16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x64]

v_min_i16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x64]

v_min_i16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x64]

v_min_i16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x64]

v_min_i16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x64]

v_min_i16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x64]

v_min_i16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x64]

v_min_i16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x64]

v_min_i16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x64]

v_min_i16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x64]

v_min_i16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x64]

v_min_i16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x64]

v_min_i16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x64]

v_min_i16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x64]

v_min_i16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x64]

v_min_i16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x64]

v_min_i16 v5, 0.5, v2
// CHECK: [0xff,0x04,0x0a,0x64,0x00,0x38,0x00,0x00]

v_min_i16 v5, -4.0, v2
// CHECK: [0xff,0x04,0x0a,0x64,0x00,0xc4,0x00,0x00]

v_min_i16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x64]

v_min_i16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x64]

v_min_i16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x64]

v_min_i16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x64]

v_min_i16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x64,0x0b,0xfe,0x00,0x00]

v_min_i16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x64,0x56,0x34,0x00,0x00]

v_min_i16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x64]

v_ldexp_f16 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x66]

v_ldexp_f16 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x67]

v_ldexp_f16 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x66]

v_ldexp_f16 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x66]

v_ldexp_f16 v5, s101, v2
// CHECK: [0x65,0x04,0x0a,0x66]

v_ldexp_f16 v5, flat_scratch_lo, v2
// CHECK: [0x66,0x04,0x0a,0x66]

v_ldexp_f16 v5, flat_scratch_hi, v2
// CHECK: [0x67,0x04,0x0a,0x66]

v_ldexp_f16 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x66]

v_ldexp_f16 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x66]

v_ldexp_f16 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x66]

v_ldexp_f16 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x66]

v_ldexp_f16 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x66]

v_ldexp_f16 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x66]

v_ldexp_f16 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x66]

v_ldexp_f16 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x66]

v_ldexp_f16 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x66]

v_ldexp_f16 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x66]

v_ldexp_f16 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x66]

v_ldexp_f16 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x66]

v_ldexp_f16 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x66]

v_ldexp_f16 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x66]

v_ldexp_f16 v5, src_vccz, v2
// CHECK: [0xfb,0x04,0x0a,0x66]

v_ldexp_f16 v5, src_execz, v2
// CHECK: [0xfc,0x04,0x0a,0x66]

v_ldexp_f16 v5, src_scc, v2
// CHECK: [0xfd,0x04,0x0a,0x66]

v_ldexp_f16 v5, src_lds_direct, v2
// CHECK: [0xfe,0x04,0x0a,0x66]

v_ldexp_f16 v5, 0xfe0b, v2
// CHECK: [0xff,0x04,0x0a,0x66,0x0b,0xfe,0x00,0x00]

v_ldexp_f16 v5, 0x3456, v2
// CHECK: [0xff,0x04,0x0a,0x66,0x56,0x34,0x00,0x00]

v_ldexp_f16 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x66]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x06]

v_cndmask_b32_sdwa v255, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x01,0x01,0x06,0x06,0x06]

v_cndmask_b32_sdwa v5, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0xff,0x06,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x00,0x01,0x06,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x00,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x01,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x02,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x03,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x04,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x05,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x0e,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x16,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x16,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x00,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x01,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x02,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x03,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x04,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x05,0x06]

v_cndmask_b32_sdwa v5, |v1|, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x26,0x06]

v_cndmask_b32_sdwa v5, -v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x16,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x06]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x00]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x01]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x02]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x03]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x04]

v_cndmask_b32_sdwa v5, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x05]

v_cndmask_b32_sdwa v5, v1, |v2|, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x26]

v_cndmask_b32_sdwa v5, v1, -v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x00,0x01,0x06,0x06,0x16]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x00]

v_cndmask_b32_dpp v255, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x01,0x01,0xe4,0x00,0x00]

v_cndmask_b32_dpp v5, v255, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0xff,0xe4,0x00,0x00]

v_cndmask_b32_dpp v5, v1, v255, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x00,0x01,0xe4,0x00,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x1b,0x00,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x40,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x41,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x42,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x43,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x30,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x34,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x38,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x3c,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x01,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x0f,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x11,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x1f,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x21,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0x2f,0x01,0x00]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x10]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x30]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0xf0]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0xf0]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x01]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x03]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x0f]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x00,0x0f]

v_cndmask_b32_dpp v5, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x08,0x00]

v_cndmask_b32_dpp v5, -v1, |v2|, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x98,0x00]

v_cndmask_b32_dpp v5, |v1|, -v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0x68,0x00]

v_cndmask_b32_dpp v5, -|v1|, -|v2|, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x00,0x01,0xe4,0xf8,0x00]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x03,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0xff,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x02,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x26,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x00,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x01,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x02,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x03,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x04,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x05,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x0e,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x16,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x16,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x00,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x01,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x02,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x03,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x04,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x05,0x06]

v_add_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x16,0x06]

v_add_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x26,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x06]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x00]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x01]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x02]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x03]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x04]

v_add_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x05]

v_add_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x16]

v_add_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x02,0x01,0x06,0x06,0x26]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x00]

v_add_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x03,0x01,0xe4,0x00,0x00]

v_add_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0xff,0xe4,0x00,0x00]

v_add_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x02,0x01,0xe4,0x00,0x00]

v_add_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x1b,0x00,0x00]

v_add_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x40,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x41,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x42,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x43,0x01,0x00]

v_add_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x30,0x01,0x00]

v_add_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x34,0x01,0x00]

v_add_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x38,0x01,0x00]

v_add_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x3c,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x01,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x0f,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x11,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x1f,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x21,0x01,0x00]

v_add_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0x2f,0x01,0x00]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x10]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x30]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0xf0]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0xf0]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x01]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x03]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x0f]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x00,0x0f]

v_add_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x08,0x00]

v_add_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x10,0x00]

v_add_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x20,0x00]

v_add_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x40,0x00]

v_add_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x02,0x01,0xe4,0x80,0x00]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x05,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0xff,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x04,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x26,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x00,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x01,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x02,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x03,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x04,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x05,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x0e,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x16,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x16,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x00,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x01,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x02,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x03,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x04,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x05,0x06]

v_sub_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x16,0x06]

v_sub_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x26,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x06]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x00]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x01]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x02]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x03]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x04]

v_sub_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x05]

v_sub_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x16]

v_sub_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x04,0x01,0x06,0x06,0x26]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x00]

v_sub_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x05,0x01,0xe4,0x00,0x00]

v_sub_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0xff,0xe4,0x00,0x00]

v_sub_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x04,0x01,0xe4,0x00,0x00]

v_sub_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x1b,0x00,0x00]

v_sub_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x40,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x41,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x42,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x43,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x30,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x34,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x38,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x3c,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x01,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x0f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x11,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x1f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x21,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0x2f,0x01,0x00]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x10]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x30]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0xf0]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0xf0]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x01]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x03]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x0f]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x0f]

v_sub_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x08,0x00]

v_sub_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x10,0x00]

v_sub_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x20,0x00]

v_sub_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x40,0x00]

v_sub_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x80,0x00]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x07,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0xff,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x06,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x26,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x00,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x01,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x02,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x03,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x04,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x05,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x0e,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x16,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x16,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x00,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x01,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x02,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x03,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x04,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x05,0x06]

v_subrev_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x16,0x06]

v_subrev_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x26,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x06]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x00]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x01]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x02]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x03]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x04]

v_subrev_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x05]

v_subrev_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x16]

v_subrev_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x06,0x01,0x06,0x06,0x26]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x00]

v_subrev_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x07,0x01,0xe4,0x00,0x00]

v_subrev_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0xff,0xe4,0x00,0x00]

v_subrev_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x06,0x01,0xe4,0x00,0x00]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x1b,0x00,0x00]

v_subrev_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x40,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x41,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x42,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x43,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x30,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x34,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x38,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x3c,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x01,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x0f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x11,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x1f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x21,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0x2f,0x01,0x00]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x10]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x30]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0xf0]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0xf0]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x01]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x03]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x0f]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x00,0x0f]

v_subrev_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x08,0x00]

v_subrev_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x10,0x00]

v_subrev_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x20,0x00]

v_subrev_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x40,0x00]

v_subrev_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x06,0x01,0xe4,0x80,0x00]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x09,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0xff,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x08,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x26,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x00,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x01,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x02,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x03,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x04,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x05,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x0e,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x16,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x16,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x00,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x01,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x02,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x03,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x04,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x05,0x06]

v_mul_legacy_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x16,0x06]

v_mul_legacy_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x26,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x06]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x00]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x01]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x02]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x03]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x04]

v_mul_legacy_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x05]

v_mul_legacy_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x16]

v_mul_legacy_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x08,0x01,0x06,0x06,0x26]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x09,0x01,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0xff,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x08,0x01,0xe4,0x00,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x1b,0x00,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x40,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x41,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x42,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x43,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x30,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x34,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x38,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x3c,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x01,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x0f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x11,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x1f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x21,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0x2f,0x01,0x00]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x10]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x30]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0xf0]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0xf0]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x01]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x03]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x0f]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x00,0x0f]

v_mul_legacy_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x08,0x00]

v_mul_legacy_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x10,0x00]

v_mul_legacy_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x20,0x00]

v_mul_legacy_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x40,0x00]

v_mul_legacy_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x08,0x01,0xe4,0x80,0x00]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x0b,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0xff,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x0a,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x26,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x00,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x01,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x02,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x03,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x04,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x05,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x0e,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x16,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x16,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x00,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x01,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x02,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x03,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x04,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x05,0x06]

v_mul_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x16,0x06]

v_mul_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x26,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x06]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x00]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x01]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x02]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x03]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x04]

v_mul_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x05]

v_mul_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x16]

v_mul_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0a,0x01,0x06,0x06,0x26]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x00]

v_mul_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x0b,0x01,0xe4,0x00,0x00]

v_mul_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0xff,0xe4,0x00,0x00]

v_mul_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x0a,0x01,0xe4,0x00,0x00]

v_mul_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x1b,0x00,0x00]

v_mul_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x40,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x41,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x42,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x43,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x30,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x34,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x38,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x3c,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x01,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x0f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x11,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x1f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x21,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0x2f,0x01,0x00]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x10]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x30]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0xf0]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0xf0]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x01]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x03]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x0f]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x00,0x0f]

v_mul_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x08,0x00]

v_mul_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x10,0x00]

v_mul_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x20,0x00]

v_mul_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x40,0x00]

v_mul_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0a,0x01,0xe4,0x80,0x00]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x0d,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0xff,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x0c,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x26,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x00,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x01,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x02,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x03,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x04,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x05,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x0e,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x16,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x16,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x00,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x01,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x02,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x03,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x04,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x05,0x06]

v_mul_i32_i24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x0e,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x06]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x00]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x01]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x02]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x03]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x04]

v_mul_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x05]

v_mul_i32_i24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0c,0x01,0x06,0x06,0x0e]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x0d,0x01,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0xff,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x0c,0x01,0xe4,0x00,0x00]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x1b,0x00,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x40,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x41,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x42,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x43,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x30,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x34,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x38,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x3c,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x01,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x0f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x11,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x1f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x21,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0x2f,0x01,0x00]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x10]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x30]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0xf0]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0xf0]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x01]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x03]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x0f]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x00,0x0f]

v_mul_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x0c,0x01,0xe4,0x08,0x00]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x0f,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0xff,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x0e,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x00,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x01,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x02,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x03,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x04,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x05,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x0e,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x16,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x16,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x00,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x01,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x02,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x03,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x04,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x05,0x06]

v_mul_hi_i32_i24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x0e,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x06]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x00]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x01]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x02]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x03]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x04]

v_mul_hi_i32_i24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x05]

v_mul_hi_i32_i24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x0e,0x01,0x06,0x06,0x0e]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x0f,0x01,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0xff,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x0e,0x01,0xe4,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x1b,0x00,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x40,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x41,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x42,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x43,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x30,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x34,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x38,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x3c,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x01,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x0f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x11,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x1f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x21,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0x2f,0x01,0x00]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x10]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x30]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0xf0]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0xf0]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x01]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x03]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x0f]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x00,0x0f]

v_mul_hi_i32_i24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x0e,0x01,0xe4,0x08,0x00]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x11,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0xff,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x10,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x26,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x00,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x01,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x02,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x03,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x04,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x05,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x0e,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x16,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x16,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x00,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x01,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x02,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x03,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x04,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x05,0x06]

v_mul_u32_u24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x0e,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x06]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x00]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x01]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x02]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x03]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x04]

v_mul_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x05]

v_mul_u32_u24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x10,0x01,0x06,0x06,0x0e]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x11,0x01,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0xff,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x10,0x01,0xe4,0x00,0x00]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x1b,0x00,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x40,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x41,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x42,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x43,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x30,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x34,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x38,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x3c,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x01,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x0f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x11,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x1f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x21,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0x2f,0x01,0x00]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x10]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x30]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0xf0]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0xf0]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x01]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x03]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x0f]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x00,0x0f]

v_mul_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x10,0x01,0xe4,0x08,0x00]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x13,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0xff,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x12,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x00,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x01,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x02,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x03,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x04,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x05,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x0e,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x16,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x16,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x00,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x01,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x02,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x03,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x04,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x05,0x06]

v_mul_hi_u32_u24_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x0e,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x06]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x00]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x01]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x02]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x03]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x04]

v_mul_hi_u32_u24_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x05]

v_mul_hi_u32_u24_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x12,0x01,0x06,0x06,0x0e]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x13,0x01,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0xff,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x12,0x01,0xe4,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x1b,0x00,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x40,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x41,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x42,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x43,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x30,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x34,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x38,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x3c,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x01,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x0f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x11,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x1f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x21,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0x2f,0x01,0x00]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x10]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x30]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0xf0]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0xf0]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x01]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x03]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x0f]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x00,0x0f]

v_mul_hi_u32_u24_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x12,0x01,0xe4,0x08,0x00]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x15,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0xff,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x14,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x26,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x00,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x01,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x02,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x03,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x04,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x05,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x0e,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x16,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x16,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x00,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x01,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x02,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x03,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x04,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x05,0x06]

v_min_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x16,0x06]

v_min_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x26,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x06]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x00]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x01]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x02]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x03]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x04]

v_min_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x05]

v_min_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x16]

v_min_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x14,0x01,0x06,0x06,0x26]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x00]

v_min_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x15,0x01,0xe4,0x00,0x00]

v_min_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0xff,0xe4,0x00,0x00]

v_min_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x14,0x01,0xe4,0x00,0x00]

v_min_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x1b,0x00,0x00]

v_min_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x40,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x41,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x42,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x43,0x01,0x00]

v_min_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x30,0x01,0x00]

v_min_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x34,0x01,0x00]

v_min_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x38,0x01,0x00]

v_min_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x3c,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x01,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x0f,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x11,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x1f,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x21,0x01,0x00]

v_min_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0x2f,0x01,0x00]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x10]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x30]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0xf0]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0xf0]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x01]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x03]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x0f]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x00,0x0f]

v_min_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x08,0x00]

v_min_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x10,0x00]

v_min_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x20,0x00]

v_min_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x40,0x00]

v_min_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x14,0x01,0xe4,0x80,0x00]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x17,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0xff,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x16,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x26,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x00,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x01,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x02,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x03,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x04,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x05,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x0e,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x16,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x16,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x00,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x01,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x02,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x03,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x04,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x05,0x06]

v_max_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x16,0x06]

v_max_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x26,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x06]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x00]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x01]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x02]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x03]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x04]

v_max_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x05]

v_max_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x16]

v_max_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x16,0x01,0x06,0x06,0x26]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x00]

v_max_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x17,0x01,0xe4,0x00,0x00]

v_max_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0xff,0xe4,0x00,0x00]

v_max_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x16,0x01,0xe4,0x00,0x00]

v_max_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x1b,0x00,0x00]

v_max_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x40,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x41,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x42,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x43,0x01,0x00]

v_max_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x30,0x01,0x00]

v_max_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x34,0x01,0x00]

v_max_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x38,0x01,0x00]

v_max_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x3c,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x01,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x0f,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x11,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x1f,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x21,0x01,0x00]

v_max_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0x2f,0x01,0x00]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x10]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x30]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0xf0]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0xf0]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x01]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x03]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x0f]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x00,0x0f]

v_max_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x08,0x00]

v_max_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x10,0x00]

v_max_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x20,0x00]

v_max_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x40,0x00]

v_max_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x16,0x01,0xe4,0x80,0x00]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x19,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0xff,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x18,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x00,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x01,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x02,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x03,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x04,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x05,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x0e,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x16,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x16,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x00,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x01,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x02,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x03,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x04,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x05,0x06]

v_min_i32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x0e,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x06]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x00]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x01]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x02]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x03]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x04]

v_min_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x05]

v_min_i32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x18,0x01,0x06,0x06,0x0e]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x00]

v_min_i32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x19,0x01,0xe4,0x00,0x00]

v_min_i32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0xff,0xe4,0x00,0x00]

v_min_i32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x18,0x01,0xe4,0x00,0x00]

v_min_i32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x1b,0x00,0x00]

v_min_i32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x40,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x41,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x42,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x43,0x01,0x00]

v_min_i32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x30,0x01,0x00]

v_min_i32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x34,0x01,0x00]

v_min_i32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x38,0x01,0x00]

v_min_i32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x3c,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x01,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x0f,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x11,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x1f,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x21,0x01,0x00]

v_min_i32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0x2f,0x01,0x00]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x10]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x30]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0xf0]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0xf0]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x01]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x03]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x0f]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x00,0x0f]

v_min_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x18,0x01,0xe4,0x08,0x00]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x1b,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0xff,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x1a,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x00,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x01,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x02,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x03,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x04,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x05,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x0e,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x16,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x16,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x00,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x01,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x02,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x03,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x04,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x05,0x06]

v_max_i32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x0e,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x06]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x00]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x01]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x02]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x03]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x04]

v_max_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x05]

v_max_i32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1a,0x01,0x06,0x06,0x0e]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x00]

v_max_i32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x1b,0x01,0xe4,0x00,0x00]

v_max_i32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0xff,0xe4,0x00,0x00]

v_max_i32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x1a,0x01,0xe4,0x00,0x00]

v_max_i32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x1b,0x00,0x00]

v_max_i32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x40,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x41,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x42,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x43,0x01,0x00]

v_max_i32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x30,0x01,0x00]

v_max_i32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x34,0x01,0x00]

v_max_i32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x38,0x01,0x00]

v_max_i32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x3c,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x01,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x0f,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x11,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x1f,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x21,0x01,0x00]

v_max_i32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0x2f,0x01,0x00]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x10]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x30]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0xf0]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0xf0]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x01]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x03]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x0f]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x0f]

v_max_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x08,0x00]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x1d,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0xff,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x1c,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x00,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x01,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x02,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x03,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x04,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x05,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x0e,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x16,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x16,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x00,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x01,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x02,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x03,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x04,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x05,0x06]

v_min_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x0e,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x06]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x00]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x01]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x02]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x03]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x04]

v_min_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x05]

v_min_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1c,0x01,0x06,0x06,0x0e]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x00]

v_min_u32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x1d,0x01,0xe4,0x00,0x00]

v_min_u32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0xff,0xe4,0x00,0x00]

v_min_u32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x1c,0x01,0xe4,0x00,0x00]

v_min_u32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x1b,0x00,0x00]

v_min_u32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x40,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x41,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x42,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x43,0x01,0x00]

v_min_u32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x30,0x01,0x00]

v_min_u32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x34,0x01,0x00]

v_min_u32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x38,0x01,0x00]

v_min_u32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x3c,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x01,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x0f,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x11,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x1f,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x21,0x01,0x00]

v_min_u32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0x2f,0x01,0x00]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x10]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x30]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0xf0]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0xf0]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x01]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x03]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x0f]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x00,0x0f]

v_min_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x1c,0x01,0xe4,0x08,0x00]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x1f,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0xff,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x1e,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x00,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x01,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x02,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x03,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x04,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x05,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x0e,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x16,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x16,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x00,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x01,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x02,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x03,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x04,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x05,0x06]

v_max_u32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x0e,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x06]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x00]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x01]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x02]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x03]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x04]

v_max_u32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x05]

v_max_u32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x1e,0x01,0x06,0x06,0x0e]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x00]

v_max_u32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x1f,0x01,0xe4,0x00,0x00]

v_max_u32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0xff,0xe4,0x00,0x00]

v_max_u32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x1e,0x01,0xe4,0x00,0x00]

v_max_u32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x1b,0x00,0x00]

v_max_u32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x40,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x41,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x42,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x43,0x01,0x00]

v_max_u32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x30,0x01,0x00]

v_max_u32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x34,0x01,0x00]

v_max_u32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x38,0x01,0x00]

v_max_u32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x3c,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x01,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x0f,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x11,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x1f,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x21,0x01,0x00]

v_max_u32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0x2f,0x01,0x00]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x10]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x30]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0xf0]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0xf0]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x01]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x03]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x0f]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x00,0x0f]

v_max_u32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x1e,0x01,0xe4,0x08,0x00]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x21,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0xff,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x20,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x00,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x01,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x02,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x03,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x04,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x05,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x0e,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x16,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x16,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x00,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x01,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x02,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x03,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x04,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x05,0x06]

v_lshrrev_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x0e,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x06]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x00]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x01]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x02]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x03]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x04]

v_lshrrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x05]

v_lshrrev_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x20,0x01,0x06,0x06,0x0e]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x21,0x01,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0xff,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x20,0x01,0xe4,0x00,0x00]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x1b,0x00,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x40,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x41,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x42,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x43,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x30,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x34,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x38,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x3c,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x01,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x0f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x11,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x1f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x21,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0x2f,0x01,0x00]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x10]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x30]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0xf0]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0xf0]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x01]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x03]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x0f]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x00,0x0f]

v_lshrrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x20,0x01,0xe4,0x08,0x00]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x23,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0xff,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x22,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x00,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x01,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x02,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x03,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x04,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x05,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x0e,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x16,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x16,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x00,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x01,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x02,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x03,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x04,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x05,0x06]

v_ashrrev_i32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x0e,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x06]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x00]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x01]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x02]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x03]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x04]

v_ashrrev_i32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x05]

v_ashrrev_i32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x22,0x01,0x06,0x06,0x0e]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x23,0x01,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0xff,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x22,0x01,0xe4,0x00,0x00]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x1b,0x00,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x40,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x41,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x42,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x43,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x30,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x34,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x38,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x3c,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x01,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x0f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x11,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x1f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x21,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0x2f,0x01,0x00]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x10]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x30]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0xf0]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0xf0]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x01]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x03]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x0f]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x00,0x0f]

v_ashrrev_i32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x22,0x01,0xe4,0x08,0x00]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x25,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0xff,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x24,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x00,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x01,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x02,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x03,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x04,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x05,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x0e,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x16,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x16,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x00,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x01,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x02,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x03,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x04,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x05,0x06]

v_lshlrev_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x0e,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x06]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x00]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x01]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x02]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x03]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x04]

v_lshlrev_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x05]

v_lshlrev_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x24,0x01,0x06,0x06,0x0e]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x25,0x01,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0xff,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x24,0x01,0xe4,0x00,0x00]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x1b,0x00,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x40,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x41,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x42,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x43,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x30,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x34,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x38,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x3c,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x01,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x0f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x11,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x1f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x21,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0x2f,0x01,0x00]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x10]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x30]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0xf0]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0xf0]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x01]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x03]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x0f]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x00,0x0f]

v_lshlrev_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x24,0x01,0xe4,0x08,0x00]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x27,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0xff,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x26,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x00,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x01,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x02,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x03,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x04,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x05,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x0e,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x16,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x16,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x00,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x01,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x02,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x03,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x04,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x05,0x06]

v_and_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x0e,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x06]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x00]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x01]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x02]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x03]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x04]

v_and_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x05]

v_and_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x26,0x01,0x06,0x06,0x0e]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x00]

v_and_b32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x27,0x01,0xe4,0x00,0x00]

v_and_b32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0xff,0xe4,0x00,0x00]

v_and_b32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x26,0x01,0xe4,0x00,0x00]

v_and_b32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x1b,0x00,0x00]

v_and_b32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x40,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x41,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x42,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x43,0x01,0x00]

v_and_b32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x30,0x01,0x00]

v_and_b32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x34,0x01,0x00]

v_and_b32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x38,0x01,0x00]

v_and_b32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x3c,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x01,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x0f,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x11,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x1f,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x21,0x01,0x00]

v_and_b32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0x2f,0x01,0x00]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x10]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x30]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0xf0]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0xf0]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x01]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x03]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x0f]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x00,0x0f]

v_and_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x26,0x01,0xe4,0x08,0x00]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x29,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0xff,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x28,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x00,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x01,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x02,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x03,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x04,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x05,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x0e,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x16,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x16,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x00,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x01,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x02,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x03,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x04,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x05,0x06]

v_or_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x0e,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x06]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x00]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x01]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x02]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x03]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x04]

v_or_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x05]

v_or_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x28,0x01,0x06,0x06,0x0e]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x00]

v_or_b32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x29,0x01,0xe4,0x00,0x00]

v_or_b32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0xff,0xe4,0x00,0x00]

v_or_b32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x28,0x01,0xe4,0x00,0x00]

v_or_b32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x1b,0x00,0x00]

v_or_b32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x40,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x41,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x42,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x43,0x01,0x00]

v_or_b32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x30,0x01,0x00]

v_or_b32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x34,0x01,0x00]

v_or_b32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x38,0x01,0x00]

v_or_b32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x3c,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x01,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x0f,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x11,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x1f,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x21,0x01,0x00]

v_or_b32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0x2f,0x01,0x00]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x10]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x30]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0xf0]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0xf0]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x01]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x03]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x0f]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x00,0x0f]

v_or_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x28,0x01,0xe4,0x08,0x00]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x2b,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0xff,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x2a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x00,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x01,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x02,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x03,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x04,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x05,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x0e,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x16,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x16,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x00,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x01,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x02,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x03,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x04,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x05,0x06]

v_xor_b32_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x0e,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x06]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x00]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x01]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x02]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x03]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x04]

v_xor_b32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x05]

v_xor_b32_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2a,0x01,0x06,0x06,0x0e]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x00]

v_xor_b32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x2b,0x01,0xe4,0x00,0x00]

v_xor_b32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0xff,0xe4,0x00,0x00]

v_xor_b32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x2a,0x01,0xe4,0x00,0x00]

v_xor_b32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x1b,0x00,0x00]

v_xor_b32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x40,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x41,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x42,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x43,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x30,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x34,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x38,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x3c,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x01,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x0f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x11,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x1f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x21,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0x2f,0x01,0x00]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x10]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x30]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0xf0]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0xf0]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x01]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x03]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x0f]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x00,0x0f]

v_xor_b32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x2a,0x01,0xe4,0x08,0x00]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_mac_f32_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x2d,0x01,0x06,0x06,0x06]

v_mac_f32_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0xff,0x06,0x06,0x06]

v_mac_f32_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x2c,0x01,0x06,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x26,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x0e,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x16,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x16,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x00,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x01,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x02,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x03,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x04,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x05,0x06]

v_mac_f32_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x16,0x06]

v_mac_f32_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x26,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x06]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x00]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x01]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x02]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x03]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x04]

v_mac_f32_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x05]

v_mac_f32_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x16]

v_mac_f32_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x2c,0x01,0x06,0x06,0x26]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x00]

v_mac_f32_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x2d,0x01,0xe4,0x00,0x00]

v_mac_f32_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0xff,0xe4,0x00,0x00]

v_mac_f32_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x2c,0x01,0xe4,0x00,0x00]

v_mac_f32_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x1b,0x00,0x00]

v_mac_f32_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x40,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x41,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x42,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x43,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x30,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x34,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x38,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x3c,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x01,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x0f,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x11,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x1f,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x21,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0x2f,0x01,0x00]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x10]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x30]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0xf0]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0xf0]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x01]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x03]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x0f]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x0f]

v_mac_f32_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x08,0x00]

v_mac_f32_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x10,0x00]

v_mac_f32_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x20,0x00]

v_mac_f32_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x40,0x00]

v_mac_f32_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x80,0x00]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x06]

v_add_u32_sdwa v255, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x33,0x01,0x06,0x06,0x06]

v_add_u32_sdwa v5, vcc, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0xff,0x06,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x32,0x01,0x06,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x26,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x00,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x01,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x02,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x03,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x04,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x05,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x0e,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x16,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x16,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x00,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x01,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x02,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x03,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x04,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x05,0x06]

v_add_u32_sdwa v5, vcc, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x0e,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x06]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x00]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x01]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x02]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x03]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x04]

v_add_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x05]

v_add_u32_sdwa v5, vcc, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x32,0x01,0x06,0x06,0x0e]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x00]

v_add_u32_dpp v255, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x33,0x01,0xe4,0x00,0x00]

v_add_u32_dpp v5, vcc, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0xff,0xe4,0x00,0x00]

v_add_u32_dpp v5, vcc, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x32,0x01,0xe4,0x00,0x00]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x1b,0x00,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x40,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x41,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x42,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x43,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x30,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x34,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x38,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x3c,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x01,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x0f,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x11,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x1f,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x21,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0x2f,0x01,0x00]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x10]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x30]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0xf0]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0xf0]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x01]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x03]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x0f]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x00,0x0f]

v_add_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x32,0x01,0xe4,0x08,0x00]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_sub_u32_sdwa v255, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x35,0x01,0x06,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0xff,0x06,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x34,0x01,0x06,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x26,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x00,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x01,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x02,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x03,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x04,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x05,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x0e,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x16,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x16,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x00,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x01,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x02,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x03,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x04,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x05,0x06]

v_sub_u32_sdwa v5, vcc, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x0e,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x06]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x00]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x01]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x02]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x03]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x04]

v_sub_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x05]

v_sub_u32_sdwa v5, vcc, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x34,0x01,0x06,0x06,0x0e]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x00]

v_sub_u32_dpp v255, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x35,0x01,0xe4,0x00,0x00]

v_sub_u32_dpp v5, vcc, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0xff,0xe4,0x00,0x00]

v_sub_u32_dpp v5, vcc, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x34,0x01,0xe4,0x00,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x1b,0x00,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x40,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x41,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x42,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x43,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x30,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x34,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x38,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x3c,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x01,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x0f,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x11,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x1f,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x21,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0x2f,0x01,0x00]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x10]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x30]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0xf0]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0xf0]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x01]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x03]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x0f]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x00,0x0f]

v_sub_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x34,0x01,0xe4,0x08,0x00]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_subrev_u32_sdwa v255, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x37,0x01,0x06,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0xff,0x06,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x36,0x01,0x06,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x26,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x00,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x01,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x02,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x03,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x04,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x05,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x0e,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x16,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x16,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x00,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x01,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x02,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x03,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x04,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x05,0x06]

v_subrev_u32_sdwa v5, vcc, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x0e,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x06]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x00]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x01]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x02]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x03]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x04]

v_subrev_u32_sdwa v5, vcc, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x05]

v_subrev_u32_sdwa v5, vcc, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x36,0x01,0x06,0x06,0x0e]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x00]

v_subrev_u32_dpp v255, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x37,0x01,0xe4,0x00,0x00]

v_subrev_u32_dpp v5, vcc, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0xff,0xe4,0x00,0x00]

v_subrev_u32_dpp v5, vcc, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x36,0x01,0xe4,0x00,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x1b,0x00,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x40,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x41,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x42,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x43,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x30,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x34,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x38,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x3c,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x01,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x0f,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x11,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x1f,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x21,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0x2f,0x01,0x00]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x10]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x30]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0xf0]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0xf0]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x01]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x03]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x0f]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x00,0x0f]

v_subrev_u32_dpp v5, vcc, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x36,0x01,0xe4,0x08,0x00]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_addc_u32_sdwa v255, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x39,0x01,0x06,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0xff,0x06,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x38,0x01,0x06,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x26,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x00,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x01,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x02,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x03,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x04,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x05,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x0e,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x16,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x16,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x00,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x01,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x02,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x03,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x04,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x05,0x06]

v_addc_u32_sdwa v5, vcc, sext(v1), v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x0e,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x06]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x00]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x01]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x02]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x03]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x04]

v_addc_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x05]

v_addc_u32_sdwa v5, vcc, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x38,0x01,0x06,0x06,0x0e]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x00]

v_addc_u32_dpp v255, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x39,0x01,0xe4,0x00,0x00]

v_addc_u32_dpp v5, vcc, v255, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0xff,0xe4,0x00,0x00]

v_addc_u32_dpp v5, vcc, v1, v255, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x38,0x01,0xe4,0x00,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x1b,0x00,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x40,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x41,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x42,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x43,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x30,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x34,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x38,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x3c,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x01,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x0f,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x11,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x1f,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x21,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0x2f,0x01,0x00]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x10]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x30]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0xf0]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0xf0]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x01]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x03]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x0f]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x00,0x0f]

v_addc_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x38,0x01,0xe4,0x08,0x00]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_subb_u32_sdwa v255, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x3b,0x01,0x06,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0xff,0x06,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x3a,0x01,0x06,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x26,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x00,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x01,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x02,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x03,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x04,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x05,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x0e,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x16,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x16,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x00,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x01,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x02,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x03,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x04,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x05,0x06]

v_subb_u32_sdwa v5, vcc, sext(v1), v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x0e,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x06]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x00]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x01]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x02]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x03]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x04]

v_subb_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x05]

v_subb_u32_sdwa v5, vcc, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3a,0x01,0x06,0x06,0x0e]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x00]

v_subb_u32_dpp v255, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x3b,0x01,0xe4,0x00,0x00]

v_subb_u32_dpp v5, vcc, v255, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0xff,0xe4,0x00,0x00]

v_subb_u32_dpp v5, vcc, v1, v255, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x3a,0x01,0xe4,0x00,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x1b,0x00,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x40,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x41,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x42,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x43,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x30,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x34,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x38,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x3c,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x01,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x0f,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x11,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x1f,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x21,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0x2f,0x01,0x00]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x10]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x30]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0xf0]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0xf0]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x01]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x03]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x0f]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x00,0x0f]

v_subb_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x3a,0x01,0xe4,0x08,0x00]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_subbrev_u32_sdwa v255, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x3d,0x01,0x06,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v255, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0xff,0x06,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v255, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x3c,0x01,0x06,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x26,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x00,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x01,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x02,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x03,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x04,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x05,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x0e,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x16,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x16,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x00,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x01,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x02,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x03,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x04,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x05,0x06]

v_subbrev_u32_sdwa v5, vcc, sext(v1), v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x0e,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x06]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x00]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x01]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x02]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x03]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x04]

v_subbrev_u32_sdwa v5, vcc, v1, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x05]

v_subbrev_u32_sdwa v5, vcc, v1, sext(v2), vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3c,0x01,0x06,0x06,0x0e]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x00]

v_subbrev_u32_dpp v255, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x3d,0x01,0xe4,0x00,0x00]

v_subbrev_u32_dpp v5, vcc, v255, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0xff,0xe4,0x00,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v255, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x3c,0x01,0xe4,0x00,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x1b,0x00,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x40,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x41,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x42,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x43,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x30,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x34,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x38,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x3c,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x01,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x0f,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x11,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x1f,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x21,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0x2f,0x01,0x00]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x10]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x30]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0xf0]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0xf0]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x01]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x03]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x0f]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x00,0x0f]

v_subbrev_u32_dpp v5, vcc, v1, v2, vcc quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x3c,0x01,0xe4,0x08,0x00]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x3f,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0xff,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x3e,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x26,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x00,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x01,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x02,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x03,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x04,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x05,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x0e,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x16,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x16,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x00,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x01,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x02,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x03,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x04,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x05,0x06]

v_add_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x16,0x06]

v_add_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x26,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x06]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x00]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x01]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x02]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x03]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x04]

v_add_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x05]

v_add_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x16]

v_add_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x3e,0x01,0x06,0x06,0x26]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x00]

v_add_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x3f,0x01,0xe4,0x00,0x00]

v_add_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0xff,0xe4,0x00,0x00]

v_add_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x3e,0x01,0xe4,0x00,0x00]

v_add_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x1b,0x00,0x00]

v_add_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x40,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x41,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x42,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x43,0x01,0x00]

v_add_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x30,0x01,0x00]

v_add_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x34,0x01,0x00]

v_add_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x38,0x01,0x00]

v_add_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x3c,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x01,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x0f,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x11,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x1f,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x21,0x01,0x00]

v_add_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0x2f,0x01,0x00]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x10]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x30]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0xf0]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0xf0]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x01]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x03]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x0f]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x00,0x0f]

v_add_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x08,0x00]

v_add_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x10,0x00]

v_add_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x20,0x00]

v_add_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x40,0x00]

v_add_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x3e,0x01,0xe4,0x80,0x00]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x41,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0xff,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x40,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x26,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x00,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x01,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x02,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x03,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x04,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x05,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x0e,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x16,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x16,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x00,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x01,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x02,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x03,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x04,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x05,0x06]

v_sub_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x16,0x06]

v_sub_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x26,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x06]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x00]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x01]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x02]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x03]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x04]

v_sub_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x05]

v_sub_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x16]

v_sub_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x40,0x01,0x06,0x06,0x26]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x00]

v_sub_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x41,0x01,0xe4,0x00,0x00]

v_sub_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0xff,0xe4,0x00,0x00]

v_sub_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x40,0x01,0xe4,0x00,0x00]

v_sub_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x1b,0x00,0x00]

v_sub_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x40,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x41,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x42,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x43,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x30,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x34,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x38,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x3c,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x01,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x0f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x11,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x1f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x21,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0x2f,0x01,0x00]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x10]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x30]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0xf0]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0xf0]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x01]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x03]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x0f]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x00,0x0f]

v_sub_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x08,0x00]

v_sub_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x10,0x00]

v_sub_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x20,0x00]

v_sub_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x40,0x00]

v_sub_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x40,0x01,0xe4,0x80,0x00]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x43,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0xff,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x42,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x26,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x00,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x01,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x02,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x03,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x04,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x05,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x0e,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x16,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x16,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x00,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x01,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x02,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x03,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x04,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x05,0x06]

v_subrev_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x16,0x06]

v_subrev_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x26,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x06]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x00]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x01]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x02]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x03]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x04]

v_subrev_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x05]

v_subrev_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x16]

v_subrev_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x42,0x01,0x06,0x06,0x26]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x00]

v_subrev_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x43,0x01,0xe4,0x00,0x00]

v_subrev_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0xff,0xe4,0x00,0x00]

v_subrev_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x42,0x01,0xe4,0x00,0x00]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x1b,0x00,0x00]

v_subrev_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x40,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x41,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x42,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x43,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x30,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x34,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x38,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x3c,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x01,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x0f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x11,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x1f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x21,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0x2f,0x01,0x00]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x10]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x30]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0xf0]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0xf0]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x01]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x03]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x0f]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x00,0x0f]

v_subrev_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x08,0x00]

v_subrev_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x10,0x00]

v_subrev_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x20,0x00]

v_subrev_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x40,0x00]

v_subrev_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x42,0x01,0xe4,0x80,0x00]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x45,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0xff,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x44,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x26,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x00,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x01,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x02,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x03,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x04,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x05,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x0e,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x16,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x16,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x00,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x01,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x02,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x03,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x04,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x05,0x06]

v_mul_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x16,0x06]

v_mul_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x26,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x06]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x00]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x01]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x02]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x03]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x04]

v_mul_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x05]

v_mul_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x16]

v_mul_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x44,0x01,0x06,0x06,0x26]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x00]

v_mul_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x45,0x01,0xe4,0x00,0x00]

v_mul_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0xff,0xe4,0x00,0x00]

v_mul_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x44,0x01,0xe4,0x00,0x00]

v_mul_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x1b,0x00,0x00]

v_mul_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x40,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x41,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x42,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x43,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x30,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x34,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x38,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x3c,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x01,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x0f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x11,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x1f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x21,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0x2f,0x01,0x00]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x10]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x30]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0xf0]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0xf0]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x01]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x03]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x0f]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x00,0x0f]

v_mul_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x08,0x00]

v_mul_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x10,0x00]

v_mul_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x20,0x00]

v_mul_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x40,0x00]

v_mul_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x44,0x01,0xe4,0x80,0x00]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x06]

v_mac_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x47,0x01,0x06,0x06,0x06]

v_mac_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0xff,0x06,0x06,0x06]

v_mac_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x46,0x01,0x06,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x26,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x0e,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x16,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x16,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x00,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x01,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x02,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x03,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x04,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x05,0x06]

v_mac_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x16,0x06]

v_mac_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x26,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x06]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x00]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x01]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x02]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x03]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x04]

v_mac_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x05]

v_mac_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x16]

v_mac_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x46,0x01,0x06,0x06,0x26]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x00]

v_mac_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x47,0x01,0xe4,0x00,0x00]

v_mac_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0xff,0xe4,0x00,0x00]

v_mac_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x46,0x01,0xe4,0x00,0x00]

v_mac_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x1b,0x00,0x00]

v_mac_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x40,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x41,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x42,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x43,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x30,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x34,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x38,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x3c,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x01,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x0f,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x11,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x1f,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x21,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0x2f,0x01,0x00]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x10]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x30]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0xf0]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0xf0]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x01]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x03]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x0f]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x00,0x0f]

v_mac_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x08,0x00]

v_mac_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x10,0x00]

v_mac_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x20,0x00]

v_mac_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x40,0x00]

v_mac_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x46,0x01,0xe4,0x80,0x00]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_add_u16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x4d,0x01,0x06,0x06,0x06]

v_add_u16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0xff,0x06,0x06,0x06]

v_add_u16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x4c,0x01,0x06,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x26,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x00,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x01,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x02,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x03,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x04,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x05,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x0e,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x16,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x16,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x00,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x01,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x02,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x03,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x04,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x05,0x06]

v_add_u16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x0e,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x06]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x00]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x01]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x02]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x03]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x04]

v_add_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x05]

v_add_u16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4c,0x01,0x06,0x06,0x0e]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x00]

v_add_u16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x4d,0x01,0xe4,0x00,0x00]

v_add_u16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0xff,0xe4,0x00,0x00]

v_add_u16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x4c,0x01,0xe4,0x00,0x00]

v_add_u16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x1b,0x00,0x00]

v_add_u16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x40,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x41,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x42,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x43,0x01,0x00]

v_add_u16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x30,0x01,0x00]

v_add_u16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x34,0x01,0x00]

v_add_u16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x38,0x01,0x00]

v_add_u16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x3c,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x01,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x0f,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x11,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x1f,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x21,0x01,0x00]

v_add_u16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0x2f,0x01,0x00]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x10]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x30]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0xf0]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0xf0]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x01]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x03]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x0f]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x00,0x0f]

v_add_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x4c,0x01,0xe4,0x08,0x00]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_sub_u16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x4f,0x01,0x06,0x06,0x06]

v_sub_u16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0xff,0x06,0x06,0x06]

v_sub_u16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x4e,0x01,0x06,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x26,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x00,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x01,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x02,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x03,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x04,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x05,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x0e,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x16,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x16,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x00,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x01,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x02,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x03,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x04,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x05,0x06]

v_sub_u16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x0e,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x06]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x00]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x01]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x02]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x03]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x04]

v_sub_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x05]

v_sub_u16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x4e,0x01,0x06,0x06,0x0e]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x00]

v_sub_u16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x4f,0x01,0xe4,0x00,0x00]

v_sub_u16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0xff,0xe4,0x00,0x00]

v_sub_u16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x4e,0x01,0xe4,0x00,0x00]

v_sub_u16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x1b,0x00,0x00]

v_sub_u16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x40,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x41,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x42,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x43,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x30,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x34,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x38,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x3c,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x01,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x0f,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x11,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x1f,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x21,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0x2f,0x01,0x00]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x10]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x30]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0xf0]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0xf0]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x01]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x03]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x0f]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x00,0x0f]

v_sub_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x4e,0x01,0xe4,0x08,0x00]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]

v_subrev_u16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x51,0x01,0x06,0x06,0x06]

v_subrev_u16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0xff,0x06,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x50,0x01,0x06,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x26,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x00,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x01,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x02,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x03,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x04,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x05,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x0e,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x16,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x16,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x00,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x01,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x02,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x03,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x04,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x05,0x06]

v_subrev_u16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x0e,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x06]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x00]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x01]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x02]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x03]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x04]

v_subrev_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x05]

v_subrev_u16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x50,0x01,0x06,0x06,0x0e]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x00]

v_subrev_u16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x51,0x01,0xe4,0x00,0x00]

v_subrev_u16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0xff,0xe4,0x00,0x00]

v_subrev_u16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x50,0x01,0xe4,0x00,0x00]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x1b,0x00,0x00]

v_subrev_u16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x40,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x41,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x42,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x43,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x30,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x34,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x38,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x3c,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x01,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x0f,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x11,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x1f,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x21,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0x2f,0x01,0x00]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x10]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x30]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0xf0]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0xf0]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x01]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x03]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x0f]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x00,0x0f]

v_subrev_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x50,0x01,0xe4,0x08,0x00]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x53,0x01,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0xff,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x52,0x01,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x00,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x01,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x02,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x03,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x04,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x05,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x0e,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x16,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x16,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x00,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x01,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x02,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x03,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x04,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x05,0x06]

v_mul_lo_u16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x0e,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x06]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x00]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x01]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x02]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x03]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x04]

v_mul_lo_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x05]

v_mul_lo_u16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x52,0x01,0x06,0x06,0x0e]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x00]

v_mul_lo_u16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x53,0x01,0xe4,0x00,0x00]

v_mul_lo_u16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0xff,0xe4,0x00,0x00]

v_mul_lo_u16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x52,0x01,0xe4,0x00,0x00]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x1b,0x00,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x40,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x41,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x42,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x43,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x30,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x34,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x38,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x3c,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x01,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x0f,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x11,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x1f,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x21,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0x2f,0x01,0x00]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x10]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x30]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0xf0]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0xf0]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x01]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x03]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x0f]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x00,0x0f]

v_mul_lo_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x52,0x01,0xe4,0x08,0x00]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x55,0x01,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0xff,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x54,0x01,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x00,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x01,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x02,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x03,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x04,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x05,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x0e,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x16,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x16,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x00,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x01,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x02,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x03,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x04,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x05,0x06]

v_lshlrev_b16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x0e,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x06]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x00]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x01]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x02]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x03]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x04]

v_lshlrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x05]

v_lshlrev_b16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x54,0x01,0x06,0x06,0x0e]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x00]

v_lshlrev_b16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x55,0x01,0xe4,0x00,0x00]

v_lshlrev_b16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0xff,0xe4,0x00,0x00]

v_lshlrev_b16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x54,0x01,0xe4,0x00,0x00]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x1b,0x00,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x40,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x41,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x42,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x43,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x30,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x34,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x38,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x3c,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x01,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x0f,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x11,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x1f,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x21,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0x2f,0x01,0x00]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x10]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x30]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0xf0]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0xf0]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x01]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x03]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x0f]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x00,0x0f]

v_lshlrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x54,0x01,0xe4,0x08,0x00]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x57,0x01,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0xff,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x56,0x01,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x00,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x01,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x02,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x03,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x04,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x05,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x0e,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x16,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x16,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x00,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x01,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x02,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x03,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x04,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x05,0x06]

v_lshrrev_b16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x0e,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x06]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x00]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x01]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x02]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x03]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x04]

v_lshrrev_b16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x05]

v_lshrrev_b16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x56,0x01,0x06,0x06,0x0e]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x00]

v_lshrrev_b16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x57,0x01,0xe4,0x00,0x00]

v_lshrrev_b16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0xff,0xe4,0x00,0x00]

v_lshrrev_b16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x56,0x01,0xe4,0x00,0x00]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x1b,0x00,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x40,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x41,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x42,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x43,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x30,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x34,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x38,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x3c,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x01,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x0f,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x11,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x1f,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x21,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0x2f,0x01,0x00]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x10]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x30]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0xf0]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0xf0]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x01]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x03]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x0f]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x00,0x0f]

v_lshrrev_b16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x56,0x01,0xe4,0x08,0x00]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x59,0x01,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0xff,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x58,0x01,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x00,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x01,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x02,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x03,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x04,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x05,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x0e,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x16,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x16,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x00,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x01,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x02,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x03,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x04,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x05,0x06]

v_ashrrev_i16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x0e,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x06]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x00]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x01]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x02]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x03]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x04]

v_ashrrev_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x05]

v_ashrrev_i16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x58,0x01,0x06,0x06,0x0e]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x00]

v_ashrrev_i16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x59,0x01,0xe4,0x00,0x00]

v_ashrrev_i16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0xff,0xe4,0x00,0x00]

v_ashrrev_i16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x58,0x01,0xe4,0x00,0x00]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x1b,0x00,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x40,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x41,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x42,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x43,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x30,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x34,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x38,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x3c,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x01,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x0f,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x11,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x1f,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x21,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0x2f,0x01,0x00]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x10]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x30]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0xf0]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0xf0]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x01]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x03]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x0f]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x00,0x0f]

v_ashrrev_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x58,0x01,0xe4,0x08,0x00]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x5b,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0xff,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x5a,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x26,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x00,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x01,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x02,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x03,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x04,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x05,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x0e,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x16,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x16,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x00,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x01,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x02,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x03,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x04,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x05,0x06]

v_max_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x16,0x06]

v_max_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x26,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x06]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x00]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x01]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x02]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x03]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x04]

v_max_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x05]

v_max_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x16]

v_max_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5a,0x01,0x06,0x06,0x26]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x00]

v_max_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x5b,0x01,0xe4,0x00,0x00]

v_max_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0xff,0xe4,0x00,0x00]

v_max_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x5a,0x01,0xe4,0x00,0x00]

v_max_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x1b,0x00,0x00]

v_max_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x40,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x41,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x42,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x43,0x01,0x00]

v_max_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x30,0x01,0x00]

v_max_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x34,0x01,0x00]

v_max_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x38,0x01,0x00]

v_max_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x3c,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x01,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x0f,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x11,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x1f,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x21,0x01,0x00]

v_max_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0x2f,0x01,0x00]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x10]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x30]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0xf0]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0xf0]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x01]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x03]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x0f]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x00,0x0f]

v_max_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x08,0x00]

v_max_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x10,0x00]

v_max_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x20,0x00]

v_max_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x40,0x00]

v_max_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5a,0x01,0xe4,0x80,0x00]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x5d,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0xff,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x5c,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x26,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x00,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x01,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x02,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x03,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x04,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x05,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x0e,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x16,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x16,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x00,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x01,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x02,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x03,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x04,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x05,0x06]

v_min_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x16,0x06]

v_min_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x26,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x06]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x00]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x01]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x02]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x03]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x04]

v_min_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x05]

v_min_f16_sdwa v5, v1, -v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x16]

v_min_f16_sdwa v5, v1, |v2| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5c,0x01,0x06,0x06,0x26]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x00]

v_min_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x5d,0x01,0xe4,0x00,0x00]

v_min_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0xff,0xe4,0x00,0x00]

v_min_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x5c,0x01,0xe4,0x00,0x00]

v_min_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x1b,0x00,0x00]

v_min_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x40,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x41,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x42,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x43,0x01,0x00]

v_min_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x30,0x01,0x00]

v_min_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x34,0x01,0x00]

v_min_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x38,0x01,0x00]

v_min_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x3c,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x01,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x0f,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x11,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x1f,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x21,0x01,0x00]

v_min_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0x2f,0x01,0x00]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x10]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x30]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0xf0]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0xf0]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x01]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x03]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x0f]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x00,0x0f]

v_min_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x08,0x00]

v_min_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x10,0x00]

v_min_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x20,0x00]

v_min_f16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x40,0x00]

v_min_f16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5c,0x01,0xe4,0x80,0x00]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x06]

v_max_u16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x5f,0x01,0x06,0x06,0x06]

v_max_u16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0xff,0x06,0x06,0x06]

v_max_u16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x5e,0x01,0x06,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x00,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x01,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x02,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x03,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x04,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x05,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x0e,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x16,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x16,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x00,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x01,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x02,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x03,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x04,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x05,0x06]

v_max_u16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x0e,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x06]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x00]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x01]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x02]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x03]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x04]

v_max_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x05]

v_max_u16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x5e,0x01,0x06,0x06,0x0e]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x00]

v_max_u16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x5f,0x01,0xe4,0x00,0x00]

v_max_u16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0xff,0xe4,0x00,0x00]

v_max_u16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x5e,0x01,0xe4,0x00,0x00]

v_max_u16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x1b,0x00,0x00]

v_max_u16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x40,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x41,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x42,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x43,0x01,0x00]

v_max_u16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x30,0x01,0x00]

v_max_u16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x34,0x01,0x00]

v_max_u16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x38,0x01,0x00]

v_max_u16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x3c,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x01,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x0f,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x11,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x1f,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x21,0x01,0x00]

v_max_u16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0x2f,0x01,0x00]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x10]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x30]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0xf0]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0xf0]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x01]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x03]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x0f]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x00,0x0f]

v_max_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x5e,0x01,0xe4,0x08,0x00]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x06]

v_max_i16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x61,0x01,0x06,0x06,0x06]

v_max_i16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0xff,0x06,0x06,0x06]

v_max_i16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x60,0x01,0x06,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x00,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x01,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x02,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x03,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x04,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x05,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x0e,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x16,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x16,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x00,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x01,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x02,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x03,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x04,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x05,0x06]

v_max_i16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x0e,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x06]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x00]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x01]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x02]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x03]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x04]

v_max_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x05]

v_max_i16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x60,0x01,0x06,0x06,0x0e]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x00]

v_max_i16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x61,0x01,0xe4,0x00,0x00]

v_max_i16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0xff,0xe4,0x00,0x00]

v_max_i16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x60,0x01,0xe4,0x00,0x00]

v_max_i16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x1b,0x00,0x00]

v_max_i16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x40,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x41,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x42,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x43,0x01,0x00]

v_max_i16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x30,0x01,0x00]

v_max_i16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x34,0x01,0x00]

v_max_i16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x38,0x01,0x00]

v_max_i16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x3c,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x01,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x0f,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x11,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x1f,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x21,0x01,0x00]

v_max_i16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0x2f,0x01,0x00]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x10]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x30]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0xf0]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0xf0]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x01]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x03]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x0f]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x00,0x0f]

v_max_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x60,0x01,0xe4,0x08,0x00]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x06]

v_min_u16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x63,0x01,0x06,0x06,0x06]

v_min_u16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0xff,0x06,0x06,0x06]

v_min_u16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x62,0x01,0x06,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x00,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x01,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x02,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x03,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x04,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x05,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x0e,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x16,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x16,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x00,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x01,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x02,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x03,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x04,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x05,0x06]

v_min_u16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x0e,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x06]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x00]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x01]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x02]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x03]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x04]

v_min_u16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x05]

v_min_u16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x62,0x01,0x06,0x06,0x0e]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x00]

v_min_u16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x63,0x01,0xe4,0x00,0x00]

v_min_u16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0xff,0xe4,0x00,0x00]

v_min_u16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x62,0x01,0xe4,0x00,0x00]

v_min_u16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x1b,0x00,0x00]

v_min_u16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x40,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x41,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x42,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x43,0x01,0x00]

v_min_u16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x30,0x01,0x00]

v_min_u16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x34,0x01,0x00]

v_min_u16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x38,0x01,0x00]

v_min_u16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x3c,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x01,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x0f,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x11,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x1f,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x21,0x01,0x00]

v_min_u16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0x2f,0x01,0x00]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x10]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x30]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0xf0]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0xf0]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x01]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x03]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x0f]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x00,0x0f]

v_min_u16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x62,0x01,0xe4,0x08,0x00]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_min_i16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x65,0x01,0x06,0x06,0x06]

v_min_i16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0xff,0x06,0x06,0x06]

v_min_i16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x64,0x01,0x06,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x00,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x01,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x02,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x03,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x04,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x05,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x0e,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x16,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x16,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x00,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x01,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x02,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x03,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x04,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x05,0x06]

v_min_i16_sdwa v5, sext(v1), v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x0e,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x06]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x00]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x01]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x02]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x03]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x04]

v_min_i16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x05]

v_min_i16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x64,0x01,0x06,0x06,0x0e]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x00]

v_min_i16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x65,0x01,0xe4,0x00,0x00]

v_min_i16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0xff,0xe4,0x00,0x00]

v_min_i16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x64,0x01,0xe4,0x00,0x00]

v_min_i16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x1b,0x00,0x00]

v_min_i16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x40,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x41,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x42,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x43,0x01,0x00]

v_min_i16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x30,0x01,0x00]

v_min_i16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x34,0x01,0x00]

v_min_i16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x38,0x01,0x00]

v_min_i16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x3c,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x01,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x0f,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x11,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x1f,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x21,0x01,0x00]

v_min_i16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0x2f,0x01,0x00]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x10]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x30]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0xf0]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0xf0]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x01]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x03]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x0f]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x00,0x0f]

v_min_i16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x64,0x01,0xe4,0x08,0x00]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v255, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0xfe,0x67,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v255, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0xff,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0xfe,0x0b,0x66,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x26,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x00,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x01,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x02,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x03,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x04,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x05,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x0e,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x16,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x16,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x00,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x01,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x02,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x03,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x04,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x05,0x06]

v_ldexp_f16_sdwa v5, -v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x16,0x06]

v_ldexp_f16_sdwa v5, |v1|, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x26,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x06]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x00]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_1
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x01]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_2
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x02]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_3
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x03]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x04]

v_ldexp_f16_sdwa v5, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x05]

v_ldexp_f16_sdwa v5, v1, sext(v2) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
// CHECK: [0xf9,0x04,0x0a,0x66,0x01,0x06,0x06,0x0e]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x00]

v_ldexp_f16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0xfe,0x67,0x01,0xe4,0x00,0x00]

v_ldexp_f16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0xff,0xe4,0x00,0x00]

v_ldexp_f16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0xfe,0x0b,0x66,0x01,0xe4,0x00,0x00]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x1b,0x00,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x40,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x41,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x42,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x43,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x30,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x34,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x38,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x3c,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x01,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x0f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x11,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x1f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x21,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0x2f,0x01,0x00]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x10]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x30]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0xf0]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0xf0]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x01]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x03]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x0f]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x00,0x0f]

v_ldexp_f16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x08,0x00]

v_ldexp_f16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x10,0x00]

v_ldexp_f16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: [0xfa,0x04,0x0a,0x66,0x01,0xe4,0x20,0x00]
