#!/usr/bin/perl -w

if (@ARGV != 2) {
    die "Usage: gen-keyname-table.pl keynames.txt keynames-translate.txt > keynamesprivate.h\n";
}

open IN, $ARGV[0] || die "Cannot open $ARGV[0]: $!\n";

@keys = ();
@translate = ();
while (defined($_ = <IN>)) {
    next if /^!/;
    if (!/^\s*(0x[0-9a-f]+)\s+([\w_]*\S)\s+(1)?\s*$/) {
	die "Cannot parse line $_";
    }

    push @keys, [$1, $2];

    if (defined ($3)) {
	push @translate, $2;
    }
}
close IN;

open IN, $ARGV[1] || die "Cannot open $ARGV[1]: $!\n";
while (defined($_ = <IN>)) {
    next if /^!/;
    if (!/^\s*([\w_]*\S)\s+$/) {
	die "Cannot parse line $_";
    }

    push @translate, $1;
}
close IN;

$offset = 0;

$date = gmtime;

print <<EOT;
/* keynamesprivate.h: Generated by gen-keyname-table.pl from keynames.txt
 *
 *  Date: $date
 *
 * Do not edit.   
 */
static const char keynames[] =
EOT

for $key (@keys) {
    $name = $key->[1];

    if ($offset != 0) {
	print qq(\n);
    }
    print qq(  "$name\\0");

    $key->[3] = $offset;
    $offset += length($name) + 1;
}

print ";\n\n";

print <<EOT;
typedef struct {
    guint  keyval;
    guint  offset;
} gdk_key;

static const gdk_key gdk_keys_by_keyval[] = {
EOT

$i = 0;
for $key (@keys) {
    $keyval = $key->[0];
    $name = $key->[1];
    $offset = $key->[3];

    if ($i != 0) {
	print ",\n";
    }
    print "  { $keyval, $offset }";
    $i++;
}

print "\n};\n\n";

@keys = sort { $a->[1] cmp $b->[1] } @keys;


print <<EOT;
static const gdk_key gdk_keys_by_name[] = {
EOT

$i = 0;
for $key (@keys) {
    $keyval = $key->[0];
    $name = $key->[1];
    $offset = $key->[3];

    if ($i != 0) {
	print ",\n";
    }
    print "  { $keyval, $offset }";
    $i++;
}

print <<EOT;
};


#if 0

/*
 * Translators, the strings in the 'keyboard label' context are
 * display names for keyboard keys. Some of them have prefixes like
 * XF86 or ISO_ - these should be removed in the translation. Similarly,
 * underscores should be replaced by spaces. The prefix 'KP_' stands
 * for 'key pad' and you may want to include that in your translation.
 * Here are some examples of English translations:
 * XF86AudioMute - Audio mute
 * Scroll_lock   - Scroll lock
 * KP_Space      - Space (keypad)
 */
EOT

for $key (@translate) {
    if ($key eq 'KP_Space') {
      print "/* Translators: KP_ means 'key pad' here */\n";
    }
    if ($key eq 'XF86MonBrightnessUp') {
      print "/* Translators: 'Mon' means Monitor here, and the XF86 prefix should be removed */\n";
    }
    print <<EOT;
NC_("keyboard label", "$key")
EOT
}

print <<EOT;

#endif
EOT

