#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
VERSION=$2
ORIG_TAR=$3
TAR=../apache-log4j1.2_$VERSION.orig.tar.gz
DIR=apache-log4j1.2-$VERSION.orig

# clean up the upstream tarball
tar xvzf $ORIG_TAR
mv apache-log4j-$VERSION $DIR
GZIP=--best tar -c -z -f $TAR --exclude '*.jar' --exclude 'site' --exclude '*.dll' $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
    . .svn/deb-layout
    mv $3 $origDir
    echo "moved $3 to $origDir"
fi

exit 0
