/* marshalling-test.c generated by valac 0.48.11, the Vala compiler
 * generated from marshalling-test.vala, do not modify */

/* marshalling-test.vala
 *
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "zeitgeist-datamodel.h"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

gint _vala_main (gchar** argv,
                 gint argv_length1);
void subject_test (void);
static void _subject_test_gtest_func (void);
void event_test (void);
static void _event_test_gtest_func (void);
void events_test (void);
static void _events_test_gtest_func (void);
void timerange_test (void);
static void _timerange_test_gtest_func (void);
void corrupt_events_test (void);
static void _corrupt_events_test_gtest_func (void);
void corrupt_subjects_test (void);
static void _corrupt_subjects_test_gtest_func (void);
void corrupt_timerange_test (void);
static void _corrupt_timerange_test_gtest_func (void);
ZeitgeistSubject* create_subject (void);
ZeitgeistEvent* create_event (void);
static void _g_object_unref0_ (gpointer var);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static void
_subject_test_gtest_func (void)
{
#line 29 "marshalling-test.vala"
	subject_test ();
#line 71 "marshalling-test.c"
}

static void
_event_test_gtest_func (void)
{
#line 30 "marshalling-test.vala"
	event_test ();
#line 79 "marshalling-test.c"
}

static void
_events_test_gtest_func (void)
{
#line 31 "marshalling-test.vala"
	events_test ();
#line 87 "marshalling-test.c"
}

static void
_timerange_test_gtest_func (void)
{
#line 32 "marshalling-test.vala"
	timerange_test ();
#line 95 "marshalling-test.c"
}

static void
_corrupt_events_test_gtest_func (void)
{
#line 33 "marshalling-test.vala"
	corrupt_events_test ();
#line 103 "marshalling-test.c"
}

static void
_corrupt_subjects_test_gtest_func (void)
{
#line 34 "marshalling-test.vala"
	corrupt_subjects_test ();
#line 111 "marshalling-test.c"
}

static void
_corrupt_timerange_test_gtest_func (void)
{
#line 35 "marshalling-test.vala"
	corrupt_timerange_test ();
#line 119 "marshalling-test.c"
}

gint
_vala_main (gchar** argv,
            gint argv_length1)
{
	gint result = 0;
#line 27 "marshalling-test.vala"
	g_test_init ((gint*) (&argv_length1), &argv, NULL);
#line 29 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/subjects", _subject_test_gtest_func);
#line 30 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/event", _event_test_gtest_func);
#line 31 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/events", _events_test_gtest_func);
#line 32 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/timerange", _timerange_test_gtest_func);
#line 33 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/corrupt_events", _corrupt_events_test_gtest_func);
#line 34 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/corrupt_subjects", _corrupt_subjects_test_gtest_func);
#line 35 "marshalling-test.vala"
	g_test_add_func ("/Marshalling/corrupt_timerange", _corrupt_timerange_test_gtest_func);
#line 37 "marshalling-test.vala"
	result = g_test_run ();
#line 37 "marshalling-test.vala"
	return result;
#line 147 "marshalling-test.c"
}

int
main (int argc,
      char ** argv)
{
#line 25 "marshalling-test.vala"
	return _vala_main (argv, argc);
#line 156 "marshalling-test.c"
}

ZeitgeistSubject*
create_subject (void)
{
	ZeitgeistSubject* s = NULL;
	ZeitgeistSubject* _tmp0_;
	ZeitgeistSubject* result = NULL;
#line 42 "marshalling-test.vala"
	_tmp0_ = zeitgeist_subject_new ();
#line 42 "marshalling-test.vala"
	s = _tmp0_;
#line 43 "marshalling-test.vala"
	zeitgeist_subject_set_uri (s, "scheme:///uri");
#line 44 "marshalling-test.vala"
	zeitgeist_subject_set_interpretation (s, "subject_interpretation_uri");
#line 45 "marshalling-test.vala"
	zeitgeist_subject_set_manifestation (s, "subject_manifestation_uri");
#line 46 "marshalling-test.vala"
	zeitgeist_subject_set_mimetype (s, "text/plain");
#line 47 "marshalling-test.vala"
	zeitgeist_subject_set_origin (s, "scheme:///");
#line 48 "marshalling-test.vala"
	zeitgeist_subject_set_text (s, "Human readable text");
#line 49 "marshalling-test.vala"
	zeitgeist_subject_set_storage (s, "");
#line 50 "marshalling-test.vala"
	zeitgeist_subject_set_current_uri (s, "scheme:///uri");
#line 52 "marshalling-test.vala"
	result = s;
#line 52 "marshalling-test.vala"
	return result;
#line 189 "marshalling-test.c"
}

ZeitgeistEvent*
create_event (void)
{
	ZeitgeistEvent* e = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistEvent* result = NULL;
#line 57 "marshalling-test.vala"
	_tmp0_ = zeitgeist_event_new ();
#line 57 "marshalling-test.vala"
	e = _tmp0_;
#line 58 "marshalling-test.vala"
	zeitgeist_event_set_id (e, (guint32) 1234);
#line 59 "marshalling-test.vala"
	zeitgeist_event_set_timestamp (e, (gint64) 1234567890L);
#line 60 "marshalling-test.vala"
	zeitgeist_event_set_interpretation (e, "interpretation_uri");
#line 61 "marshalling-test.vala"
	zeitgeist_event_set_manifestation (e, "manifestation_uri");
#line 62 "marshalling-test.vala"
	zeitgeist_event_set_actor (e, "test.desktop");
#line 63 "marshalling-test.vala"
	zeitgeist_event_set_origin (e, "source");
#line 65 "marshalling-test.vala"
	result = e;
#line 65 "marshalling-test.vala"
	return result;
#line 218 "marshalling-test.c"
}

void
subject_test (void)
{
	GError* _inner_error0_ = NULL;
	{
		gint i = 0;
#line 70 "marshalling-test.vala"
		i = 0;
#line 229 "marshalling-test.c"
		{
			gboolean _tmp0_ = FALSE;
#line 70 "marshalling-test.vala"
			_tmp0_ = TRUE;
#line 70 "marshalling-test.vala"
			while (TRUE) {
#line 236 "marshalling-test.c"
				GVariant* vsubject = NULL;
				ZeitgeistSubject* _tmp2_;
				ZeitgeistSubject* _tmp3_;
				GVariant* _tmp4_;
				GVariant* _tmp5_;
				ZeitgeistSubject* subject = NULL;
				GVariant* _tmp6_;
				ZeitgeistSubject* _tmp7_;
				ZeitgeistSubject* _tmp8_;
#line 70 "marshalling-test.vala"
				if (!_tmp0_) {
#line 248 "marshalling-test.c"
					gint _tmp1_;
#line 70 "marshalling-test.vala"
					_tmp1_ = i;
#line 70 "marshalling-test.vala"
					i = _tmp1_ + 1;
#line 254 "marshalling-test.c"
				}
#line 70 "marshalling-test.vala"
				_tmp0_ = FALSE;
#line 70 "marshalling-test.vala"
				if (!(i < 1000)) {
#line 70 "marshalling-test.vala"
					break;
#line 262 "marshalling-test.c"
				}
#line 72 "marshalling-test.vala"
				_tmp2_ = create_subject ();
#line 72 "marshalling-test.vala"
				_tmp3_ = _tmp2_;
#line 72 "marshalling-test.vala"
				_tmp4_ = zeitgeist_subject_to_variant (_tmp3_);
#line 72 "marshalling-test.vala"
				_tmp5_ = _tmp4_;
#line 72 "marshalling-test.vala"
				_g_object_unref0 (_tmp3_);
#line 72 "marshalling-test.vala"
				vsubject = _tmp5_;
#line 73 "marshalling-test.vala"
				_tmp6_ = vsubject;
#line 73 "marshalling-test.vala"
				_tmp7_ = zeitgeist_subject_new_from_variant (_tmp6_, &_inner_error0_);
#line 73 "marshalling-test.vala"
				subject = _tmp7_;
#line 73 "marshalling-test.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "marshalling-test.vala"
					_g_variant_unref0 (vsubject);
#line 73 "marshalling-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 73 "marshalling-test.vala"
					g_clear_error (&_inner_error0_);
#line 73 "marshalling-test.vala"
					return;
#line 292 "marshalling-test.c"
				}
#line 74 "marshalling-test.vala"
				_tmp8_ = subject;
#line 74 "marshalling-test.vala"
				g_warn_if_fail (_tmp8_ != NULL);
#line 70 "marshalling-test.vala"
				_g_object_unref0 (subject);
#line 70 "marshalling-test.vala"
				_g_variant_unref0 (vsubject);
#line 302 "marshalling-test.c"
			}
		}
	}
}

void
event_test (void)
{
	GError* _inner_error0_ = NULL;
	{
		gint i = 0;
#line 80 "marshalling-test.vala"
		i = 0;
#line 316 "marshalling-test.c"
		{
			gboolean _tmp0_ = FALSE;
#line 80 "marshalling-test.vala"
			_tmp0_ = TRUE;
#line 80 "marshalling-test.vala"
			while (TRUE) {
#line 323 "marshalling-test.c"
				GVariant* vevent = NULL;
				ZeitgeistEvent* _tmp2_;
				ZeitgeistEvent* _tmp3_;
				GVariant* _tmp4_;
				GVariant* _tmp5_;
				ZeitgeistEvent* event = NULL;
				GVariant* _tmp6_;
				ZeitgeistEvent* _tmp7_;
				ZeitgeistEvent* _tmp8_;
#line 80 "marshalling-test.vala"
				if (!_tmp0_) {
#line 335 "marshalling-test.c"
					gint _tmp1_;
#line 80 "marshalling-test.vala"
					_tmp1_ = i;
#line 80 "marshalling-test.vala"
					i = _tmp1_ + 1;
#line 341 "marshalling-test.c"
				}
#line 80 "marshalling-test.vala"
				_tmp0_ = FALSE;
#line 80 "marshalling-test.vala"
				if (!(i < 1000)) {
#line 80 "marshalling-test.vala"
					break;
#line 349 "marshalling-test.c"
				}
#line 82 "marshalling-test.vala"
				_tmp2_ = create_event ();
#line 82 "marshalling-test.vala"
				_tmp3_ = _tmp2_;
#line 82 "marshalling-test.vala"
				_tmp4_ = zeitgeist_event_to_variant (_tmp3_);
#line 82 "marshalling-test.vala"
				_tmp5_ = _tmp4_;
#line 82 "marshalling-test.vala"
				_g_object_unref0 (_tmp3_);
#line 82 "marshalling-test.vala"
				vevent = _tmp5_;
#line 83 "marshalling-test.vala"
				_tmp6_ = vevent;
#line 83 "marshalling-test.vala"
				_tmp7_ = zeitgeist_event_new_from_variant (_tmp6_, &_inner_error0_);
#line 83 "marshalling-test.vala"
				event = _tmp7_;
#line 83 "marshalling-test.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 83 "marshalling-test.vala"
					_g_variant_unref0 (vevent);
#line 83 "marshalling-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 83 "marshalling-test.vala"
					g_clear_error (&_inner_error0_);
#line 83 "marshalling-test.vala"
					return;
#line 379 "marshalling-test.c"
				}
#line 84 "marshalling-test.vala"
				_tmp8_ = event;
#line 84 "marshalling-test.vala"
				g_warn_if_fail (_tmp8_ != NULL);
#line 80 "marshalling-test.vala"
				_g_object_unref0 (event);
#line 80 "marshalling-test.vala"
				_g_variant_unref0 (vevent);
#line 389 "marshalling-test.c"
			}
		}
	}
}

static void
_g_object_unref0_ (gpointer var)
{
#line 90 "marshalling-test.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 400 "marshalling-test.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 95 "marshalling-test.vala"
	return self ? g_object_ref (self) : NULL;
#line 408 "marshalling-test.c"
}

static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
#line 5303 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5303 "glib-2.0.vapi"
	result = (gint) self->len;
#line 5303 "glib-2.0.vapi"
	return result;
#line 421 "marshalling-test.c"
}

static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
#line 5304 "glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 5304 "glib-2.0.vapi"
	g_ptr_array_set_size (self, value);
#line 432 "marshalling-test.c"
}

void
events_test (void)
{
	GPtrArray* events = NULL;
	GPtrArray* _tmp0_;
	GVariant* vevents = NULL;
	GPtrArray* _tmp10_;
	GVariant* _tmp11_;
	GPtrArray* demarshalled = NULL;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GError* _inner_error0_ = NULL;
#line 90 "marshalling-test.vala"
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
#line 90 "marshalling-test.vala"
	events = _tmp0_;
#line 452 "marshalling-test.c"
	{
		gint i = 0;
#line 91 "marshalling-test.vala"
		i = 0;
#line 457 "marshalling-test.c"
		{
			gboolean _tmp1_ = FALSE;
#line 91 "marshalling-test.vala"
			_tmp1_ = TRUE;
#line 91 "marshalling-test.vala"
			while (TRUE) {
#line 464 "marshalling-test.c"
				ZeitgeistEvent* e = NULL;
				ZeitgeistEvent* _tmp3_;
				ZeitgeistEvent* _tmp4_;
				ZeitgeistSubject* _tmp5_;
				ZeitgeistSubject* _tmp6_;
				GPtrArray* _tmp7_;
				ZeitgeistEvent* _tmp8_;
				ZeitgeistEvent* _tmp9_;
#line 91 "marshalling-test.vala"
				if (!_tmp1_) {
#line 475 "marshalling-test.c"
					gint _tmp2_;
#line 91 "marshalling-test.vala"
					_tmp2_ = i;
#line 91 "marshalling-test.vala"
					i = _tmp2_ + 1;
#line 481 "marshalling-test.c"
				}
#line 91 "marshalling-test.vala"
				_tmp1_ = FALSE;
#line 91 "marshalling-test.vala"
				if (!(i < 1000)) {
#line 91 "marshalling-test.vala"
					break;
#line 489 "marshalling-test.c"
				}
#line 93 "marshalling-test.vala"
				_tmp3_ = create_event ();
#line 93 "marshalling-test.vala"
				e = _tmp3_;
#line 94 "marshalling-test.vala"
				_tmp4_ = e;
#line 94 "marshalling-test.vala"
				_tmp5_ = create_subject ();
#line 94 "marshalling-test.vala"
				_tmp6_ = _tmp5_;
#line 94 "marshalling-test.vala"
				zeitgeist_event_add_subject (_tmp4_, _tmp6_);
#line 94 "marshalling-test.vala"
				_g_object_unref0 (_tmp6_);
#line 95 "marshalling-test.vala"
				_tmp7_ = events;
#line 95 "marshalling-test.vala"
				_tmp8_ = e;
#line 95 "marshalling-test.vala"
				_tmp9_ = _g_object_ref0 (_tmp8_);
#line 95 "marshalling-test.vala"
				g_ptr_array_add (_tmp7_, _tmp9_);
#line 91 "marshalling-test.vala"
				_g_object_unref0 (e);
#line 515 "marshalling-test.c"
			}
		}
	}
#line 98 "marshalling-test.vala"
	_tmp10_ = events;
#line 98 "marshalling-test.vala"
	_tmp11_ = zeitgeist_events_to_variant (_tmp10_);
#line 98 "marshalling-test.vala"
	vevents = _tmp11_;
#line 100 "marshalling-test.vala"
	_tmp12_ = zeitgeist_events_from_variant (vevents, &_inner_error0_);
#line 100 "marshalling-test.vala"
	demarshalled = _tmp12_;
#line 100 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 100 "marshalling-test.vala"
		_g_variant_unref0 (vevents);
#line 100 "marshalling-test.vala"
		_g_ptr_array_unref0 (events);
#line 100 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 100 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 100 "marshalling-test.vala"
		return;
#line 541 "marshalling-test.c"
	}
#line 101 "marshalling-test.vala"
	_tmp13_ = g_ptr_array_get_length (demarshalled);
#line 101 "marshalling-test.vala"
	_tmp14_ = _tmp13_;
#line 101 "marshalling-test.vala"
	g_assert_cmpint (_tmp14_, ==, 1000);
#line 88 "marshalling-test.vala"
	_g_ptr_array_unref0 (demarshalled);
#line 88 "marshalling-test.vala"
	_g_variant_unref0 (vevents);
#line 88 "marshalling-test.vala"
	_g_ptr_array_unref0 (events);
#line 555 "marshalling-test.c"
}

void
timerange_test (void)
{
	GError* _inner_error0_ = NULL;
	{
		gint64 i = 0LL;
#line 106 "marshalling-test.vala"
		i = (gint64) 0;
#line 566 "marshalling-test.c"
		{
			gboolean _tmp0_ = FALSE;
#line 106 "marshalling-test.vala"
			_tmp0_ = TRUE;
#line 106 "marshalling-test.vala"
			while (TRUE) {
#line 573 "marshalling-test.c"
				GVariant* v = NULL;
				GVariant* _tmp2_;
				ZeitgeistTimeRange* timerange = NULL;
				GVariant* _tmp3_;
				ZeitgeistTimeRange* _tmp4_;
				ZeitgeistTimeRange* _tmp5_;
				gint64 _tmp6_;
				gint64 _tmp7_;
				ZeitgeistTimeRange* _tmp8_;
				gint64 _tmp9_;
				gint64 _tmp10_;
#line 106 "marshalling-test.vala"
				if (!_tmp0_) {
#line 587 "marshalling-test.c"
					gint64 _tmp1_;
#line 106 "marshalling-test.vala"
					_tmp1_ = i;
#line 106 "marshalling-test.vala"
					i = _tmp1_ + 1;
#line 593 "marshalling-test.c"
				}
#line 106 "marshalling-test.vala"
				_tmp0_ = FALSE;
#line 106 "marshalling-test.vala"
				if (!(i < ((gint64) 1000))) {
#line 106 "marshalling-test.vala"
					break;
#line 601 "marshalling-test.c"
				}
#line 108 "marshalling-test.vala"
				_tmp2_ = g_variant_new ("(xx)", i, i + 42, NULL);
#line 108 "marshalling-test.vala"
				g_variant_ref_sink (_tmp2_);
#line 108 "marshalling-test.vala"
				v = _tmp2_;
#line 109 "marshalling-test.vala"
				_tmp3_ = v;
#line 109 "marshalling-test.vala"
				_tmp4_ = zeitgeist_time_range_new_from_variant (_tmp3_, &_inner_error0_);
#line 109 "marshalling-test.vala"
				timerange = _tmp4_;
#line 109 "marshalling-test.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 109 "marshalling-test.vala"
					_g_variant_unref0 (v);
#line 109 "marshalling-test.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 109 "marshalling-test.vala"
					g_clear_error (&_inner_error0_);
#line 109 "marshalling-test.vala"
					return;
#line 625 "marshalling-test.c"
				}
#line 110 "marshalling-test.vala"
				_tmp5_ = timerange;
#line 110 "marshalling-test.vala"
				_tmp6_ = zeitgeist_time_range_get_start (_tmp5_);
#line 110 "marshalling-test.vala"
				_tmp7_ = _tmp6_;
#line 110 "marshalling-test.vala"
				g_assert_cmpint ((gint) _tmp7_, ==, (gint) i);
#line 111 "marshalling-test.vala"
				_tmp8_ = timerange;
#line 111 "marshalling-test.vala"
				_tmp9_ = zeitgeist_time_range_get_end (_tmp8_);
#line 111 "marshalling-test.vala"
				_tmp10_ = _tmp9_;
#line 111 "marshalling-test.vala"
				g_assert_cmpint ((gint) _tmp10_, ==, ((gint) i) + 42);
#line 106 "marshalling-test.vala"
				_g_object_unref0 (timerange);
#line 106 "marshalling-test.vala"
				_g_variant_unref0 (v);
#line 647 "marshalling-test.c"
			}
		}
	}
}

void
corrupt_events_test (void)
{
	GVariant* v = NULL;
	GVariant* _tmp0_;
	gboolean error_thrown = FALSE;
	GError* _inner_error0_ = NULL;
#line 118 "marshalling-test.vala"
	_tmp0_ = g_variant_new ("(s)", "Zeitgeist is so awesome", NULL);
#line 118 "marshalling-test.vala"
	g_variant_ref_sink (_tmp0_);
#line 118 "marshalling-test.vala"
	v = _tmp0_;
#line 119 "marshalling-test.vala"
	error_thrown = FALSE;
#line 668 "marshalling-test.c"
	{
		ZeitgeistEvent* _tmp1_;
		ZeitgeistEvent* _tmp2_;
#line 122 "marshalling-test.vala"
		_tmp1_ = zeitgeist_event_new_from_variant (v, &_inner_error0_);
#line 122 "marshalling-test.vala"
		_tmp2_ = _tmp1_;
#line 122 "marshalling-test.vala"
		_g_object_unref0 (_tmp2_);
#line 122 "marshalling-test.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 122 "marshalling-test.vala"
			if (g_error_matches (_inner_error0_, ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE)) {
#line 682 "marshalling-test.c"
				goto __catch0_zeitgeist_data_model_error_invalid_signature;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_zeitgeist_data_model_error_invalid_signature:
	{
#line 120 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 125 "marshalling-test.vala"
		error_thrown = TRUE;
#line 695 "marshalling-test.c"
	}
	__finally0:
#line 120 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 120 "marshalling-test.vala"
		_g_variant_unref0 (v);
#line 120 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 120 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 120 "marshalling-test.vala"
		return;
#line 708 "marshalling-test.c"
	}
#line 127 "marshalling-test.vala"
	_vala_assert (error_thrown, "error_thrown");
#line 115 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 714 "marshalling-test.c"
}

void
corrupt_subjects_test (void)
{
	GVariant* v = NULL;
	gchar** arr = NULL;
	gint arr_length1 = 0;
	gint _arr_size_ = 0;
	gboolean error_thrown = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	ZeitgeistSubject* _tmp12_;
	ZeitgeistSubject* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	ZeitgeistSubject* _tmp25_;
	ZeitgeistSubject* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	GVariant* _tmp35_;
	GVariant* _tmp40_;
	GError* _inner_error0_ = NULL;
#line 137 "marshalling-test.vala"
	_tmp0_ = g_strdup ("uri");
#line 137 "marshalling-test.vala"
	_tmp1_ = g_strdup ("interpretation");
#line 137 "marshalling-test.vala"
	_tmp2_ = g_strdup ("manifestation");
#line 137 "marshalling-test.vala"
	_tmp3_ = g_strdup ("origin");
#line 137 "marshalling-test.vala"
	_tmp4_ = g_strdup ("mimetype");
#line 137 "marshalling-test.vala"
	_tmp5_ = g_strdup ("text");
#line 137 "marshalling-test.vala"
	_tmp6_ = g_strdup ("storage");
#line 137 "marshalling-test.vala"
	_tmp7_ = g_strdup ("current_uri");
#line 137 "marshalling-test.vala"
	_tmp8_ = g_new0 (gchar*, 8 + 1);
#line 137 "marshalling-test.vala"
	_tmp8_[0] = _tmp0_;
#line 137 "marshalling-test.vala"
	_tmp8_[1] = _tmp1_;
#line 137 "marshalling-test.vala"
	_tmp8_[2] = _tmp2_;
#line 137 "marshalling-test.vala"
	_tmp8_[3] = _tmp3_;
#line 137 "marshalling-test.vala"
	_tmp8_[4] = _tmp4_;
#line 137 "marshalling-test.vala"
	_tmp8_[5] = _tmp5_;
#line 137 "marshalling-test.vala"
	_tmp8_[6] = _tmp6_;
#line 137 "marshalling-test.vala"
	_tmp8_[7] = _tmp7_;
#line 137 "marshalling-test.vala"
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 137 "marshalling-test.vala"
	arr = _tmp8_;
#line 137 "marshalling-test.vala"
	arr_length1 = 8;
#line 137 "marshalling-test.vala"
	_arr_size_ = arr_length1;
#line 139 "marshalling-test.vala"
	_tmp9_ = arr;
#line 139 "marshalling-test.vala"
	_tmp9__length1 = arr_length1;
#line 139 "marshalling-test.vala"
	_tmp10_ = g_variant_new_strv (_tmp9_, _tmp9__length1);
#line 139 "marshalling-test.vala"
	g_variant_ref_sink (_tmp10_);
#line 139 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 139 "marshalling-test.vala"
	v = _tmp10_;
#line 140 "marshalling-test.vala"
	_tmp11_ = v;
#line 140 "marshalling-test.vala"
	_tmp12_ = zeitgeist_subject_new_from_variant (_tmp11_, &_inner_error0_);
#line 140 "marshalling-test.vala"
	_tmp13_ = _tmp12_;
#line 140 "marshalling-test.vala"
	_g_object_unref0 (_tmp13_);
#line 140 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 140 "marshalling-test.vala"
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 140 "marshalling-test.vala"
		_g_variant_unref0 (v);
#line 140 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 140 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 140 "marshalling-test.vala"
		return;
#line 840 "marshalling-test.c"
	}
#line 143 "marshalling-test.vala"
	_tmp14_ = g_strdup ("uri");
#line 143 "marshalling-test.vala"
	_tmp15_ = g_strdup ("interpretation");
#line 143 "marshalling-test.vala"
	_tmp16_ = g_strdup ("manifestation");
#line 143 "marshalling-test.vala"
	_tmp17_ = g_strdup ("origin");
#line 143 "marshalling-test.vala"
	_tmp18_ = g_strdup ("mimetype");
#line 143 "marshalling-test.vala"
	_tmp19_ = g_strdup ("text");
#line 143 "marshalling-test.vala"
	_tmp20_ = g_strdup ("storage");
#line 143 "marshalling-test.vala"
	_tmp21_ = g_new0 (gchar*, 7 + 1);
#line 143 "marshalling-test.vala"
	_tmp21_[0] = _tmp14_;
#line 143 "marshalling-test.vala"
	_tmp21_[1] = _tmp15_;
#line 143 "marshalling-test.vala"
	_tmp21_[2] = _tmp16_;
#line 143 "marshalling-test.vala"
	_tmp21_[3] = _tmp17_;
#line 143 "marshalling-test.vala"
	_tmp21_[4] = _tmp18_;
#line 143 "marshalling-test.vala"
	_tmp21_[5] = _tmp19_;
#line 143 "marshalling-test.vala"
	_tmp21_[6] = _tmp20_;
#line 143 "marshalling-test.vala"
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 143 "marshalling-test.vala"
	arr = _tmp21_;
#line 143 "marshalling-test.vala"
	arr_length1 = 7;
#line 143 "marshalling-test.vala"
	_arr_size_ = arr_length1;
#line 145 "marshalling-test.vala"
	_tmp22_ = arr;
#line 145 "marshalling-test.vala"
	_tmp22__length1 = arr_length1;
#line 145 "marshalling-test.vala"
	_tmp23_ = g_variant_new_strv (_tmp22_, _tmp22__length1);
#line 145 "marshalling-test.vala"
	g_variant_ref_sink (_tmp23_);
#line 145 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 145 "marshalling-test.vala"
	v = _tmp23_;
#line 146 "marshalling-test.vala"
	_tmp24_ = v;
#line 146 "marshalling-test.vala"
	_tmp25_ = zeitgeist_subject_new_from_variant (_tmp24_, &_inner_error0_);
#line 146 "marshalling-test.vala"
	_tmp26_ = _tmp25_;
#line 146 "marshalling-test.vala"
	_g_object_unref0 (_tmp26_);
#line 146 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 146 "marshalling-test.vala"
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 146 "marshalling-test.vala"
		_g_variant_unref0 (v);
#line 146 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 146 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 146 "marshalling-test.vala"
		return;
#line 912 "marshalling-test.c"
	}
#line 149 "marshalling-test.vala"
	_tmp27_ = g_strdup ("uri");
#line 149 "marshalling-test.vala"
	_tmp28_ = g_strdup ("interpretation");
#line 149 "marshalling-test.vala"
	_tmp29_ = g_strdup ("manifestation");
#line 149 "marshalling-test.vala"
	_tmp30_ = g_strdup ("origin");
#line 149 "marshalling-test.vala"
	_tmp31_ = g_strdup ("mimetype");
#line 149 "marshalling-test.vala"
	_tmp32_ = g_strdup ("text");
#line 149 "marshalling-test.vala"
	_tmp33_ = g_new0 (gchar*, 6 + 1);
#line 149 "marshalling-test.vala"
	_tmp33_[0] = _tmp27_;
#line 149 "marshalling-test.vala"
	_tmp33_[1] = _tmp28_;
#line 149 "marshalling-test.vala"
	_tmp33_[2] = _tmp29_;
#line 149 "marshalling-test.vala"
	_tmp33_[3] = _tmp30_;
#line 149 "marshalling-test.vala"
	_tmp33_[4] = _tmp31_;
#line 149 "marshalling-test.vala"
	_tmp33_[5] = _tmp32_;
#line 149 "marshalling-test.vala"
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 149 "marshalling-test.vala"
	arr = _tmp33_;
#line 149 "marshalling-test.vala"
	arr_length1 = 6;
#line 149 "marshalling-test.vala"
	_arr_size_ = arr_length1;
#line 151 "marshalling-test.vala"
	_tmp34_ = arr;
#line 151 "marshalling-test.vala"
	_tmp34__length1 = arr_length1;
#line 151 "marshalling-test.vala"
	_tmp35_ = g_variant_new_strv (_tmp34_, _tmp34__length1);
#line 151 "marshalling-test.vala"
	g_variant_ref_sink (_tmp35_);
#line 151 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 151 "marshalling-test.vala"
	v = _tmp35_;
#line 152 "marshalling-test.vala"
	error_thrown = FALSE;
#line 962 "marshalling-test.c"
	{
		GVariant* _tmp36_;
		ZeitgeistSubject* _tmp37_;
		ZeitgeistSubject* _tmp38_;
#line 155 "marshalling-test.vala"
		_tmp36_ = v;
#line 155 "marshalling-test.vala"
		_tmp37_ = zeitgeist_subject_new_from_variant (_tmp36_, &_inner_error0_);
#line 155 "marshalling-test.vala"
		_tmp38_ = _tmp37_;
#line 155 "marshalling-test.vala"
		_g_object_unref0 (_tmp38_);
#line 155 "marshalling-test.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 155 "marshalling-test.vala"
			if (_inner_error0_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
#line 979 "marshalling-test.c"
				goto __catch0_zeitgeist_data_model_error;
			}
#line 155 "marshalling-test.vala"
			arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 155 "marshalling-test.vala"
			_g_variant_unref0 (v);
#line 155 "marshalling-test.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 155 "marshalling-test.vala"
			g_clear_error (&_inner_error0_);
#line 155 "marshalling-test.vala"
			return;
#line 992 "marshalling-test.c"
		}
	}
	goto __finally0;
	__catch0_zeitgeist_data_model_error:
	{
		GError* err = NULL;
		GError* _tmp39_;
#line 153 "marshalling-test.vala"
		err = _inner_error0_;
#line 153 "marshalling-test.vala"
		_inner_error0_ = NULL;
#line 159 "marshalling-test.vala"
		_tmp39_ = err;
#line 159 "marshalling-test.vala"
		_vala_assert (g_error_matches (_tmp39_, ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE), "err is DataModelError.INVALID_SIGNATURE");
#line 160 "marshalling-test.vala"
		error_thrown = TRUE;
#line 153 "marshalling-test.vala"
		_g_error_free0 (err);
#line 1012 "marshalling-test.c"
	}
	__finally0:
#line 153 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "marshalling-test.vala"
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 153 "marshalling-test.vala"
		_g_variant_unref0 (v);
#line 153 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 153 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 153 "marshalling-test.vala"
		return;
#line 1027 "marshalling-test.c"
	}
#line 162 "marshalling-test.vala"
	_vala_assert (error_thrown, "error_thrown");
#line 165 "marshalling-test.vala"
	_tmp40_ = g_variant_new ("(x)", 42, NULL);
#line 165 "marshalling-test.vala"
	g_variant_ref_sink (_tmp40_);
#line 165 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 165 "marshalling-test.vala"
	v = _tmp40_;
#line 166 "marshalling-test.vala"
	error_thrown = FALSE;
#line 1041 "marshalling-test.c"
	{
		GVariant* _tmp41_;
		ZeitgeistSubject* _tmp42_;
		ZeitgeistSubject* _tmp43_;
#line 169 "marshalling-test.vala"
		_tmp41_ = v;
#line 169 "marshalling-test.vala"
		_tmp42_ = zeitgeist_subject_new_from_variant (_tmp41_, &_inner_error0_);
#line 169 "marshalling-test.vala"
		_tmp43_ = _tmp42_;
#line 169 "marshalling-test.vala"
		_g_object_unref0 (_tmp43_);
#line 169 "marshalling-test.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 169 "marshalling-test.vala"
			if (g_error_matches (_inner_error0_, ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE)) {
#line 1058 "marshalling-test.c"
				goto __catch1_zeitgeist_data_model_error_invalid_signature;
			}
			goto __finally1;
		}
	}
	goto __finally1;
	__catch1_zeitgeist_data_model_error_invalid_signature:
	{
#line 167 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 173 "marshalling-test.vala"
		error_thrown = TRUE;
#line 1071 "marshalling-test.c"
	}
	__finally1:
#line 167 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 167 "marshalling-test.vala"
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 167 "marshalling-test.vala"
		_g_variant_unref0 (v);
#line 167 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 167 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 167 "marshalling-test.vala"
		return;
#line 1086 "marshalling-test.c"
	}
#line 175 "marshalling-test.vala"
	_vala_assert (error_thrown, "error_thrown");
#line 130 "marshalling-test.vala"
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
#line 130 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 1094 "marshalling-test.c"
}

void
corrupt_timerange_test (void)
{
	GVariant* v = NULL;
	GVariant* _tmp0_;
	gboolean error_thrown = FALSE;
	GError* _inner_error0_ = NULL;
#line 180 "marshalling-test.vala"
	_tmp0_ = g_variant_new ("(s)", "oh noes, what is this?", NULL);
#line 180 "marshalling-test.vala"
	g_variant_ref_sink (_tmp0_);
#line 180 "marshalling-test.vala"
	v = _tmp0_;
#line 181 "marshalling-test.vala"
	error_thrown = FALSE;
#line 1112 "marshalling-test.c"
	{
		ZeitgeistTimeRange* _tmp1_;
		ZeitgeistTimeRange* _tmp2_;
#line 184 "marshalling-test.vala"
		_tmp1_ = zeitgeist_time_range_new_from_variant (v, &_inner_error0_);
#line 184 "marshalling-test.vala"
		_tmp2_ = _tmp1_;
#line 184 "marshalling-test.vala"
		_g_object_unref0 (_tmp2_);
#line 184 "marshalling-test.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "marshalling-test.vala"
			if (g_error_matches (_inner_error0_, ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE)) {
#line 1126 "marshalling-test.c"
				goto __catch0_zeitgeist_data_model_error_invalid_signature;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_zeitgeist_data_model_error_invalid_signature:
	{
#line 182 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 188 "marshalling-test.vala"
		error_thrown = TRUE;
#line 1139 "marshalling-test.c"
	}
	__finally0:
#line 182 "marshalling-test.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 182 "marshalling-test.vala"
		_g_variant_unref0 (v);
#line 182 "marshalling-test.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 182 "marshalling-test.vala"
		g_clear_error (&_inner_error0_);
#line 182 "marshalling-test.vala"
		return;
#line 1152 "marshalling-test.c"
	}
#line 178 "marshalling-test.vala"
	_g_variant_unref0 (v);
#line 1156 "marshalling-test.c"
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

